/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class PullSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected boolean toOrigin;
    protected double velocity;

    public PullSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.velocity = mlc.getDouble("velocity", 1.0);
        this.velocity = mlc.getDouble("v", this.velocity);
        this.velocity /= 10.0;
        this.toOrigin = mlc.getBoolean(new String[]{"toorigin", "to"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Location l = this.toOrigin ? BukkitAdapter.adapt(data.getOrigin()) : BukkitAdapter.adapt(data.getCaster().getEntity()).getLocation();
        Entity t = BukkitAdapter.adapt(target);
        double distance = l.distance(t.getLocation());
        double modxz = distance * 0.5 * this.velocity;
        double mody = distance * 0.34 * this.velocity;
        mody = l.getY() - target.getLocation().getY() != 0.0 ? mody * (Math.abs(l.getY() - target.getLocation().getY()) * 0.5) : mody;
        Vector direction = t.getLocation().toVector().subtract(l.toVector()).normalize().multiply(this.velocity);
        direction.setX(direction.getX() * -1.0 * modxz);
        direction.setZ(direction.getZ() * -1.0 * modxz);
        direction.setY(direction.getY() * -1.0 * mody);
        t.setVelocity(direction);
        return true;
    }
}

