/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class HealSkill
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected float amount = 1.0f;
    protected boolean overheal = false;

    public HealSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = (float)mlc.getDouble(new String[]{"amount", "a"}, 1.0);
        this.overheal = mlc.getBoolean(new String[]{"overheal", "oh"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return false;
        }
        double health = target.getHealth() + (double)this.amount;
        if (health >= target.getMaxHealth()) {
            if (this.overheal) {
                target.setMaxHealth(health);
                target.setHealth(health);
            } else {
                target.setHealth(target.getMaxHealth());
            }
        } else {
            target.setHealth(health);
        }
        return true;
    }
}

