/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class HealPercentMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected float multiplier = 0.1f;
    protected boolean overheal = false;

    public HealPercentMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.multiplier = (float)mlc.getDouble(new String[]{"multiplier", "m"}, 0.1);
        this.overheal = mlc.getBoolean("overheal", false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return false;
        }
        double heal = target.getMaxHealth() * (double)this.multiplier;
        double health = target.getHealth() + heal;
        if (health >= target.getMaxHealth()) {
            if (this.overheal) {
                target.setMaxHealth(health);
                target.setHealth(health);
            } else {
                target.setHealth(target.getMaxHealth());
            }
        } else {
            target.setHealth(health);
        }
        return true;
    }
}

