/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class FireworkEffect
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int type;
    protected int flightDuration;
    protected int[] colors;
    protected int[] fadeColors;
    protected boolean flicker;
    protected boolean trail;

    public FireworkEffect(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.type = mlc.getInteger("type", 0);
        this.type = mlc.getInteger("t", this.type);
        this.flightDuration = mlc.getInteger("duration", 0);
        this.flightDuration = mlc.getInteger("d", this.flightDuration);
        this.flicker = mlc.getBoolean("flicker", false);
        this.flicker = mlc.getBoolean("f", this.flicker);
        this.trail = mlc.getBoolean("trail", false);
        this.trail = mlc.getBoolean("tr", this.trail);
        String colors = mlc.getString("colors");
        colors = mlc.getString("c", colors);
        this.colors = new int[]{0xFF0000};
        if (colors != null) {
            String[] c = colors.split(",");
            this.colors = new int[c.length];
            for (int i = 0; i < c.length; ++i) {
                this.colors[i] = Integer.parseInt(c[i], 16);
            }
        }
        String fadeColors = mlc.getString("fadecolors");
        fadeColors = mlc.getString("fc", colors);
        this.fadeColors = new int[]{0xFF0000};
        if (fadeColors != null) {
            String[] c = colors.split(",");
            this.fadeColors = new int[c.length];
            for (int i = 0; i < c.length; ++i) {
                this.fadeColors[i] = Integer.parseInt(c[i], 16);
            }
        }
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return false;
    }

    protected void playEffect(AbstractLocation l) {
        MythicMobs.inst().getVolatileCodeHandler().CreateFireworksExplosion(BukkitAdapter.adapt(l), this.flicker, this.trail, this.type, this.colors, this.fadeColors, this.flightDuration);
    }
}

