/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class EnderBeamMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected int duration;
    protected float yOffset;

    public EnderBeamMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.duration = mlc.getInteger(new String[]{"duration", "d"}, 60);
        this.yOffset = mlc.getFloat(new String[]{"yoffset", "yo", "y"}, 0.0f);
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        new Animator(BukkitAdapter.adapt(data.getCaster().getEntity()), BukkitAdapter.adapt(target), this.duration);
        return false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Animator(BukkitAdapter.adapt(data.getCaster().getEntity()), BukkitAdapter.adapt(target), this.duration);
        return false;
    }

    private class Animator
    implements Runnable {
        private EnderCrystal crystal;
        private Location locationSource;
        private Entity entitySource;
        private Entity entity;
        private Location location;
        private int interval = 1;
        private int duration;
        private int iteration;
        private int taskId;

        public Animator(Entity source, Location location, int duration) {
            this.entitySource = source;
            this.location = location;
            this.start(duration);
        }

        public Animator(Entity source, Entity entity, int duration) {
            this.entitySource = source;
            this.entity = entity;
            this.start(duration);
        }

        public Animator(Location source, Location location, int duration) {
            this.locationSource = source;
            this.location = location;
            this.start(duration);
        }

        public Animator(Location source, Entity entity, int duration) {
            this.locationSource = source;
            this.entity = entity;
            this.start(duration);
        }

        protected void start(int duration) {
            this.crystal = (EnderCrystal)this.entitySource.getWorld().spawnEntity(this.entitySource.getLocation().add(0.0, (double)EnderBeamMechanic.this.yOffset, 0.0), EntityType.ENDER_CRYSTAL);
            this.crystal.setShowingBottom(false);
            this.crystal.setInvulnerable(true);
            this.duration = duration;
            this.iteration = 0;
            this.taskId = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)MythicMobs.inst(), (Runnable)this, 0L, (long)this.interval);
        }

        @Override
        public void run() {
            if (this.iteration > this.duration) {
                this.crystal.remove();
                Bukkit.getScheduler().cancelTask(this.taskId);
            } else {
                Location source = this.locationSource != null ? this.locationSource : this.entitySource.getLocation();
                source = source.add(0.0, (double)EnderBeamMechanic.this.yOffset, 0.0);
                Location target = this.location != null ? this.location : this.entity.getLocation();
                this.crystal.teleport(source);
                this.crystal.setBeamTarget(target);
                ++this.iteration;
            }
        }
    }
}

