/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.SkillAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.mechanics.DamageSkill;
import org.bukkit.entity.LivingEntity;

public class ConsumeSkill
extends DamageSkill
implements ITargetedEntitySkill {
    protected float damage;
    protected float heal;

    public ConsumeSkill(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.damage = mlc.getFloat(new String[]{"damage", "dmg", "d"}, 1.0f);
        this.heal = mlc.getFloat(new String[]{"heal", "h"}, 1.0f);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        LivingEntity consumer = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        SkillAdapter.get().doDamage(data.getCaster(), target, this.damage * data.getPower(), this.ignore_armor, this.preventKnockback, this.preventImmunity);
        float modheal = this.heal * data.getPower();
        if (consumer.getHealth() + (double)modheal >= consumer.getMaxHealth()) {
            consumer.setHealth(consumer.getMaxHealth());
        } else {
            consumer.setHealth(consumer.getHealth() + (double)modheal);
        }
        return true;
    }
}

