/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConsumeHeldItemMechanic
extends SkillMechanic
implements INoTargetSkill {
    private int amount;

    public ConsumeHeldItemMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 1);
    }

    @Override
    public boolean cast(SkillMetadata data) {
        if (!data.getCaster().getEntity().isPlayer()) {
            return false;
        }
        Player player = (Player)data.getCaster().getEntity().getBukkitEntity();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item != null) {
            int newAmount = item.getAmount() - this.amount;
            if (newAmount <= 0) {
                player.getInventory().setItem(player.getInventory().getHeldItemSlot(), new ItemStack(Material.AIR));
            } else {
                item.setAmount(newAmount);
            }
        }
        return true;
    }
}

