/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.types.RangedDouble;

public class HasPotionEffectCondition
extends SkillCondition
implements IEntityCondition {
    private final String effectType;
    private final boolean checkAll;
    private RangedDouble level = null;
    private RangedDouble duration = null;

    public HasPotionEffectCondition(String line, MythicLineConfig mlc) {
        super(line);
        String strDuration;
        this.effectType = mlc.getString(new String[]{"type", "t"}, this.conditionVar, "ANY").toUpperCase();
        this.checkAll = this.effectType.equals("ANY");
        String strLevel = mlc.getString(new String[]{"level", "lvl", "l"}, null, new String[0]);
        if (strLevel != null) {
            this.level = new RangedDouble(strLevel);
        }
        if ((strDuration = mlc.getString(new String[]{"duration", "d"}, null, new String[0])) != null) {
            this.duration = new RangedDouble(strDuration);
        }
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (this.checkAll) {
            return entity.hasPotionEffect();
        }
        MythicMobs.debug(1, "Checking if target has PotionEffect type = " + this.effectType + ", level = " + this.level + ", d = " + this.duration);
        MythicMobs.debug(1, "Returning " + entity.hasPotionEffect(this.effectType, this.level, this.duration));
        return entity.hasPotionEffect(this.effectType, this.level, this.duration);
    }
}

