/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationComparisonCondition;
import io.lumine.xikage.mythicmobs.util.types.RangedDouble;

public class DistanceCondition
extends SkillCondition
implements IEntityComparisonCondition,
ILocationComparisonCondition {
    protected RangedDouble distance;

    public DistanceCondition(String line, MythicLineConfig mlc) {
        super(line);
        String d = mlc.getString(new String[]{"distance", "d"}, this.conditionVar, new String[0]);
        this.distance = new RangedDouble(d, true);
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractEntity target) {
        double diffSq = (float)entity.getLocation().distanceSquared(target.getLocation());
        return this.distance.equals(diffSq);
    }

    @Override
    public boolean check(AbstractLocation location, AbstractLocation target) {
        double diffSq = (float)location.distanceSquared(target);
        return this.distance.equals(diffSq);
    }
}

