/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.TaskManager;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.AbstractSkill;
import io.lumine.xikage.mythicmobs.skills.IMetaSkill;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.mechanics.CustomMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SudoSkillMechanic;
import io.lumine.xikage.mythicmobs.skills.targeters.ConsoleTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.skills.targeters.IPathSelector;
import io.lumine.xikage.mythicmobs.skills.targeters.MPEntity;
import io.lumine.xikage.mythicmobs.skills.targeters.MPLocation;
import io.lumine.xikage.mythicmobs.skills.targeters.MTOrigin;
import io.lumine.xikage.mythicmobs.skills.targeters.MTTriggerLocation;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkillMechanic
extends AbstractSkill {
    protected int interval = 0;
    protected long clock = 0L;
    protected String line;
    protected boolean forceSync = false;
    protected boolean targetIsOrigin = false;
    protected boolean target_creative = false;
    protected Optional<AbstractLocation> originOverride;
    protected Optional<SkillTargeter> targeter = Optional.empty();

    public SkillMechanic(String skill, MythicLineConfig mlc, int interval) {
        this.interval = interval + (ConfigManager.ClockInterval - interval % ConfigManager.ClockInterval);
        this.init(skill, mlc);
    }

    public SkillMechanic(String skill, MythicLineConfig mlc) {
        this.init(skill, mlc);
    }

    public void init(String skill, MythicLineConfig mlc) {
        String[] split;
        this.line = skill;
        this.cooldown = mlc.getInteger("cooldown", 0);
        this.cooldown = (float)mlc.getDouble("cd", (double)this.cooldown);
        this.delay = mlc.getInteger("delay", 0);
        this.repeat = mlc.getInteger("repeat", 0);
        this.repeatInterval = mlc.getInteger(new String[]{"repeatinterval", "repeati"}, 0);
        this.power = mlc.getFloat("power", 1.0f);
        this.powerSplitBetweenTargets = mlc.getBoolean(new String[]{"powersplitbetweentargets", "powersplit", "splitpower"}, false);
        this.forceSync = mlc.getBoolean(new String[]{"forcesync", "sync"}, false);
        this.targetIsOrigin = mlc.getBoolean("targetisorigin", false);
        this.sourceIsOrigin = mlc.getBoolean("sourceisorigin", false);
        this.sourceIsOrigin = mlc.getBoolean("castfromorigin", this.sourceIsOrigin);
        this.sourceIsOrigin = mlc.getBoolean("fromorigin", this.sourceIsOrigin);
        String originOverride = mlc.getString("origin", null);
        if (originOverride != null) {
            split = originOverride.split(",");
            int x = Integer.valueOf(split[0]);
            int y = Integer.valueOf(split[1]);
            int z = Integer.valueOf(split[2]);
            AbstractLocation o = new AbstractLocation(null, x, y, z);
            this.originOverride = Optional.of(o);
        } else {
            this.originOverride = Optional.empty();
        }
        this.target_creative = mlc.getBoolean("targetcreative", this.target_creative);
        split = skill.split(" ");
        for (int i = 1; i < split.length; ++i) {
            if (split[i].contains("@")) {
                this.targeter = Optional.of(SkillMechanic.parseSkillTargeter(split[i]));
                continue;
            }
            if (split[i].contains("~")) {
                this.trigger = SkillMechanic.parseSkillTrigger(split[i]);
                continue;
            }
            if (split[i].startsWith("=") || split[i].startsWith(">") || split[i].startsWith("<")) {
                this.healthMod = split[i];
                continue;
            }
            if (!split[i].matches("[0-9]*[.]?[0-9]+")) continue;
            this.chance = Float.parseFloat(split[i]);
        }
        if (this.trigger == null) {
            this.trigger = SkillTrigger.COMBAT;
        }
        MythicMobs.inst().registerSkillEvents(this);
    }

    public String getConfigLine() {
        return this.line;
    }

    public void setAsyncSafe(boolean bool) {
        this.ASYNC_SAFE = bool;
    }

    public boolean isAsyncSafe() {
        return this.ASYNC_SAFE;
    }

    public void setTargetsCreativePlayers(boolean b) {
        this.target_creative = b;
    }

    public boolean targetsCreativePlayers() {
        return this.target_creative;
    }

    public void setTimerInterval(int interval) {
        this.interval = interval;
    }

    public int getTimerInterval() {
        return this.interval;
    }

    public void resetClock() {
        this.clock = 0L;
    }

    public void tickClock() {
        this.clock += (long)ConfigManager.ClockInterval;
    }

    public long getClock() {
        return this.clock;
    }

    public boolean usable(SkillCaster skillCaster, SkillTrigger trigger) {
        MythicMobs.debug(3, "-- Checking if skill usable...");
        if (!this.checkSkillTrigger(trigger)) {
            MythicMobs.debug(4, "---- SkillMechanic not usable: SkillTrigger check failed.");
            return false;
        }
        if (this.onCooldown(skillCaster)) {
            MythicMobs.debug(4, "---- SkillMechanic not usable: Cooldown check failed.");
            return false;
        }
        if (skillCaster instanceof ActiveMob && !this.checkHealth(skillCaster)) {
            MythicMobs.debug(4, "---- SkillMechanic not usable: Health check failed.");
            return false;
        }
        if (!this.rollChance()) {
            MythicMobs.debug(4, "---- SkillMechanic not usable: Roll failed.");
            return false;
        }
        MythicMobs.debug(3, "---- AbstractSkill usable! Returning TRUE");
        return true;
    }

    public boolean usable(SkillCaster am) {
        MythicMobs.debug(3, "-- Checking if skill usable...");
        if (this.onCooldown(am)) {
            return false;
        }
        if (am instanceof ActiveMob && !this.checkHealth(am)) {
            return false;
        }
        if (!this.rollChance()) {
            return false;
        }
        MythicMobs.debug(3, "---- AbstractSkill usable! Returning TRUE");
        return true;
    }

    public boolean execute(SkillMetadata oData) {
        SkillMechanic skill;
        final SkillMetadata data = oData.deepClone();
        if (this.originOverride.isPresent()) {
            AbstractLocation o = this.originOverride.get();
            data.setOrigin(new AbstractLocation(data.getCaster().getLocation().getWorld(), o.getX(), o.getY(), o.getZ()));
        }
        if (this.repeat > 0 && this.repeatInterval > 0) {
            skill = this;
            final int repeatz = this.repeat;
            new Runnable(){
                private int ticks = 0;
                private int repeats = repeatz;
                private int taskId;
                {
                    this.taskId = TaskManager.get().scheduleTask(this, SkillMechanic.this.delay, SkillMechanic.this.repeatInterval);
                }

                @Override
                public void run() {
                    skill.executeSkills(data.deepClone());
                    ++this.ticks;
                    if (this.ticks > this.repeats) {
                        TaskManager.get().cancelTask(this.taskId);
                    }
                }
            };
            return true;
        }
        if (this.delay == 0) {
            return this.executeSkills(data);
        }
        skill = this;
        TaskManager.get().runLater(new Runnable(){

            @Override
            public void run() {
                skill.executeSkills(data);
            }
        }, this.delay);
        return true;
    }

    public boolean executeSkills(SkillTrigger skilltrigger, ActiveMob am, AbstractEntity trigger, AbstractLocation origin, HashSet<AbstractEntity> eTargets, HashSet<AbstractLocation> lTargets, float power) {
        SkillMetadata data = new SkillMetadata(skilltrigger, am, trigger, origin, eTargets, lTargets, power);
        return this.executeSkills(data);
    }

    public boolean executeSkills(final SkillMetadata data) {
        SkillMechanic mechanic;
        if (data.getOrigin() == null) {
            data.setOrigin(data.getCaster().getEntity().getLocation());
        }
        data.setPower(data.getPower() * this.power);
        MythicMobs.debug(3, "-- Executing AbstractSkill with power " + data.getPower() + " line: " + this.line);
        if (this instanceof SudoSkillMechanic) {
            ((SudoSkillMechanic)this).cast(data);
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        if (this.targeter.isPresent()) {
            SkillTargeter targeter = this.targeter.get();
            if (targeter instanceof IEntitySelector) {
                data.setEntityTargets(((IEntitySelector)targeter).getEntities(data));
                ((IEntitySelector)targeter).filter(data, this.targetsCreativePlayers());
            }
            if (targeter instanceof ILocationSelector) {
                data.setLocationTargets(((ILocationSelector)targeter).getLocations(data));
                ((ILocationSelector)targeter).filter(data);
            } else if (targeter instanceof MTOrigin) {
                data.setLocationTargets(((MTOrigin)targeter).getLocation(data.getOrigin()));
            } else if (targeter instanceof MTTriggerLocation) {
                HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
                lTargets.add(data.getTrigger().getLocation());
                data.setLocationTargets(lTargets);
            }
            if (targeter instanceof ConsoleTargeter) {
                data.setEntityTargets(null);
                data.setLocationTargets(null);
            }
        }
        if (data.getEntityTargets() != null && data.getEntityTargets().size() > 0 && this.powerSplitBetweenTargets) {
            data.setPower(data.getPower() / (float)data.getEntityTargets().size());
        }
        if (data.getLocationTargets() != null && data.getLocationTargets().size() > 0 && this.powerSplitBetweenTargets) {
            data.setPower(data.getPower() / (float)data.getLocationTargets().size());
        }
        if (this instanceof CustomMechanic && ((CustomMechanic)this).getMechanic().isPresent()) {
            MythicMobs.debug(3, "---- SkillMechanic is a CUSTOM mechanic");
            mechanic = ((CustomMechanic)this).getMechanic().get();
        } else {
            mechanic = this;
        }
        if (mechanic instanceof IMetaSkill) {
            MythicMobs.debug(3, "---- SkillMechanic is a META mechanic. Executing...");
            ((IMetaSkill)((Object)mechanic)).cast(data);
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        if (mechanic instanceof ITargetedEntitySkill && mechanic instanceof ITargetedLocationSkill) {
            MythicMobs.debug(3, "---- SkillMechanic accepts multiple types...");
            if (this.targeter.isPresent() && this.targeter.get() instanceof IPathSelector) {
                MythicMobs.debug(3, "---- Targeter is PATH SELECTOR");
                if (this.targeter.get() instanceof MPEntity) {
                    MythicMobs.debug(3, "------ SkillMechanic set as ENTITY skill. Executing...");
                    SkillMechanic.executeTargetedEntitySkill(mechanic, data);
                    this.setCooldown(data.getCaster(), this.cooldown);
                    return true;
                }
                if (this.targeter.get() instanceof MPLocation) {
                    MythicMobs.debug(3, "------ SkillMechanic set as LOCATION skill. Executing...");
                    SkillMechanic.executeTargetedLocationSkill(mechanic, data);
                    this.setCooldown(data.getCaster(), this.cooldown);
                    return true;
                }
            }
        }
        AbstractLocation fOrigin = data.getOrigin();
        if (data.getEntityTargets() != null) {
            HashSet feTargets = (HashSet)data.getEntityTargets().clone();
        } else {
            Object feTargets = null;
        }
        if (data.getLocationTargets() != null) {
            HashSet flTargets = (HashSet)data.getLocationTargets().clone();
        } else {
            Object flTargets = null;
        }
        if (mechanic instanceof ITargetedEntitySkill && data.getEntityTargets() != null && data.getEntityTargets().size() > 0) {
            MythicMobs.debug(3, "---- AbstractSkill is an ENTITY skill. Executing...");
            if (data.getIsAsync() && !this.ASYNC_SAFE) {
                new BukkitRunnable(){

                    public void run() {
                        SkillMechanic.executeTargetedEntitySkill(mechanic, data);
                    }
                }.runTask((Plugin)MythicMobs.inst());
            } else {
                SkillMechanic.executeTargetedEntitySkill(mechanic, data);
            }
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        if (mechanic instanceof ITargetedLocationSkill && data.getLocationTargets() != null && data.getLocationTargets().size() > 0) {
            MythicMobs.debug(3, "---- AbstractSkill is a LOCATION skill. Executing...");
            if (data.getIsAsync() && !this.ASYNC_SAFE) {
                new BukkitRunnable(){

                    public void run() {
                        SkillMechanic.executeTargetedLocationSkill(mechanic, data);
                    }
                }.runTask((Plugin)MythicMobs.inst());
            } else {
                SkillMechanic.executeTargetedLocationSkill(mechanic, data);
            }
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        if (mechanic instanceof INoTargetSkill) {
            MythicMobs.debug(3, "---- AbstractSkill is a NO-TARGET skilll. Executing...");
            if (data.getIsAsync() && !this.ASYNC_SAFE) {
                new BukkitRunnable(){

                    public void run() {
                        SkillMechanic.executeNoTargetSkill(mechanic, data);
                    }
                }.runTask((Plugin)MythicMobs.inst());
            } else {
                SkillMechanic.executeNoTargetSkill(mechanic, data);
            }
            this.setCooldown(data.getCaster(), this.cooldown);
            return true;
        }
        MythicMobs.debug(3, "---- No targets available. Cancelling.");
        return false;
    }

    protected static void executeTargetedEntitySkill(SkillMechanic mechanic, SkillMetadata data) {
        data.getEntityTargets().forEach(target -> {
            if (mechanic.targetIsOrigin) {
                ((ITargetedEntitySkill)((Object)mechanic)).castAtEntity(data.deepClone().setOrigin(target.getLocation()), (AbstractEntity)target);
            } else {
                ((ITargetedEntitySkill)((Object)mechanic)).castAtEntity(data, (AbstractEntity)target);
            }
        });
    }

    protected static void executeTargetedLocationSkill(SkillMechanic mechanic, SkillMetadata data) {
        data.getLocationTargets().forEach(target -> {
            if (mechanic.targetIsOrigin) {
                ((ITargetedLocationSkill)((Object)mechanic)).castAtLocation(data.deepClone().setOrigin((AbstractLocation)target), (AbstractLocation)target);
            } else {
                ((ITargetedLocationSkill)((Object)mechanic)).castAtLocation(data, (AbstractLocation)target);
            }
        });
    }

    protected static void executeNoTargetSkill(SkillMechanic mechanic, SkillMetadata data) {
        ((INoTargetSkill)((Object)mechanic)).cast(data);
    }

    public boolean getRunAsync() {
        return !this.forceSync;
    }
}

