/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.legacy.LegacySkillHandler;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillHelper;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import java.util.HashMap;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.event.Listener;

public abstract class AbstractSkill
implements Listener {
    protected boolean ASYNC_SAFE = true;
    public static long cooldownTimer = 0L;
    protected UUID uuid;
    protected float cooldown = 0.0f;
    protected float power = 0.0f;
    protected float powerScale = 1.0f;
    protected int delay = 0;
    protected int repeat;
    protected int repeatInterval = 0;
    protected float chance = 1.0f;
    protected String healthMod = null;
    protected boolean powerSplitBetweenTargets = false;
    protected SkillTrigger trigger = SkillTrigger.COMBAT;
    protected boolean sourceIsOrigin = false;
    protected HashMap<UUID, Long> cooldowns = new HashMap();

    public AbstractSkill() {
        this.uuid = UUID.randomUUID();
    }

    public SkillTrigger getTrigger() {
        return this.trigger;
    }

    public boolean onCooldown(SkillCaster skillCaster) {
        if (this.cooldown == 0.0f) {
            return false;
        }
        Long next = this.cooldowns.get(skillCaster.getEntity().getUniqueId());
        return next != null && next >= cooldownTimer;
    }

    public void setCooldown(SkillCaster skillCaster, float cooldown) {
        if (cooldown > 0.0f) {
            this.cooldowns.put(skillCaster.getEntity().getUniqueId(), (long)((float)cooldownTimer + cooldown * 20.0f - 2.0f));
        } else {
            this.cooldowns.remove(skillCaster.getEntity().getUniqueId());
        }
    }

    public boolean rollChance() {
        if (this.chance == 1.0f) {
            return true;
        }
        return !(MythicMobs.r.nextFloat() > this.chance);
    }

    public boolean checkHealth(SkillCaster skillCaster) {
        String[] healthparts;
        MythicMobs.debug(3, "-- Performing Health Check for skill...");
        if (this.healthMod == null) {
            return true;
        }
        String[] stringArray = healthparts = this.healthMod.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            double bosshp;
            String health;
            String healthT = health = stringArray[i];
            String skillstr = skillCaster.getEntity().getUniqueId() + this.uuid.toString() + "#" + health;
            healthT = healthT.replace("%", "");
            healthT = healthT.replace("<", "");
            healthT = healthT.replace(">", "");
            healthT = healthT.replace("=", "");
            if (!(healthT = healthT.replace("-", "")).matches("[-+]?[0-9]*.?[0-9]+")) {
                return true;
            }
            double hp = Double.parseDouble(healthT);
            if (health.endsWith("%")) {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / 100.0;
            } else {
                bosshp = skillCaster.getEntity().getHealth() / skillCaster.getEntity().getMaxHealth();
                hp = Double.parseDouble(healthT) / skillCaster.getEntity().getMaxHealth();
            }
            MythicMobs.debug(3, "-- orighealth = " + health + ", Boss hp = " + bosshp + "%, skill %hp=" + hp);
            if (health.startsWith(">")) {
                MythicMobs.debug(4, "---- Parsing GREATER THAN for skill...");
                health = health.replace(">", "");
                if (!(bosshp > hp)) continue;
                return true;
            }
            if (health.startsWith("<")) {
                MythicMobs.debug(4, "---- Parsing LESS THAN for skill...");
                health = health.replace("<", "");
                if (!(bosshp < hp)) continue;
                return true;
            }
            if (health.startsWith("=")) {
                MythicMobs.debug(4, "---- Parsing EQUAL TO for skill...");
                health = health.replace("=", "");
                if (health.contains("-")) {
                    MythicMobs.debug(4, "---- Parsing RANGE for skill...");
                    String[] hps = health.split("-");
                    double hp1 = hps[0].endsWith("%") ? Double.parseDouble(hps[0].substring(0, hps[0].length() - 1)) / 100.0 : Double.parseDouble(hps[0].substring(0, hps[0].length())) / skillCaster.getEntity().getMaxHealth();
                    double hp2 = hps[1].endsWith("%") ? Double.parseDouble(hps[1].substring(0, hps[1].length() - 1)) / 100.0 : Double.parseDouble(hps[1].substring(0, hps[1].length())) / skillCaster.getEntity().getMaxHealth();
                    if (hp2 > hp1) {
                        double hp3 = hp1;
                        hp1 = hp2;
                        hp2 = hp3;
                    }
                    MythicMobs.debug(4, "------ RANGE scaled to " + hp1 + "-" + hp2);
                    if (!(bosshp > hp2) || !(bosshp < hp1)) continue;
                    return true;
                }
                if (!(bosshp <= hp) || !(skillCaster.getEntity().getHealth() > hp) || SkillHelper.hasUsedSkill(skillstr, skillCaster.getEntity())) continue;
                if (skillCaster instanceof ActiveMob && !((ActiveMob)skillCaster).getType().repeatAllSkills) {
                    MythicMobs.inst().getMobManager();
                    MobManager.setMetaData(skillCaster.getEntity(), skillstr, skillstr);
                }
                return true;
            }
            MythicMobs.debug(3, "-- AbstractSkill Health Check is invalid or not present? Assuming 100% up-time.");
            return true;
        }
        return false;
    }

    public boolean checkSkillTrigger(SkillTrigger trigger) {
        MythicMobs.debug(4, "------ checking SkillTrigger: " + (Object)((Object)trigger) + "");
        if (trigger == null) {
            return true;
        }
        if (trigger.equals((Object)SkillTrigger.SIGNAL)) {
            return true;
        }
        switch (this.trigger) {
            case TIMER: {
                return true;
            }
            case API: {
                return true;
            }
            case SIGNAL: {
                return true;
            }
            case COMBAT: {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK;
            }
            case KILL: {
                return trigger == SkillTrigger.KILL || trigger == SkillTrigger.KILLPLAYER;
            }
            case DEFAULT: {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK || trigger == SkillTrigger.SPAWN || trigger == SkillTrigger.DEATH || trigger == SkillTrigger.TIMER;
            }
        }
        return this.trigger.equals((Object)trigger);
    }

    public static SkillTrigger parseSkillTrigger(String strTrigger) {
        MythicMobs.debug(3, "-- Performing Trigger Check for skill...");
        String search = strTrigger.substring(3).toUpperCase();
        if (search.contains("onTimer")) {
            return SkillTrigger.TIMER;
        }
        switch (search) {
            case "SPAWN": {
                return SkillTrigger.SPAWN;
            }
            case "DEATH": {
                return SkillTrigger.DEATH;
            }
            case "COMBAT": {
                return SkillTrigger.COMBAT;
            }
            case "DAMAGED": 
            case "HURT": {
                return SkillTrigger.DAMAGED;
            }
            case "ATTACK": 
            case "HIT": {
                return SkillTrigger.ATTACK;
            }
            case "EXPLODE": {
                return SkillTrigger.EXPLODE;
            }
            case "TELEPORT": {
                return SkillTrigger.TELEPORT;
            }
            case "KILL": {
                return SkillTrigger.KILL;
            }
            case "KILLPLAYER": 
            case "PLAYERKILL": {
                return SkillTrigger.KILLPLAYER;
            }
            case "PLAYERDEATH": 
            case "PLAYERDIE": {
                return SkillTrigger.PLAYERDEATH;
            }
            case "ENTERCOMBAT": {
                return SkillTrigger.ENTERCOMBAT;
            }
            case "COMBATDROP": 
            case "DROPCOMBAT": {
                return SkillTrigger.DROPCOMBAT;
            }
            case "CHANGETARGET": 
            case "TARGETCHANGE": {
                return SkillTrigger.TARGETCHANGE;
            }
            case "INTERACT": {
                return SkillTrigger.INTERACT;
            }
            case "READY": 
            case "FIRSTSPAWN": {
                return SkillTrigger.READY;
            }
            case "SWING": {
                return SkillTrigger.SWING;
            }
            case "USE": {
                return SkillTrigger.USE;
            }
            case "SHOOT": 
            case "BOWSHOOT": {
                return SkillTrigger.SHOOT;
            }
            case "BOWHIT": {
                return SkillTrigger.BOW_HIT;
            }
            case "CONSUME": 
            case "EAT": {
                return SkillTrigger.CONSUME;
            }
            case "POTIONSPLASH": 
            case "SPLASHPOTION": {
                return SkillTrigger.SPLASH_POTION;
            }
            case "CROUCH": {
                return SkillTrigger.CROUCH;
            }
            case "UNCROUCH": {
                return SkillTrigger.UNCROUCH;
            }
            case "BLOCK": {
                return SkillTrigger.BLOCK;
            }
        }
        return SkillTrigger.DEFAULT;
    }

    public static SkillTargeter parseSkillTargeter(String strTarget) {
        String search = strTarget.substring(1);
        MythicLineConfig mlc = new MythicLineConfig(search);
        String name = search.contains("{") ? search.substring(0, search.indexOf("{")) : search;
        MythicMobs.debug(3, "-- Parsing Targeter '" + search + "' for skill...");
        return SkillTargeter.getMythicTargeter(name, mlc);
    }

    public static void RunTimerSkills(long timer) {
        for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
            am.tickGlobalCooldown(ConfigManager.ClockInterval);
            if (am.isDead() || !am.getEntity().isValid() || !am.getType().usingTimers) continue;
            AbstractSkill.ExecuteTimerSkills(am, timer);
        }
    }

    public static void RunLegacyTimerSkills(long timer) {
        if (ConfigManager.EnableLegacySkills) {
            for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                if (am.isDead() || !am.getEntity().isValid() || !am.getType().usingTimers) continue;
                LegacySkillHandler.ExecuteTimerSkills(am.getType().legacyTimerSkills, am, timer);
            }
        }
    }

    public static void ExecuteTimerSkills(ActiveMob am, long timer) {
        SkillMetadata data = new SkillMetadata(SkillTrigger.TIMER, am, null);
        data.setPower(am.getPower());
        for (SkillMechanic skill : am.getType().getTimerSkills()) {
            MythicMobs.inst().getTimingsHandler().markSkillNew(am.getType().getInternalName() + ":" + skill.line);
            if ((double)timer % ((double)skill.interval / (double)ConfigManager.ClockInterval) == 0.0 && skill.usable(am)) {
                skill.execute(data);
            }
            MythicMobs.inst().getTimingsHandler().markSkillComplete(am.getType().getInternalName() + ":" + skill.line);
        }
    }

    protected static class DelayedSkill
    implements Runnable {
        private SkillMetadata data;
        private Queue<SkillMechanic> skills;
        private boolean cancelled;

        public DelayedSkill(SkillMetadata data, Queue<SkillMechanic> skills) {
            this.data = data;
            this.skills = skills;
            this.cancelled = false;
        }

        public void cancel() {
            this.skills = null;
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                if (!(!this.data.getCaster().getEntity().isDead() || this.data.getCause().equals((Object)SkillTrigger.DEATH) && this.data.getCause().equals((Object)SkillTrigger.EXPLODE))) {
                    this.cancel();
                    return;
                }
                Skill.execute(this.data, this.skills);
                return;
            }
        }
    }
}

