/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs.entities;

import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.TNTPrimed;

public class MythicTNT
extends MythicEntity {
    private static final int height = 1;
    private int explosionFuseTicks = -1;
    private int explosionYield = -1;
    private boolean explosionIncendiary = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.explosionFuseTicks = mc.getInt("Options.FuseTicks", -1);
        this.explosionYield = mc.getInt("Options.ExplosionYield", -1);
        this.explosionIncendiary = mc.getBoolean("Options.Incendiary", false);
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        TNTPrimed e = (TNTPrimed)location.getWorld().spawnEntity(location, EntityType.PRIMED_TNT);
        e = this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        TNTPrimed e = (TNTPrimed)location.getWorld().spawnEntity(location, EntityType.PRIMED_TNT);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        TNTPrimed tnt = (TNTPrimed)entity;
        if (this.explosionFuseTicks > -1) {
            tnt.setFuseTicks(this.explosionFuseTicks);
        }
        if (this.explosionYield > -1) {
            tnt.setYield((float)this.explosionYield);
        }
        tnt.setIsIncendiary(this.explosionIncendiary);
        return tnt;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof FallingBlock;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

