/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.mobs.entities;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Zombie;

public class MythicHusk
extends MythicEntity {
    private static final int height = 2;
    private double reinforcementChance = -1.0;

    @Override
    public void instantiate(MythicConfig mc) {
        this.reinforcementChance = mc.getDouble("Options.ReinforcementsChance", -1.0);
    }

    @Override
    public Entity spawn(MythicMob mm, Location location) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            Husk e = (Husk)location.getWorld().spawnEntity(location, EntityType.HUSK);
            e.setBaby(false);
            return e;
        }
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(false);
        e.setVillagerProfession(Villager.Profession.HUSK);
        e = (Zombie)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity spawn(Location location) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            Husk e = (Husk)location.getWorld().spawnEntity(location, EntityType.HUSK);
            e.setBaby(false);
            return e;
        }
        Zombie e = (Zombie)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
        e.setBaby(false);
        e.setVillagerProfession(Villager.Profession.HUSK);
        e = (Zombie)this.applyOptions((Entity)e);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        if (MythicMobs.inst().getMinecraftVersion() >= 11) {
            Husk e = (Husk)entity;
            if (this.reinforcementChance >= 0.0) {
                if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                    e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
                } else {
                    MythicMobs.inst().getVolatileCodeHandler().setZombieSpawnReinforcements((Zombie)e, this.reinforcementChance);
                }
            }
            return e;
        }
        Zombie e = (Zombie)entity;
        if (this.reinforcementChance >= 0.0) {
            if (MythicMobs.inst().getMinecraftVersion() >= 9) {
                e.getAttribute(Attribute.ZOMBIE_SPAWN_REINFORCEMENTS).setBaseValue(this.reinforcementChance);
            } else {
                MythicMobs.inst().getVolatileCodeHandler().setZombieSpawnReinforcements(e, this.reinforcementChance);
            }
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return MythicHusk.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        return MythicMobs.inst().getMinecraftVersion() >= 11 ? e instanceof Husk && !((Husk)e).isBaby() : e instanceof Zombie && MythicMobs.inst().getMinecraftVersion() >= 10 && ((Zombie)e).getVillagerProfession() != null && ((Zombie)e).getVillagerProfession() == Villager.Profession.HUSK;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

