/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.legacy.commands;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicReloadedEvent;
import io.lumine.xikage.mythicmobs.legacy.commands.DebugCommands;
import io.lumine.xikage.mythicmobs.legacy.commands.EggCommands;
import io.lumine.xikage.mythicmobs.legacy.commands.ItemCommands;
import io.lumine.xikage.mythicmobs.legacy.commands.MobCommands;
import io.lumine.xikage.mythicmobs.legacy.commands.SpawnerCommands;
import io.lumine.xikage.mythicmobs.legacy.commands.TestCommands;
import io.lumine.xikage.mythicmobs.legacy.commands.UtilityCommands;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CommandHandler
implements CommandExecutor {
    public void menuCommands(CommandSender sender) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.GOLD + "/mm mobs" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Lists mob-related commands.");
        sender.sendMessage(ChatColor.GOLD + "/mm eggs" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Lists egg-related commands.");
        sender.sendMessage(ChatColor.GOLD + "/mm items" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Lists item-related commands.");
        sender.sendMessage(ChatColor.GOLD + "/mm spawners" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Lists spawner-related commands.");
        sender.sendMessage(ChatColor.GOLD + "/mm test" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Lists special commands used for testing.");
        sender.sendMessage(ChatColor.GOLD + "/mm utility" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Lists some helpful utility commands.");
        sender.sendMessage(ChatColor.YELLOW + "/mm reload" + ChatColor.GREEN + " - " + ChatColor.ITALIC + "Reloads all configuration files and mobs.");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandlabel, String[] args) {
        if (args.length == 0) {
            if (!sender.hasPermission("mythicmobs.admin")) {
                return false;
            }
            this.menuCommands(sender);
            return true;
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            if (!args[0].toLowerCase().equals("signal") && !p.hasPermission("mythicmobs.admin")) {
                return false;
            }
        }
        switch (args[0].toLowerCase()) {
            case "mobs": 
            case "mob": 
            case "m": {
                MobCommands.parseCommands(sender, cmd, commandlabel, args);
                break;
            }
            case "signal": {
                this.cmdSignal(sender, args);
                break;
            }
            case "items": 
            case "item": 
            case "i": {
                ItemCommands.parseCommands(sender, cmd, commandlabel, args);
                break;
            }
            case "eggs": 
            case "egg": 
            case "e": {
                EggCommands.parseCommands(sender, cmd, commandlabel, args);
                break;
            }
            case "spawners": 
            case "spawner": 
            case "s": {
                SpawnerCommands.parseCommands(sender, cmd, commandlabel, args);
                break;
            }
            case "test": 
            case "t": {
                TestCommands.parseCommands(sender, cmd, commandlabel, args);
                break;
            }
            case "utilities": 
            case "utility": 
            case "u": {
                UtilityCommands.parseCommands(sender, cmd, commandlabel, args);
                break;
            }
            case "reload": 
            case "r": {
                CommandHandler.cmdReload(sender, args);
                break;
            }
            case "debug": 
            case "d": {
                DebugCommands.parseCommands(sender, cmd, commandlabel, args);
                break;
            }
            case "save": {
                CommandHandler.cmdSave(sender, args);
                break;
            }
            case "info": {
                CommandHandler.cmdInfo(sender, args);
                break;
            }
            default: {
                this.menuCommands(sender);
            }
        }
        return true;
    }

    private void cmdSignal(CommandSender sender, String[] args) {
        String signal;
        UUID uuid;
        try {
            uuid = UUID.fromString(args[1]);
            signal = args[2];
        }
        catch (Exception ex) {
            sender.sendMessage(ChatColor.RED + "Signal skill must be in format: /mm signal <uuid> <signal>");
            return;
        }
        if (!MythicMobs.inst().getMobManager().isActiveMob(uuid)) {
            sender.sendMessage(ChatColor.RED + "Failed to send Signal: UUID does not correspond to a Mythic Mob.");
            return;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getActiveMob(uuid).get();
        AbstractPlayer trigger = null;
        if (sender instanceof Player) {
            if (!sender.hasPermission("mythicmobs.signal")) {
                sender.sendMessage(ChatColor.RED + "Failed to send Signal: You do not have permission to use that command!");
                return;
            }
            trigger = BukkitAdapter.adapt((Player)sender);
        }
        am.signalMob(trigger, signal);
    }

    public static void cmdReload(CommandSender sender, String[] args) {
        MythicMobs.inst().getConfigManager().SaveAll();
        MythicMobs.inst().getSpawnerManager().resetAndSaveAll();
        MythicMobs.inst().getConfigManager().ResetAll();
        MythicMobs.inst().getConfigManager().LoadAll(false);
        MythicMobs.inst().getRandomSpawningManager().reload();
        for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
            am.remountSpawner();
            am.remountType();
        }
        MythicReloadedEvent event = new MythicReloadedEvent(MythicMobs.inst());
        MythicMobs.inst().getServer().getPluginManager().callEvent((Event)event);
        sender.sendMessage(ChatColor.GOLD + "MythicMobs" + ChatColor.GREEN + " has been reloaded!");
    }

    public static void cmdSave(CommandSender sender, String[] args) {
    }

    public static void cmdInfo(CommandSender sender, String[] args) {
        sender.sendMessage(MythicMobs.menu_header);
        sender.sendMessage(ChatColor.GOLD + "MM Types Loaded: " + ChatColor.GRAY + MythicMobs.inst().getMobManager().getMobTypes().size() + "");
        sender.sendMessage(ChatColor.GOLD + "Spawners Loaded: " + ChatColor.GRAY + MythicMobs.inst().getSpawnerManager().getSpawners().size() + "");
        sender.sendMessage(ChatColor.GOLD + "Naturals Loaded: " + ChatColor.GRAY + MythicMobs.inst().getRandomSpawningManager().getNumberOfSpawners() + "");
        sender.sendMessage(ChatColor.GOLD + "----");
        sender.sendMessage(ChatColor.GOLD + "Active Mobs: " + ChatColor.GRAY + MythicMobs.inst().getMobManager().getActiveMobs().size() + "");
        sender.sendMessage(ChatColor.GOLD + "- in Combat: " + ChatColor.GRAY + MythicMobs.inst().getMobManager().getMobsInCombat().size() + "");
    }

    public static void NoConsole(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + "This command can't be cast from the console! :(");
    }
}

