/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.legacy;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.legacy.LegacyMythicTimerSkill;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillAIRunGoalSelector;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillAIRunTargetSelector;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillActivateSpawner;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillBarTimerMessage;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillCommand;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillCommandRadius;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillCommandRing;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillConsume;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillDamage;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillDamageAll;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillDamageSelf;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillDisguise;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillDismount;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillEffect;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillEjectPassenger;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillEquip;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillExplosion;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillForcePull;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillForcePullNear;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillGCD;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillHealSelf;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillIgnite;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillIgniteAll;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillJump;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillLeap;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillLightning;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillLightningAll;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillMessage;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillMount;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillMountPlayer;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillPotion;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillPotionMobs;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillPotionSelf;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillPull;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillPullAll;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillPushButton;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillRally;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillRandomSkill;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillRemoveMobs;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillRemoveSelf;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSendActionMessage;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSendTitle;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSetHealth;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSetMaxHealth;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSetName;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSetStance;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillShootFireball;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillShootPotion;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillShootProjectile;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillShootSkull;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSkill;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSkillRadius;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSkillRadiusAll;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSpawnPassenger;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSuicide;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillSummon;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillTargetChange;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillTeleport;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillTeleportLocation;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillTeleportNear;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillThrow;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillThrowAll;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillToggleLever;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillVolley;
import io.lumine.xikage.mythicmobs.legacy.skills.SkillWeather;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LegacySkillHandler {
    public static void ExecuteSkills(List<String> skills, final Entity e, final LivingEntity target, final SkillTrigger trigger) {
        if (!ConfigManager.EnableLegacySkills) {
            return;
        }
        if (SkillDamage.noloop) {
            return;
        }
        if (skills == null) {
            return;
        }
        for (final String skill : skills) {
            new BukkitRunnable(){

                public void run() {
                    LegacySkillHandler.ExecuteMobSkill(e, trigger, skill, target, false);
                }
            }.runTask((Plugin)MythicMobs.inst());
        }
    }

    public static void RunTimerSkills(long timer) {
        for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
            if (am.isDead() || !am.getEntity().isValid() || !am.getType().usingTimers) continue;
            LegacySkillHandler.ExecuteTimerSkills(am.getType().legacyTimerSkills, am, timer);
        }
    }

    public static void ExecuteTimerSkills(List<LegacyMythicTimerSkill> skills, final ActiveMob am, long timer) {
        if (SkillDamage.noloop) {
            return;
        }
        for (final LegacyMythicTimerSkill skill : skills) {
            MythicMobs.inst().getTimingsHandler().markSkillNew("LEGACY:" + am.getType().getInternalName() + ":" + skill);
            if (timer % (long)(skill.interval / ConfigManager.ClockInterval) == 0L) {
                Object target = am.getType().usesThreatTable() ? (am.getThreatTable().inCombat() ? (LivingEntity)BukkitAdapter.adapt(am.getThreatTable().getTopThreatHolder()) : null) : (am.getEntity() instanceof Creature ? ((Creature)am.getEntity()).getTarget() : (am.getEntity() instanceof Player ? MythicUtil.getTargetedEntity((Player)am.getEntity()) : null));
                final LivingEntity tar = target;
                new BukkitRunnable(){

                    public void run() {
                        LegacySkillHandler.ExecuteMobSkill(BukkitAdapter.adapt(am.getEntity()), SkillTrigger.TIMER, skill.skill, tar, false);
                    }
                }.runTask((Plugin)MythicMobs.inst());
            }
            MythicMobs.inst().getTimingsHandler().markSkillComplete("LEGACY:" + am.getType().getInternalName() + ":" + skill);
        }
    }

    public static void ExecuteMetaSkills(List<String> list, Entity l, LivingEntity p, SkillTrigger trigger) {
        ArrayList<String> DelayedSkills = new ArrayList<String>();
        boolean delayrest = false;
        int delayamount = 0;
        for (String line : list) {
            if (!delayrest) {
                String[] split = line.split(" ");
                if (split[0].equals("delay")) {
                    delayrest = true;
                    delayamount = Integer.parseInt(split[1]);
                    continue;
                }
                LegacySkillHandler.ExecuteMobSkill(l, trigger, line, p, true);
                continue;
            }
            DelayedSkills.add(line);
        }
        if (delayrest) {
            if (!l.getLocation().getChunk().isLoaded()) {
                return;
            }
            DelayedSkill ds = new DelayedSkill(DelayedSkills, l, p, trigger);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.inst(), (Runnable)ds, (long)delayamount);
        }
    }

    public static void ExecuteMobSkill(Entity e, SkillTrigger trigger, String skill, LivingEntity p, boolean meta) {
        if (!(e instanceof LivingEntity)) {
            return;
        }
        LivingEntity l = (LivingEntity)e;
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)l));
        double bosshp = l.getHealth();
        String[] split = skill.split(" ");
        if (split[0] == null) {
            MythicMobs.debug(3, "-- AbstractSkill string is null?! Returning void.");
            return;
        }
        if (split.length > 4 ? (split[split.length - 3].contains("~") ? !LegacySkillHandler.CheckTrigger(split[split.length - 3], trigger, l, skill, meta) : (split[split.length - 2].contains("~") ? !LegacySkillHandler.CheckTrigger(split[split.length - 2], trigger, l, skill, meta) : (split[split.length - 1].contains("~") ? !LegacySkillHandler.CheckTrigger(split[split.length - 1], trigger, l, skill, meta) : !LegacySkillHandler.CheckTrigger("~default", trigger, l, skill, meta)))) : (split.length > 3 ? (split[split.length - 2].contains("~") ? !LegacySkillHandler.CheckTrigger(split[split.length - 2], trigger, l, skill, meta) : (split[split.length - 1].contains("~") ? !LegacySkillHandler.CheckTrigger(split[split.length - 1], trigger, l, skill, meta) : !LegacySkillHandler.CheckTrigger("~default", trigger, l, skill, meta))) : (split.length > 2 ? (split[split.length - 1].contains("~") ? !LegacySkillHandler.CheckTrigger(split[split.length - 1], trigger, l, skill, meta) : !LegacySkillHandler.CheckTrigger("~default", trigger, l, skill, meta)) : !LegacySkillHandler.CheckTrigger("~default", trigger, l, skill, meta)))) {
            return;
        }
        if (split[split.length - 1].matches("[0-9]*[.]?[0-9]+")) {
            float chance = Float.parseFloat(split[split.length - 1]);
            if (MythicMobs.r.nextFloat() > chance) {
                MythicMobs.debug(3, "-- AbstractSkill chance " + chance + " failed! AbstractSkill not executed.");
                return;
            }
            if (!LegacySkillHandler.CheckHealth(split[split.length - 2], am.getEntity(), bosshp, skill)) {
                MythicMobs.debug(3, "-- AbstractSkill health range check " + split[split.length - 2] + " false! AbstractSkill not executed.");
                return;
            }
        } else if (!LegacySkillHandler.CheckHealth(split[split.length - 1], am.getEntity(), bosshp, skill)) {
            MythicMobs.debug(3, "-- AbstractSkill health range check " + split[split.length - 2] + " false! AbstractSkill not executed.");
            return;
        }
        if (!ConfigManager.apiUseSkillEvent || am != null) {
            // empty if block
        }
        MythicMobs.debug(2, "Executing skill" + split[0] + " from string: " + skill);
        switch (split[0].toLowerCase()) {
            case "activatespawner": 
            case "activate": 
            case "spawner": {
                SkillActivateSpawner.ExecuteSkill(l, skill);
                break;
            }
            case "airungoalselector": 
            case "aigoalselector": {
                SkillAIRunGoalSelector.ExecuteSkill(l, skill);
                break;
            }
            case "airuntargetselector": 
            case "aitargetselector": {
                SkillAIRunTargetSelector.ExecuteSkill(l, skill);
                break;
            }
            case "bartimer": 
            case "bartimermsg": 
            case "bartimermessage": {
                SkillBarTimerMessage.ExecuteSkill(l, skill, p);
                break;
            }
            case "command": 
            case "cmd": {
                SkillCommand.ExecuteSkill(l, skill, p);
                break;
            }
            case "ringcommand": 
            case "cmdring": 
            case "commandring": {
                SkillCommandRing.ExecuteSkill(l, skill);
                break;
            }
            case "consume": {
                SkillConsume.ExecuteSkill(l, skill);
                break;
            }
            case "damage": 
            case "dmg": {
                SkillDamage.ExecuteSkill(l, skill, p);
                break;
            }
            case "damageall": {
                SkillDamageAll.ExecuteSkill(l, skill, p);
                break;
            }
            case "damageself": 
            case "dmgself": {
                SkillDamageSelf.ExecuteSkill(l, skill);
                break;
            }
            case "disguise": {
                SkillDisguise.ExecuteSkill(l, skill);
                break;
            }
            case "dismount": {
                SkillDismount.ExecuteSkill(l, skill);
                break;
            }
            case "effect": {
                SkillEffect.ExecuteSkill(l, skill, p);
                break;
            }
            case "ejectpassenger": 
            case "eject": {
                SkillEjectPassenger.ExecuteSkill(l, skill);
                break;
            }
            case "explosion": {
                SkillExplosion.ExecuteSkill(l, skill, p);
                break;
            }
            case "equip": {
                SkillEquip.ExecuteSkill(l, skill);
                break;
            }
            case "gcd": {
                SkillGCD.ExecuteSkill(l, skill);
                break;
            }
            case "forcepull": {
                SkillForcePull.ExecuteSkill(l, skill, p);
                break;
            }
            case "forcepullnear": {
                SkillForcePullNear.ExecuteSkill(l, skill, p);
                break;
            }
            case "healself": 
            case "heal": {
                SkillHealSelf.ExecuteSkill(l, skill);
                break;
            }
            case "ignite": 
            case "fire": {
                SkillIgnite.ExecuteSkill(l, skill, p);
                break;
            }
            case "igniteall": 
            case "fireall": {
                SkillIgniteAll.ExecuteSkill(l, skill);
                break;
            }
            case "jump": {
                SkillJump.ExecuteSkill(l, skill, p);
                break;
            }
            case "leap": {
                SkillLeap.ExecuteSkill(l, skill, p);
                break;
            }
            case "lightning": {
                SkillLightning.ExecuteSkill(l, skill, p);
                break;
            }
            case "lightningall": {
                SkillLightningAll.ExecuteSkill(l, skill);
                break;
            }
            case "message": 
            case "msg": {
                SkillMessage.ExecuteSkill(l, skill, p);
                break;
            }
            case "mount": {
                SkillMount.ExecuteSkill(l, skill);
                break;
            }
            case "mountplayer": {
                SkillMountPlayer.ExecuteSkill(l, skill, p);
                break;
            }
            case "newtarget": {
                SkillTargetChange.ExecuteSkill(l, skill);
                break;
            }
            case "potion": {
                SkillPotion.ExecuteSkill(l, skill, p);
                break;
            }
            case "potionboss": 
            case "potionself": {
                SkillPotionSelf.ExecuteSkill(l, skill);
                break;
            }
            case "potionmobs": 
            case "potionallies": {
                SkillPotionMobs.ExecuteSkill(l, skill);
                break;
            }
            case "pull": {
                SkillPull.ExecuteSkill(l, skill, p);
                break;
            }
            case "pullall": {
                SkillPullAll.ExecuteSkill(l, skill);
                break;
            }
            case "pushbutton": 
            case "button": {
                SkillPushButton.ExecuteSkill(l, skill);
                break;
            }
            case "radiuscommand": 
            case "radiuscmd": {
                SkillCommandRadius.ExecuteSkill(l, skill);
                break;
            }
            case "rally": {
                SkillRally.ExecuteSkill(l, skill, p);
                break;
            }
            case "randomskill": 
            case "randompack": 
            case "randommeta": {
                SkillRandomSkill.ExecuteSkill(l, skill, p, trigger);
                break;
            }
            case "removeself": 
            case "remove": {
                SkillRemoveSelf.ExecuteSkill(l);
                break;
            }
            case "removemobs": {
                SkillRemoveMobs.ExecuteSkill(l, skill);
                break;
            }
            case "sethealth": {
                SkillSetHealth.ExecuteSkill(l, skill);
                break;
            }
            case "setmaxhealth": {
                SkillSetMaxHealth.ExecuteSkill(l, skill);
                break;
            }
            case "setname": {
                SkillSetName.ExecuteSkill(l, skill, p);
                break;
            }
            case "shootfireball": 
            case "fireball": {
                SkillShootFireball.ExecuteSkill(l, skill, p);
                break;
            }
            case "shootpotion": {
                SkillShootPotion.ExecuteSkill(l, skill, p);
                break;
            }
            case "shootprojectile": 
            case "projectile": {
                SkillShootProjectile.ExecuteSkill(l, skill, p);
                break;
            }
            case "shootskull": 
            case "witherskull": {
                SkillShootSkull.ExecuteSkill(l, skill, p);
                break;
            }
            case "sendactionmessage": 
            case "actionmessage": 
            case "actionmsg": 
            case "am": {
                SkillSendActionMessage.ExecuteSkill(l, skill, p);
                break;
            }
            case "sendtitle": 
            case "title": {
                SkillSendTitle.ExecuteSkill(l, skill, p);
                break;
            }
            case "skill": 
            case "pack": 
            case "meta": {
                SkillSkill.ExecuteSkill(l, skill, p, trigger);
                break;
            }
            case "skillradius": 
            case "radiusskill": {
                SkillSkillRadius.ExecuteSkill(l, skill, trigger);
                break;
            }
            case "skillradiusall": 
            case "radiusskillall": {
                SkillSkillRadiusAll.ExecuteSkill(l, skill, trigger);
                break;
            }
            case "summonpassenger": 
            case "spawnpassenger": {
                SkillSpawnPassenger.ExecuteSkill(l, skill);
                break;
            }
            case "setstance": 
            case "stance": {
                SkillSetStance.ExecuteSkill(l, skill);
                break;
            }
            case "suicide": {
                SkillSuicide.ExecuteSkill(l, skill);
                break;
            }
            case "summon": 
            case "swarm": {
                SkillSummon.ExecuteSkill(l, skill);
                break;
            }
            case "togglelever": {
                SkillToggleLever.ExecuteSkill(l, skill);
                break;
            }
            case "teleport": 
            case "tp": {
                SkillTeleport.ExecuteSkill(l, skill, p);
                break;
            }
            case "teleportnear": 
            case "tpnear": {
                SkillTeleportNear.ExecuteSkill(l, skill, p);
                break;
            }
            case "teleportlocation": 
            case "tplocation": 
            case "tploc": {
                SkillTeleportLocation.ExecuteSkill(l, skill);
                break;
            }
            case "throw": {
                SkillThrow.ExecuteSkill(l, skill, p);
                break;
            }
            case "throwall": {
                SkillThrowAll.ExecuteSkill(l, skill);
                break;
            }
            case "volley": {
                SkillVolley.ExecuteSkill(l, skill, p);
                break;
            }
            case "weather": {
                SkillWeather.ExecuteSkill(l, skill);
                break;
            }
            default: {
                if (am != null && !ConfigManager.apiUseCustomSkillEvent) break;
            }
        }
    }

    public static boolean CheckTrigger(String strTrigger, SkillTrigger trigger, LivingEntity l, String full, boolean meta) {
        MythicMobs.debug(3, "-- Performing Trigger Check for skill...");
        String search = strTrigger.substring(1);
        MythicMobs.debug(3, "---- Comparing " + search + " == " + trigger.toString());
        if (search.contains("onTimer")) {
            return true;
        }
        switch (search) {
            case "onSpawn": {
                return trigger == SkillTrigger.SPAWN;
            }
            case "onDeath": {
                return trigger == SkillTrigger.DEATH;
            }
            case "onCombat": {
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK;
            }
            case "onDamaged": 
            case "onHurt": {
                return trigger == SkillTrigger.DAMAGED;
            }
            case "onAttack": {
                return trigger == SkillTrigger.ATTACK;
            }
            case "onExplode": {
                return trigger == SkillTrigger.EXPLODE;
            }
            case "onTeleport": {
                return trigger == SkillTrigger.TELEPORT;
            }
            case "onKillPlayer": 
            case "onPlayerKill": {
                return trigger == SkillTrigger.KILLPLAYER;
            }
            case "onCombatDrop": 
            case "onDropCombat": {
                return trigger == SkillTrigger.DROPCOMBAT;
            }
            case "onInteract": {
                return trigger == SkillTrigger.INTERACT;
            }
            case "default": {
                if (meta) {
                    return true;
                }
                return trigger == SkillTrigger.DAMAGED || trigger == SkillTrigger.ATTACK || trigger == SkillTrigger.SPAWN || trigger == SkillTrigger.DEATH || trigger == SkillTrigger.TIMER;
            }
        }
        return false;
    }

    public static boolean CheckHealth(String strHealth, AbstractEntity l, double currentbosshp, String full) {
        String[] healthparts;
        MythicMobs.debug(3, "-- Performing Health Check for skill...");
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(l));
        if (am == null) {
            return true;
        }
        String[] stringArray = healthparts = strHealth.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            double bosshp;
            String health;
            String healthT = health = stringArray[i];
            String skillstr = full + "~" + health;
            healthT = healthT.replace("%", "");
            healthT = healthT.replace("<", "");
            healthT = healthT.replace(">", "");
            healthT = healthT.replace("=", "");
            if (!(healthT = healthT.replace("-", "")).matches("[-+]?[0-9]*.?[0-9]+")) {
                return true;
            }
            double hp = Double.parseDouble(healthT);
            if (health.endsWith("%")) {
                bosshp = currentbosshp / l.getMaxHealth();
                hp = Double.parseDouble(healthT) / 100.0;
            } else {
                bosshp = currentbosshp / l.getMaxHealth();
                hp = Double.parseDouble(healthT) / am.getType().getHealth();
            }
            MythicMobs.debug(3, "-- orighealth = " + health + ", Boss hp = " + bosshp + "%, skill %hp=" + hp);
            if (health.startsWith(">")) {
                MythicMobs.debug(4, "---- Parsing GREATER THAN for skill...");
                health = health.replace(">", "");
                if (!(bosshp > hp)) continue;
                return true;
            }
            if (health.startsWith("=")) {
                MythicMobs.debug(4, "---- Parsing EQUAL TO for skill...");
                health = health.replace("=", "");
                if (!(bosshp <= hp) || !(l.getHealth() > hp) || LegacySkillHandler.hasUsedSkill(skillstr, l)) continue;
                if (!am.getType().repeatAllSkills) {
                    MythicMobs.inst().getMobManager();
                    MobManager.setMetaData(l, skillstr, skillstr);
                }
                return true;
            }
            if (health.startsWith("<")) {
                MythicMobs.debug(4, "---- Parsing LESS THAN for skill...");
                health = health.replace("<", "");
                if (!(bosshp < hp)) continue;
                return true;
            }
            if (health.contains("-")) {
                MythicMobs.debug(4, "---- Parsing RANGE for skill...");
                String[] hps = health.split("-");
                double hp1 = hps[0].endsWith("%") ? Double.parseDouble(hps[0].substring(0, hps[0].length() - 1)) / 100.0 : Double.parseDouble(hps[0].substring(0, hps[0].length())) / am.getType().getHealth();
                double hp2 = hps[1].endsWith("%") ? Double.parseDouble(hps[1].substring(0, hps[1].length() - 1)) / 100.0 : Double.parseDouble(hps[1].substring(0, hps[1].length())) / am.getType().getHealth();
                MythicMobs.debug(4, "------ RANGE scaled to " + hp1 + "-" + hp2);
                if (!(hp1 > hp2 ? bosshp > hp2 && bosshp < hp1 : bosshp > hp1 && bosshp < hp2)) continue;
                return true;
            }
            MythicMobs.debug(3, "-- AbstractSkill Health Check is invalid or not present? Assuming 100% up-time.");
            return true;
        }
        return false;
    }

    public static boolean hasUsedSkill(String full, AbstractEntity l) {
        List list = l.getBukkitEntity().getMetadata(full);
        for (MetadataValue mv : list) {
            if (!mv.asString().equals(full)) continue;
            return true;
        }
        return false;
    }

    private static class DelayedSkill
    implements Runnable {
        private List<String> list;
        private Entity boss;
        private LivingEntity player;
        private SkillTrigger trigger;
        private boolean cancelled;

        public DelayedSkill(List<String> list, Entity l, LivingEntity p, SkillTrigger trigger) {
            this.list = list;
            this.boss = l;
            this.player = p;
            this.trigger = trigger;
            this.cancelled = false;
        }

        public void cancel() {
            this.list = null;
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                if (!this.boss.isValid() && this.trigger != SkillTrigger.DEATH) {
                    this.cancel();
                } else {
                    if (MythicMobs.inst().getMobManager().isActiveMob(this.boss.getUniqueId()) && MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(this.boss)).changingTarget()) {
                        this.player = (LivingEntity)BukkitAdapter.adapt(MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(this.boss)).getNewTarget());
                        MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(this.boss)).voidTargetChange();
                    }
                    if (this.player != null && this.player.isValid()) {
                        LegacySkillHandler.ExecuteMetaSkills(this.list, this.boss, this.player, this.trigger);
                        return;
                    }
                    if (this.boss instanceof Creature && ((Creature)this.boss).getTarget() instanceof LivingEntity) {
                        this.player = ((Creature)this.boss).getTarget();
                        LegacySkillHandler.ExecuteMetaSkills(this.list, this.boss, this.player, this.trigger);
                        return;
                    }
                    List list = this.boss.getNearbyEntities(16.0, 8.0, 16.0);
                    for (Entity e : list) {
                        if (!(e instanceof Player)) continue;
                        if (this.boss instanceof Creature) {
                            ((Creature)this.boss).setTarget((LivingEntity)e);
                        }
                        LegacySkillHandler.ExecuteMetaSkills(this.list, this.boss, (LivingEntity)e, this.trigger);
                        return;
                    }
                    LegacySkillHandler.ExecuteMetaSkills(this.list, this.boss, null, this.trigger);
                }
            }
        }
    }

    public static class LegacyQueuedSkill
    implements Runnable {
        private List<String> list;
        private LivingEntity mob;
        private LivingEntity target;
        private SkillTrigger trigger;
        private boolean cancelled;

        public LegacyQueuedSkill(List<String> list, LivingEntity mob, LivingEntity target, SkillTrigger trigger) {
            this.list = list;
            this.mob = mob;
            this.target = target;
            this.trigger = trigger;
            this.cancelled = false;
        }

        public void cancel() {
            this.list = null;
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                LegacySkillHandler.ExecuteSkills(this.list, (Entity)this.mob, this.target, this.trigger);
            }
        }
    }
}

