/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.items;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.items.AttributeHandler;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.util.MythicUtil;
import io.lumine.xikage.mythicmobs.util.Patterns;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class MythicItem
implements Comparable<MythicItem> {
    private final MythicConfig config;
    private Optional<BukkitItemStack> itemStack = Optional.empty();
    private final String internalName;
    private final String file;
    private String displayName;
    private String id;
    private int iid;
    private boolean useiid = false;
    private int data = 0;
    private int amount = 1;
    private String color;
    private String player;
    private String skinURL;
    private String skinTexture;
    private UUID skinUUID;
    private List<String> lore;
    private List<String> Enchants;
    private List<String> potionEffects;
    private List<String> bannerLayers;
    private double speed;
    private double damage;
    private double knock;
    private double health;
    private double range;
    private Map<String, Map<String, Object>> itemAttributes = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> itemOptions = new HashMap<String, Object>();
    private List<String> hideOptions = new ArrayList<String>();
    private boolean unbreakable;
    private boolean hideFlags;

    public MythicItem(String file, String internalName, MythicConfig mc) {
        List<String> hideOptions;
        boolean repairable;
        int repairCost;
        this.config = mc;
        this.file = file;
        this.internalName = internalName;
        if (mc.isSet("ItemStack")) {
            this.itemStack = Optional.ofNullable(new BukkitItemStack(mc.getItemStack("ItemStack", null)));
            if (this.itemStack.isPresent()) {
                MythicMobs.log("???");
                return;
            }
        }
        this.id = mc.getString("Id", "1").toUpperCase();
        if (this.id.matches("[0-9]*")) {
            this.iid = Integer.parseInt(this.id);
            this.useiid = true;
        }
        this.data = mc.getInt("Data", 0);
        this.amount = mc.getInt("Amount", 1);
        this.displayName = mc.getColorString("Display");
        this.lore = mc.getColorStringList("Lore");
        this.Enchants = mc.getStringList("Enchantments");
        this.potionEffects = mc.getStringList("PotionEffects");
        this.bannerLayers = mc.getStringList("BannerLayers");
        this.speed = mc.getDouble("Options.MovementSpeed", 0.0);
        this.damage = mc.getDouble("Options.Damage", -1.0);
        this.health = mc.getDouble("Options.Health", 0.0);
        this.range = mc.getDouble("Options.FollowRange", 0.0);
        this.knock = mc.getDouble("Options.KnockbackResistance", 0.0);
        this.color = mc.getString("Options.Color");
        this.player = mc.getString("Options.Player");
        this.skinURL = mc.getString("Options.SkinURL");
        this.skinTexture = mc.getString("Options.SkinTexture");
        if (this.skinTexture != null) {
            this.skinUUID = MythicUtil.getUUIDFromString(this.skinTexture);
        } else if (this.skinURL != null) {
            this.skinUUID = MythicUtil.getUUIDFromString(this.skinURL);
        }
        this.unbreakable = mc.getBoolean("Options.Indestructable", false);
        this.unbreakable = mc.getBoolean("Options.Unbreakable", this.unbreakable);
        this.hideFlags = mc.getBoolean("Options.HideFlags", false);
        if (this.unbreakable) {
            this.itemOptions.put("Unbreakable", (byte)1);
        }
        if (this.hideFlags) {
            this.itemOptions.put("HideFlags", 63);
        }
        if ((repairCost = mc.getInt("Options.RepairCost", -1)) >= 0) {
            this.itemOptions.put("RepairCost", repairCost);
        }
        if (!(repairable = mc.getBoolean("Options.Repairable", true))) {
            this.itemOptions.put("RepairCost", Integer.MAX_VALUE);
        }
        if ((hideOptions = mc.getStringList("Hide")) != null) {
            for (String hide : hideOptions) {
                String f = "HIDE_" + hide.toUpperCase();
                this.hideOptions.add(f);
            }
        }
        if (mc.isSet("Attributes")) {
            try {
                for (String key : mc.getKeys("Attributes")) {
                    HashMap<String, Object> attr = new HashMap<String, Object>();
                    for (String key2 : mc.getKeys("Attributes." + key)) {
                        String value = mc.getString("Attributes." + key + "." + key2);
                        String attri = MythicMobs.inst().getItemManager().getItemAttribute(key2);
                        try {
                            double d = Double.valueOf(value);
                            attr.put(attri, d);
                        }
                        catch (Exception ex) {
                            attr.put(attri, value);
                        }
                    }
                    this.itemAttributes.put(key.toLowerCase(), attr);
                }
            }
            catch (Exception ex) {
                MythicMobs.error("Attributes for MythicItem " + this.internalName + " are configured incorrectly. Please see the manual for syntax.");
            }
        }
    }

    public String getInternalName() {
        return this.internalName;
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public String getFile() {
        return this.file;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public String getMaterialName() {
        return this.id;
    }

    public int getMaterialData() {
        return this.data;
    }

    public int getAmount() {
        return this.amount;
    }

    public AbstractItemStack generateItemStack(int amount) {
        return this.generateItemStack(amount, null, null);
    }

    public AbstractItemStack generateItemStack(int amount, AbstractEntity dropper, AbstractEntity trigger) {
        LivingEntity k;
        LivingEntity d = dropper == null ? null : (LivingEntity)BukkitAdapter.adapt(dropper);
        LivingEntity livingEntity = k = trigger == null ? null : (LivingEntity)BukkitAdapter.adapt(trigger);
        if (this.itemStack.isPresent()) {
            BukkitItemStack bstack = this.itemStack.get().clone();
            bstack.amount(this.amount * amount);
            return bstack;
        }
        BukkitItemStack bstack = this.useiid ? new BukkitItemStack(Material.getMaterial((int)this.iid)).data((byte)this.data).amount(this.amount * amount) : new BukkitItemStack(Material.getMaterial((String)this.id.toUpperCase())).data((byte)this.data).amount(this.amount * amount);
        ItemStack stack = bstack.build();
        ItemMeta im = stack.getItemMeta();
        ArrayList<String> parsedLore = new ArrayList<String>();
        for (String str : this.lore) {
            str = SkillString.parseMessageSpecialChars(str);
            if (d == null) {
                str = str.replace("$boss", "Unknown");
                str = str.replace("$mobname", "Unknown");
            } else if (d instanceof Player) {
                str = str.replace("$boss", ((Player)d).getDisplayName());
                str = str.replace("$mobname", ((Player)d).getDisplayName());
            } else if (d.getCustomName() != null) {
                str = str.replace("$boss", d.getCustomName());
                str = str.replace("$mobname", d.getCustomName());
            } else {
                str = str.replace("$boss", "Unknown");
                str = str.replace("$mobname", "Unknown");
            }
            str = k == null ? str.replace("$player", "Unknown") : (k instanceof Player ? str.replace("$player", ((Player)k).getName()) : str.replace("$player", d.getCustomName()));
            if (str.contains("{")) {
                MythicMobs.debug(3, "Found number range in item lore, parsing...");
                Matcher pMatcher = Patterns.LoreRanges.matcher(str);
                while (pMatcher.find()) {
                    int min = Integer.parseInt(pMatcher.group(1));
                    int max = Integer.parseInt(pMatcher.group(2));
                    int num = MythicMobs.r.nextInt(max - min) + min;
                    str = str.replace(pMatcher.group(0), "" + num);
                    MythicMobs.debug(3, "-- Replacing number range " + pMatcher.group(0) + " with " + num);
                }
            }
            parsedLore.add(str);
        }
        im.setLore(parsedLore);
        try {
            Class.forName("org.bukkit.inventory.meta.BannerMeta");
            if (im instanceof BannerMeta) {
                im = this.buildBanner(im);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (stack.getType().equals((Object)Material.SHIELD)) {
                im = this.buildShield(im);
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        if (stack.getType() == Material.POTION) {
            im = this.buildPotion(im);
        } else if (MythicMobs.inst().getMinecraftVersion() > 8 && (stack.getType() == Material.SPLASH_POTION || stack.getType() == Material.LINGERING_POTION || stack.getType() == Material.TIPPED_ARROW)) {
            im = this.buildPotion(im);
        }
        if (stack.getType().equals((Object)Material.SKULL) || stack.getType().equals((Object)Material.SKULL_ITEM)) {
            im = MythicItem.buildSkull((SkullMeta)im, this);
        }
        if (this.displayName != null) {
            im.setDisplayName(this.displayName);
        }
        if (this.hideOptions != null) {
            for (String hide : this.hideOptions) {
                ItemFlag flag = ItemFlag.valueOf((String)hide);
                im.addItemFlags(new ItemFlag[]{flag});
            }
        }
        stack.setItemMeta(im);
        if (CompatibilityManager.EnchantsPlus != null) {
            CompatibilityManager.EnchantsPlus.setEnchants(stack, this.Enchants);
        }
        if (this.Enchants != null) {
            stack = MythicItem.setEnchants(stack, this.Enchants);
        }
        if (this.color != null) {
            stack = MythicItem.setLeatherColor(stack, this);
        }
        if (MythicMobs.inst().getMinecraftVersion() >= 9) {
            stack = MythicMobs.inst().getVolatileCodeHandler().setItemAttributes(stack, this.internalName, this.itemOptions, this.itemAttributes);
        } else {
            if (this.health != 0.0) {
                stack = AttributeHandler.addHealth(this.internalName, stack, this.health);
            }
            if (this.damage > -1.0) {
                stack = AttributeHandler.addDamage(this.internalName, stack, this.damage);
            }
            if (this.speed != 0.0) {
                stack = AttributeHandler.addSpeed(this.internalName, stack, this.speed);
            }
            if (this.knock != 0.0) {
                stack = AttributeHandler.addKnockBackRes(this.internalName, stack, this.knock);
            }
            if (this.range != 0.0) {
                stack = AttributeHandler.addFollowRange(this.internalName, stack, this.range);
            }
            if (this.unbreakable) {
                stack = MythicMobs.inst().getVolatileCodeHandler().setItemUnbreakable(stack);
            }
            if (this.hideFlags) {
                stack = MythicMobs.inst().getVolatileCodeHandler().setItemHideFlags(stack);
            }
        }
        if (this.data != 0) {
            stack.setDurability((short)this.data);
        }
        return BukkitAdapter.adapt(stack);
    }

    private static ItemStack setEnchants(ItemStack stack, List<String> enchants) {
        if (enchants == null) {
            return stack;
        }
        for (String s : enchants) {
            if (!s.contains(":")) continue;
            String[] part = s.split(":");
            if (part[0].matches("[0-9]*")) {
                if (stack.getType() != Material.ENCHANTED_BOOK) {
                    stack.addUnsafeEnchantment(Enchantment.getById((int)Integer.parseInt(part[0])), Integer.parseInt(part[1]));
                    continue;
                }
                EnchantmentStorageMeta esm = (EnchantmentStorageMeta)stack.getItemMeta();
                esm.addStoredEnchant(Enchantment.getById((int)Integer.parseInt(part[0])), Integer.parseInt(part[1]), true);
                stack.setItemMeta((ItemMeta)esm);
                continue;
            }
            Enchantment en = Enchantment.getByName((String)part[0]);
            if (en == null) continue;
            if (stack.getType() != Material.ENCHANTED_BOOK) {
                stack.addUnsafeEnchantment(en, Integer.parseInt(part[1]));
                continue;
            }
            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)stack.getItemMeta();
            esm.addStoredEnchant(en, Integer.parseInt(part[1]), true);
            stack.setItemMeta((ItemMeta)esm);
        }
        return stack;
    }

    private ItemMeta buildPotion(ItemMeta im) {
        ((PotionMeta)im).clearCustomEffects();
        for (String s : this.potionEffects) {
            try {
                String[] sp = s.split(" ");
                if (sp.length < 3) {
                    MythicMobs.error("A potion effect for MythicItem " + this.internalName + " is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s);
                    continue;
                }
                PotionEffectType pet = PotionEffectType.getByName((String)sp[0].toUpperCase());
                int duration = Integer.parseInt(sp[1]);
                int level = Integer.parseInt(sp[2]);
                PotionEffect p = new PotionEffect(pet, duration, level - 1, true);
                ((PotionMeta)im).addCustomEffect(p, false);
            }
            catch (Exception ex) {
                MythicMobs.error("A potion effect for MythicItem " + this.internalName + " is configured incorrectly. Format is 'EFFECT DURATION LEVEL'. Line=" + s);
            }
        }
        return im;
    }

    private ItemMeta buildBanner(ItemMeta im) {
        try {
            ((BannerMeta)im).setBaseColor(DyeColor.valueOf((String)this.color));
        }
        catch (Exception ex) {
            MythicMobs.error("The banner color for MythicItem " + this.internalName + " is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
        }
        for (String s : this.bannerLayers) {
            try {
                String[] sp = s.split(" ");
                if (sp.length < 2) {
                    MythicMobs.error("A banner layer for MythicItem " + this.internalName + " is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s);
                    continue;
                }
                DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                PatternType pt = PatternType.valueOf((String)sp[1]);
                Pattern p = new Pattern(dc, pt);
                ((BannerMeta)im).addPattern(p);
            }
            catch (Exception ex) {
                MythicMobs.error("A banner layer for MythicItem " + this.internalName + " is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s);
            }
        }
        return im;
    }

    private ItemMeta buildShield(ItemMeta im) {
        BlockStateMeta meta = (BlockStateMeta)im;
        Banner banner = (Banner)meta.getBlockState();
        try {
            banner.setBaseColor(DyeColor.valueOf((String)this.color));
        }
        catch (Exception ex) {
            MythicMobs.error("The shield color for MythicItem " + this.internalName + " is configured incorrectly, must use a color from the Bukkit DyeColor ENUM.");
        }
        for (String s : this.bannerLayers) {
            try {
                String[] sp = s.split(" ");
                if (sp.length < 2) {
                    MythicMobs.error("A shield banner layer for MythicItem " + this.internalName + " is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s);
                    continue;
                }
                DyeColor dc = DyeColor.valueOf((String)sp[0].toUpperCase());
                PatternType pt = PatternType.valueOf((String)sp[1]);
                Pattern p = new Pattern(dc, pt);
                banner.addPattern(p);
            }
            catch (Exception ex) {
                MythicMobs.error("A shield banner layer for MythicItem " + this.internalName + " is configured incorrectly. Format is 'COLOR PATTERN'. Line=" + s);
            }
        }
        banner.update();
        meta.setBlockState((BlockState)banner);
        return meta;
    }

    private static ItemStack setLeatherColor(ItemStack item, MythicItem mi) {
        if (item.getType().equals((Object)Material.LEATHER_CHESTPLATE) || item.getType().equals((Object)Material.LEATHER_BOOTS) || item.getType().equals((Object)Material.LEATHER_LEGGINGS) || item.getType().equals((Object)Material.LEATHER_HELMET)) {
            String[] rgb = mi.color.split(",");
            int r = Integer.parseInt(rgb[0]);
            int g = Integer.parseInt(rgb[1]);
            int b = Integer.parseInt(rgb[2]);
            ItemMeta im = item.getItemMeta();
            LeatherArmorMeta la = (LeatherArmorMeta)im;
            la.setColor(Color.fromRGB((int)r, (int)g, (int)b));
            item.setItemMeta((ItemMeta)la);
        }
        return item;
    }

    private static ItemMeta buildSkull(SkullMeta meta, MythicItem mi) {
        if (mi.player != null) {
            meta.setOwner(mi.player);
        } else if (mi.skinTexture != null) {
            GameProfile profile = new GameProfile(mi.skinUUID, null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", mi.skinTexture));
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else if (mi.skinURL != null) {
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64Coder.encodeString((String)("{textures:{SKIN:{url:\"" + mi.skinURL + "\"}}}"))));
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
            profileField.setAccessible(true);
            try {
                profileField.set(meta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return meta;
    }

    @Override
    public int compareTo(MythicItem o) {
        return this.internalName.compareTo(o.getInternalName());
    }
}

