/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.io;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.WorldScaling;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import java.util.HashSet;

public class ConfigManager {
    private final MythicMobs core;
    private IOLoader<MythicMobs> settings;
    private MythicConfig config;
    public static int ClockInterval = 1;
    public static int debugLevel = -1;
    public static boolean debugMode = false;
    public static boolean debugSpawners = false;
    public static boolean errorLogging = true;
    public static int SaveInteval = 300;
    public static int SpawningInterval = 1;
    public static int timerupdate;
    public static int walkupdate;
    public static int ShowHealthRadius;
    public static int ScanInterval;
    public static int ClnrInterval;
    public static boolean AllowMetrics;
    public static boolean UseCompatibilityMode;
    public static boolean UseVolatileFeatures;
    public static String ShowHealthFormat;
    public static String KillMessagePrefix;
    public static boolean AllowUpdateChecking;
    public static int SpawnerRange;
    private boolean mobsDespawnByDefault = false;
    private boolean preventOtherDropsByDefault = false;
    public static boolean EnableAIModifiers;
    public static boolean EnableTimerSkills;
    public static boolean EnableThreatTables;
    public static boolean EnablePlayerFactions;
    public static boolean EnableLegacySkills;
    public static String defaultLevelModifierHealth;
    public static String defaultLevelModifierDamage;
    public static String defaultLevelModifierPower;
    public static String defaultLevelModifierArmor;
    public static String defaultLevelModifierKBR;
    public static boolean apiUseDeathEvent;
    public static boolean apiUseSkillEvent;
    public static boolean apiUseCustomSkillEvent;
    public static boolean compatHeroesXPEnable;
    public static boolean compatHeroesShowXPMessage;
    public static String compatHeroesXPMessageFormat;
    public static boolean compatSkillAPIShowXPMessage;
    public static String compatSkillAPIXPMessageFormat;
    public static boolean compatVaultShowMoneyMessage;
    public static String compatVaultMoneyMessageFormat;
    public static boolean compatMcMMOShowXPMessage;
    public static String compatMcMMOXPMessageFormat;
    private static boolean rsGeneratePoints;
    private static int rsMaxMobsPerChunk;
    private static int rsPlayerRadius;
    private static int rsPlayerRadiusY;
    private static int rsPointsPerSecondLand;
    private static int rsPointsPerSecondAir;
    private static int rsPointsPerSecondSea;
    private static int rsPointsPerSecondLava;
    private static int rsPointsPerSecondGround;
    private static int rsMaxGenerationTimeMillis;
    private static boolean rsDespawnVanillaOutsideRadius;

    public void SaveAll() {
        this.core.getMobManager().saveCachedActiveMobs();
        this.core.getSpawnerManager().saveSpawners();
    }

    public void ResetAll() {
        this.core.listLegacySkills.clear();
        this.core.unregisterSkillEvents();
    }

    public void LoadAll(boolean msg) {
        this.settings = new IOLoader<MythicMobs>(this.core, "config.yml");
        this.loadSettings();
        this.core.getItemManager().loadItems();
        this.core.getSkillManager().loadSkills();
        this.core.getMobManager().loadMobs();
        this.core.getDropManager().loadDropTables();
        this.core.getRandomSpawningManager().loadRandomSpawns();
        this.core.getSpawnerManager().loadSpawners();
        this.core.getSkillManager().runSecondPass();
        MythicMobs.log("Loaded " + MythicMobs.inst().getMobManager().getMobTypes().size() + " mobs.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getMobManager().getVanillaTypes().size() + " vanilla mob overrides.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getMobManager().getMobStacks().size() + " mob stacks.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getSkillManager().getSkills().size() + " skills.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getRandomSpawningManager().getNumberOfSpawners() + " random spawns.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getItemManager().getItems().size() + " mythic items.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getDropManager().getDropTables().size() + " drop tables.");
        MythicMobs.log("Loaded " + MythicMobs.inst().getSpawnerManager().getSpawners().size() + " mob spawners.");
    }

    public ConfigManager(MythicMobs core) {
        this.core = core;
    }

    public void loadSettings() {
        this.loadLegacySettings();
        MythicMobs.debug(1, "* Checking for Settings...");
        if (!this.settings.getCustomConfig().contains("Configuration.Version")) {
            return;
        }
        MythicMobs.debug(1, "** Loading Settings...");
        MythicConfig mc = new MythicConfig("Configuration", this.settings.getCustomConfig());
        AllowMetrics = mc.getBoolean("General.AllowMetrics", true);
        if (debugLevel == -1) {
            debugLevel = mc.getInt("General.DebugLevel", 0);
        }
        errorLogging = mc.getBoolean("General.ErrorLogging", true);
        UseCompatibilityMode = mc.getBoolean("General.Compatibilitymode", false);
        UseVolatileFeatures = mc.getBoolean("General.UseVolatileFeatures", true);
        AllowUpdateChecking = mc.getBoolean("General.CheckForUpdates", true);
        int i = mc.getInt("Clock.SaveInterval", 5);
        SaveInteval = i * 60;
        ClockInterval = mc.getInt("Clock.ClockInterval", 5);
        SpawningInterval = mc.getInt("Clock.SpawnsInterval", 2);
        ScanInterval = mc.getInt("Clock.ScannerInterval", 10);
        ClnrInterval = mc.getInt("Clock.CleanupInterval", 600);
        this.mobsDespawnByDefault = mc.getBoolean("Mobs.DespawnByDefault", true);
        this.preventOtherDropsByDefault = mc.getBoolean("Mobs.PreventOtherDropsByDefault", false);
        EnableAIModifiers = mc.getBoolean("Mobs.EnableAIModifiers", true);
        EnableTimerSkills = mc.getBoolean("Mobs.EnableTimerSkills", true);
        EnableLegacySkills = mc.getBoolean("Mobs.EnableLegacySkills", false);
        EnableThreatTables = mc.getBoolean("Mobs.EnableThreatTables", true);
        EnablePlayerFactions = mc.getBoolean("Mobs.EnablePlayerFactions", true);
        ShowHealthRadius = mc.getInt("Mobs.ShowHealth.Radius", 25);
        ShowHealthFormat = mc.getString("Mobs.ShowHealth.Format", ShowHealthFormat);
        KillMessagePrefix = SkillString.parseMessageSpecialChars(mc.getString("Mobs.KillMessagePrefix", KillMessagePrefix));
        rsGeneratePoints = mc.getBoolean("RandomSpawning.GenerateSpawnPoints", false);
        rsMaxMobsPerChunk = mc.getInt("RandomSpawning.MaxMobsPerChunk", 20);
        rsPlayerRadius = mc.getInt("RandomSpawning.SpawnRadiusPerPlayer", 64);
        rsPlayerRadiusY = mc.getInt("RandomSpawning.SpawnRadiusPerPlayerY", 16);
        rsPointsPerSecondLand = mc.getInt("RandomSpawning.PointsPerSecond.Land", 10);
        rsPointsPerSecondAir = mc.getInt("RandomSpawning.PointsPerSecond.Air", 1);
        rsPointsPerSecondSea = mc.getInt("RandomSpawning.PointsPerSecond.Sea", 1);
        rsPointsPerSecondLava = mc.getInt("RandomSpawning.PointsPerSecond.Lava", 0);
        rsPointsPerSecondGround = mc.getInt("RandomSpawning.PointsPerSecond.Ground", 0);
        rsDespawnVanillaOutsideRadius = mc.getBoolean("RandomSpawning.DespawnLazyRandomMobs", true);
        rsMaxGenerationTimeMillis = mc.getInt("RandomSpawning.MaxGenerationTime", 20);
        compatHeroesXPEnable = mc.getBoolean("Compatibility.Heroes.Enabled", compatHeroesXPEnable);
        compatHeroesShowXPMessage = mc.getBoolean("Compatibility.Heroes.ShowXPMessage", compatHeroesShowXPMessage);
        compatHeroesXPMessageFormat = mc.getString("Compatibility.Heroes.XPMessageFormat", compatHeroesXPMessageFormat);
        compatMcMMOShowXPMessage = mc.getBoolean("Compatibility.McMMO.ShowXPMessage", compatMcMMOShowXPMessage);
        compatMcMMOXPMessageFormat = mc.getString("Compatibility.McMMO.XPMessageFormat", compatMcMMOXPMessageFormat);
        compatSkillAPIShowXPMessage = mc.getBoolean("Compatibility.SkillAPI.ShowXPMessage", compatSkillAPIShowXPMessage);
        compatSkillAPIXPMessageFormat = mc.getString("Compatibility.SkillAPI.XPMessageFormat", compatSkillAPIXPMessageFormat);
        compatVaultShowMoneyMessage = mc.getBoolean("Compatibility.Vault.ShowMoneyMessage", compatVaultShowMoneyMessage);
        compatVaultMoneyMessageFormat = mc.getString("Compatibility.Vault.MoneyMessageFormat", compatVaultMoneyMessageFormat);
        compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
        compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
        compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
        compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        MythicMobs.debug(1, "** Loading WorldScaling Settings...");
        WorldScaling.reset();
        if (this.settings.getCustomConfig().contains("Configuration.Mobs.Scaling")) {
            for (String world : this.settings.getCustomConfig().getConfigurationSection("Configuration.Mobs.Scaling").getKeys(false)) {
                MythicMobs.debug(1, "*** Loading WorldScaling for world " + world);
                MythicConfig wmc = new MythicConfig("Configuration.Mobs.Scaling." + world, this.settings.getCustomConfig());
                WorldScaling.initialize(world, wmc);
            }
        }
        MythicMobs.debug(1, "** Finished Load WorldScaling Settings!");
        MythicMobs.debug(1, "** Loading Default Level Modifiers...");
        defaultLevelModifierHealth = mc.getString("Mobs.DefaultLevelModifiers.Health", "0.1");
        defaultLevelModifierDamage = mc.getString("Mobs.DefaultLevelModifiers.Damage", "0");
        defaultLevelModifierPower = mc.getString("Mobs.DefaultLevelModifiers.Power", "0");
        defaultLevelModifierArmor = mc.getString("Mobs.DefaultLevelModifiers.Armor", "0");
        defaultLevelModifierKBR = mc.getString("Mobs.DefaultLevelModifiers.KnockbackResistance", "0");
        MythicMobs.debug(1, "**** Default Level Modifiers - Health: " + defaultLevelModifierHealth);
        MythicMobs.debug(1, "**** Default Level Modifiers - Damage: " + defaultLevelModifierDamage);
        MythicMobs.debug(1, "**** Default Level Modifiers - Power: " + defaultLevelModifierPower);
        MythicMobs.debug(1, "**** Default Level Modifiers - Armor: " + defaultLevelModifierArmor);
        MythicMobs.debug(1, "**** Default Level Modifiers - KBR: " + defaultLevelModifierKBR);
        MythicMobs.debug(1, "** Finished Load Default Level Modifiers!");
    }

    public MythicConfig getConfig() {
        return this.config;
    }

    public void loadLegacySettings() {
        MythicMobs.debug(1, "* Checking for Legacy Settings...");
        if (this.settings.getCustomConfig().contains("general.debug-level")) {
            MythicMobs.debug(1, "** Loading Legacy Settings...");
            if (debugLevel == 0) {
                debugLevel = this.settings.getCustomConfig().getInt("general.debug-level", 0);
            }
            errorLogging = this.settings.getCustomConfig().getBoolean("general.error-logging", true);
            int i = this.settings.getCustomConfig().getInt("general.save-interval", 5);
            SaveInteval = i * 60;
            ClockInterval = this.settings.getCustomConfig().getInt("general.clock-interval", ClockInterval);
            SpawningInterval = this.settings.getCustomConfig().getInt("general.spawns-interval", SpawningInterval);
            ScanInterval = this.settings.getCustomConfig().getInt("general.scanner-interval", ScanInterval);
            ClnrInterval = this.settings.getCustomConfig().getInt("general.cleanup-interval", ClnrInterval);
            EnableTimerSkills = this.settings.getCustomConfig().getBoolean("mobs.enable-timer-skills", EnableTimerSkills);
            EnableLegacySkills = this.settings.getCustomConfig().getBoolean("mobs.enable-legacy-skills", EnableLegacySkills);
            EnableThreatTables = this.settings.getCustomConfig().getBoolean("mobs.enable-threat-tables", EnableThreatTables);
            EnablePlayerFactions = this.settings.getCustomConfig().getBoolean("enable-player-factions", EnablePlayerFactions);
            ShowHealthRadius = this.settings.getCustomConfig().getInt("mobs.show-health-radius", ShowHealthRadius);
            ShowHealthFormat = this.settings.getCustomConfig().getString("mobs.show-health-format", ShowHealthFormat);
            KillMessagePrefix = this.settings.getCustomConfig().getString("mobs.kill-message-prefix", KillMessagePrefix);
            UseCompatibilityMode = this.settings.getCustomConfig().getBoolean("general.compatibility-mode", UseCompatibilityMode);
            UseVolatileFeatures = this.settings.getCustomConfig().getBoolean("general.use-volatile-features");
            AllowUpdateChecking = this.settings.getCustomConfig().getBoolean("general.check-for-updates");
            AllowMetrics = this.settings.getCustomConfig().getBoolean("metrics.allow");
            compatHeroesXPEnable = this.settings.getCustomConfig().getBoolean("compatibility.heroes-xp-enable", compatHeroesXPEnable);
            compatHeroesShowXPMessage = this.settings.getCustomConfig().getBoolean("compatibility.heroes-show-xp-message", compatHeroesShowXPMessage);
            compatHeroesXPMessageFormat = this.settings.getCustomConfig().getString("compatibility.heroes-xp-message-format", compatHeroesXPMessageFormat);
            compatMcMMOShowXPMessage = this.settings.getCustomConfig().getBoolean("compatibility.mcmmo-show-xp-message", compatMcMMOShowXPMessage);
            compatMcMMOXPMessageFormat = this.settings.getCustomConfig().getString("compatibility.mcmmo-xp-message-format", compatMcMMOXPMessageFormat);
            compatSkillAPIShowXPMessage = this.settings.getCustomConfig().getBoolean("compatibility.skillapi-show-xp-message", compatSkillAPIShowXPMessage);
            compatSkillAPIXPMessageFormat = this.settings.getCustomConfig().getString("compatibility.skillapi-xp-message-format", compatSkillAPIXPMessageFormat);
            compatVaultShowMoneyMessage = this.settings.getCustomConfig().getBoolean("compatibility.vault-show-money-message", compatVaultShowMoneyMessage);
            compatVaultMoneyMessageFormat = this.settings.getCustomConfig().getString("compatibility.vault-money-message-format", compatVaultMoneyMessageFormat);
            compatHeroesXPMessageFormat = SkillString.convertLegacyVariables(compatHeroesXPMessageFormat);
            compatMcMMOXPMessageFormat = SkillString.convertLegacyVariables(compatMcMMOXPMessageFormat);
            compatSkillAPIXPMessageFormat = SkillString.convertLegacyVariables(compatSkillAPIXPMessageFormat);
            compatVaultMoneyMessageFormat = SkillString.convertLegacyVariables(compatVaultMoneyMessageFormat);
        }
    }

    public static boolean generateRSPoints() {
        return rsGeneratePoints;
    }

    public static int getRSMaxMobsPerChunk() {
        return rsMaxMobsPerChunk;
    }

    public static int getRSPlayerRadius() {
        return rsPlayerRadius;
    }

    public static int getRSPlayerRadiusY() {
        return rsPlayerRadiusY;
    }

    public static int getRSPointsPerSecondLand() {
        return rsPointsPerSecondLand;
    }

    public static int getRSPointsPerSecondAir() {
        return rsPointsPerSecondAir;
    }

    public static int getRSPointsPerSecondSea() {
        return rsPointsPerSecondSea;
    }

    public static int getRSPointsPerSecondLava() {
        return rsPointsPerSecondLava;
    }

    public static int getRSPointsPerSecondGround() {
        return rsPointsPerSecondGround;
    }

    public static int getRSMaxGenerationTimeMillis() {
        return rsMaxGenerationTimeMillis;
    }

    public static boolean getRSDespawnVanillaOutsideRadius() {
        return rsDespawnVanillaOutsideRadius;
    }

    public boolean getDespawnMobsByDefault() {
        return this.mobsDespawnByDefault;
    }

    public boolean getPreventOtherDropsByDefault() {
        return this.preventOtherDropsByDefault;
    }

    public HashSet<Byte> getTransparentBlocks() {
        byte[] bytes = new byte[]{0, 27, 28, 31, 32, 37, 38, 39, 40, 50, 51, 55, 63, 65, 66, 68, 69, 70, 72, 75, 76, 77, 78, 93, 94, 106, 111};
        HashSet<Byte> set = new HashSet<Byte>();
        for (byte b : bytes) {
            set.add(b);
        }
        return set;
    }

    static {
        ShowHealthRadius = 25;
        ScanInterval = 10;
        ClnrInterval = 600;
        AllowMetrics = true;
        UseCompatibilityMode = false;
        UseVolatileFeatures = true;
        ShowHealthFormat = "$mobname: $mobhp / $mobmaxhp";
        KillMessagePrefix = "";
        AllowUpdateChecking = true;
        SpawnerRange = 40;
        EnableAIModifiers = true;
        EnableTimerSkills = true;
        EnableThreatTables = true;
        EnablePlayerFactions = true;
        EnableLegacySkills = true;
        apiUseDeathEvent = true;
        apiUseSkillEvent = true;
        apiUseCustomSkillEvent = true;
        compatHeroesXPEnable = false;
        compatHeroesShowXPMessage = true;
        compatHeroesXPMessageFormat = "";
        compatSkillAPIShowXPMessage = true;
        compatSkillAPIXPMessageFormat = "";
        compatVaultShowMoneyMessage = true;
        compatVaultMoneyMessageFormat = "";
        compatMcMMOShowXPMessage = true;
        compatMcMMOXPMessageFormat = "";
        rsGeneratePoints = false;
        rsMaxMobsPerChunk = 20;
        rsPlayerRadius = 64;
        rsPlayerRadiusY = 16;
        rsPointsPerSecondLand = 10;
        rsPointsPerSecondAir = 0;
        rsPointsPerSecondSea = 1;
        rsPointsPerSecondLava = 0;
        rsPointsPerSecondGround = 0;
        rsMaxGenerationTimeMillis = 20;
        rsDespawnVanillaOutsideRadius = false;
    }
}

