/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.compatibility.CompatibilityManager;
import io.lumine.xikage.mythicmobs.compatibility.RelicsSupport;
import io.lumine.xikage.mythicmobs.drops.DropManager;
import io.lumine.xikage.mythicmobs.drops.MythicEquipable;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.legacy.conditions.SCondition;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class MythicDropTable {
    public String dtName;
    public String file;
    public List<String> conditions = new ArrayList<String>();
    public List<String> strDropItems = new ArrayList<String>();
    public List<String> strDropNonItems = new ArrayList<String>();
    private int minItems;
    private int maxItems;
    private boolean hasConditions = false;
    public int exp = 0;
    public int championsexp = 0;
    public int heroesexp = 0;
    public int skillapiexp = 0;
    public int mcmmoexp = 0;
    double money = 0.0;
    MythicDropTable perLevelTable;
    public List<ItemStack> dropsList = new ArrayList<ItemStack>();
    public List<MythicEquipable> equipablesList = new ArrayList<MythicEquipable>();
    protected boolean modExp = false;

    public MythicDropTable(String file, String name, MythicConfig mc) {
        int totalItems = mc.getInt("TotalItems", -1);
        int maxItems = mc.getInt("MaxItems", totalItems);
        int minItems = mc.getInt("MinItems", totalItems);
        List<String> conditions = mc.getStringList("Conditions");
        List<String> strDropsPerLevel = mc.getStringList("DropsPerLevel");
        List<String> strDrops = mc.getStringList("Drops");
        this.setup(strDrops, strDropsPerLevel, name, file, conditions, minItems, maxItems);
    }

    public MythicDropTable(List<String> strDrops) {
        this.setup(strDrops, null, null, null, null, -1, -1);
    }

    public MythicDropTable(List<String> strDrops, List<String> strDropsPerLevel, String name, String file, List<String> conditions) {
        this.setup(strDrops, strDropsPerLevel, name, file, conditions, -1, -1);
    }

    public MythicDropTable(List<String> strDrops, List<String> strDropsPerLevel, String name, String file, List<String> conditions, int minItems, int maxItems) {
        this.setup(strDrops, strDropsPerLevel, name, file, conditions, minItems, maxItems);
    }

    private void setup(List<String> strDrops, List<String> strDropsPerLevel, String name, String file, List<String> conditions, int minItems, int maxItems) {
        this.dtName = name;
        this.dtName = name;
        this.file = file;
        if (maxItems < 0) {
            maxItems = -1;
        }
        if (minItems < 0) {
            minItems = -1;
        }
        if (minItems > maxItems) {
            minItems = maxItems;
        }
        this.minItems = minItems;
        this.maxItems = maxItems;
        this.conditions = conditions;
        if (conditions != null) {
            this.hasConditions = true;
        }
        if (strDropsPerLevel != null) {
            this.perLevelTable = new MythicDropTable(strDropsPerLevel, null, name + "PERLEVEL", null, null);
        }
        for (String s : strDrops) {
            String c = s.toLowerCase();
            if (c.startsWith("exp ") || c.startsWith("championsexp ") || c.startsWith("champions-exp ") || c.startsWith("skillapiexp ") || c.startsWith("skillapi-exp ") || c.startsWith("heroesexp ") || c.startsWith("heroes-exp ") || c.startsWith("mcmmoexp") || c.startsWith("mcmmo-exp ") || c.startsWith("money ") || c.startsWith("currency ")) {
                this.strDropNonItems.add(s);
                continue;
            }
            this.strDropItems.add(s);
        }
    }

    public void parseTable() {
        this.parseTable(null, null);
    }

    public void parseTable(ActiveMob dropper) {
        this.parseTable(dropper, null);
    }

    public void parseTable(AbstractEntity killer) {
        this.parseTable(null, killer);
    }

    public MythicDropTable add(ActiveMob am, MythicDropTable dt) {
        dt.parseTable(am);
        this.dropsList.addAll(dt.getDrops());
        this.money += dt.getMoney();
        this.exp += dt.getExp();
        this.championsexp += dt.getChampionsExp();
        this.heroesexp += dt.getHeroesExp();
        this.skillapiexp += dt.getSkillAPIExp();
        this.mcmmoexp += dt.getMcMMOExp();
        return this;
    }

    public void parseTable(ActiveMob dropper, AbstractEntity killer) {
        String[] split;
        this.dropsList.clear();
        this.equipablesList.clear();
        this.money = 0.0;
        this.exp = 0;
        this.championsexp = 0;
        this.heroesexp = 0;
        this.skillapiexp = 0;
        this.mcmmoexp = 0;
        this.modExp = false;
        int items = this.maxItems > this.minItems ? this.minItems + MythicMobs.r.nextInt(this.maxItems - this.minItems) : this.minItems;
        if (dropper != null && dropper.getLevel() > 1 && this.perLevelTable != null) {
            for (int i = 1; i < dropper.getLevel(); ++i) {
                this.add(dropper, this.perLevelTable);
            }
        }
        if (this.hasConditions) {
            for (String strCondition : this.conditions) {
                split = strCondition.split(" ");
                String conditionData = null;
                if (split.length > 1) {
                    conditionData = split[1];
                }
                if (SCondition.getSpawningConditionByName(split[0]).check(BukkitAdapter.adapt(dropper.getLocation()), (LivingEntity)BukkitAdapter.adapt(dropper.getEntity()), conditionData)) continue;
                return;
            }
        }
        for (String drop : this.strDropNonItems) {
            MythicMobs.debug(2, "Parsing Drop Table entry: " + drop);
            try {
                if (drop.contains("champions-exp")) {
                    MythicMobs.debug(2, "-- Found Champions Experience!");
                    split = drop.split(" ");
                    this.championsexp = (int)((double)this.championsexp + DropManager.parseAmount(split[1]));
                    continue;
                }
                if (drop.contains("skillapi-exp")) {
                    MythicMobs.debug(2, "-- Found SkillAPI Experience!");
                    split = drop.split(" ");
                    this.skillapiexp = (int)((double)this.skillapiexp + DropManager.parseAmount(split[1]));
                    continue;
                }
                if (drop.contains("heroesexp") || drop.contains("heroes-exp")) {
                    MythicMobs.debug(2, "-- Found Heroes Experience!");
                    split = drop.split(" ");
                    this.heroesexp = (int)((double)this.heroesexp + DropManager.parseAmount(split[1]));
                    continue;
                }
                if (drop.contains("mcmmo-exp")) {
                    MythicMobs.debug(2, "-- Found mcMMO Experience!");
                    split = drop.split(" ");
                    this.mcmmoexp = (int)((double)this.mcmmoexp + DropManager.parseAmount(split[1]));
                    continue;
                }
                if (drop.contains("exp")) {
                    MythicMobs.debug(2, "-- Found Experience!");
                    split = drop.split(" ");
                    this.exp = (int)((double)this.exp + DropManager.parseAmount(split[1]));
                    continue;
                }
                if (!drop.contains("money")) continue;
                MythicMobs.debug(2, "-- Found Money!");
                split = drop.split(" ");
                this.money += DropManager.parseAmount(split[1]);
            }
            catch (Exception e) {
                MythicMobs.error("An error occured while parsing a drop table. Enable debugging for a stack trace.");
                MythicMobs.debug(1, "== Error occured during parsing of following drop table string: " + drop);
                if (ConfigManager.debugLevel <= 0) continue;
                e.printStackTrace();
            }
        }
        int ia = 0;
        block7: do {
            for (String s : this.strDropItems) {
                MythicMobs.debug(2, "Parsing Drop Table entry: " + s);
                if (items >= 0 && ia >= items) {
                    MythicMobs.debug(2, "-- Reached item budget, stopping parsing (items=" + items + ")");
                    continue block7;
                }
                try {
                    ItemStack is;
                    String[] split2;
                    if (s.contains("phatloot")) {
                        MythicMobs.debug(2, "-- Found PhatLoot!");
                        split2 = s.split(" ");
                        int amount = 1;
                        float chance = 1.0f;
                        if (split2.length > 2) {
                            amount = (int)DropManager.parseAmount(split2[2]);
                        }
                        if (split2.length > 3) {
                            chance = Float.parseFloat(split2[3]);
                            if (MythicMobs.r.nextFloat() > chance) continue;
                        }
                        ++ia;
                        if (CompatibilityManager.PhatLoots == null) continue;
                        for (int i = 0; i < amount; ++i) {
                            if (!CompatibilityManager.PhatLoots.generateBundle(split2[1])) continue;
                            this.dropsList.addAll(CompatibilityManager.PhatLoots.getLootBundleItems());
                            this.exp += CompatibilityManager.PhatLoots.getLootBundleXP();
                            this.money += CompatibilityManager.PhatLoots.getLootBundleMoney();
                        }
                        continue;
                    }
                    if (s.contains("mythicdrop")) {
                        MythicMobs.debug(2, "-- Found MythicDrop!");
                        split2 = s.split(" ");
                        int amount = 1;
                        double chance = 1.0;
                        if (split2.length > 2) {
                            amount = (int)DropManager.parseAmount(split2[2]);
                        }
                        if (split2.length > 3) {
                            chance = Double.parseDouble(split2[3]);
                            if (MythicMobs.r.nextDouble() > chance) continue;
                        }
                        ++ia;
                        if (CompatibilityManager.MythicDrops == null) continue;
                        for (int i = 0; i < amount; ++i) {
                            ItemStack md;
                            if (split2.length > 1) {
                                md = CompatibilityManager.MythicDrops.getTierLoot(split2[1]);
                                if (md == null) continue;
                                this.dropsList.add(md);
                                continue;
                            }
                            md = CompatibilityManager.MythicDrops.getLoot();
                            if (md == null) continue;
                            this.dropsList.add(md);
                        }
                        continue;
                    }
                    if (s.contains("heroesitem")) {
                        MythicMobs.debug(2, "-- Found Relic / HeroesItem!!");
                        split2 = s.split(" ");
                        String args = null;
                        int amount = 1;
                        double chance = 1.0;
                        boolean foundArgs = false;
                        if (split2.length > 2) {
                            if (split2[2].matches("[0-9]*")) {
                                amount = (int)DropManager.parseAmount(split2[2]);
                            } else {
                                args = SkillString.parseMobVariables(split2[2], dropper, killer, killer);
                                foundArgs = true;
                            }
                        }
                        if (split2.length > 3) {
                            if (foundArgs) {
                                amount = (int)DropManager.parseAmount(split2[3]);
                            } else {
                                chance = Double.parseDouble(split2[3]);
                                if (MythicMobs.r.nextDouble() > chance) continue;
                            }
                        }
                        if (split2.length > 4 && foundArgs) {
                            chance = Double.parseDouble(split2[4]);
                            if (MythicMobs.r.nextDouble() > chance) continue;
                        }
                        ++ia;
                        if (!MythicMobs.inst().getCompatibility().getRelics().isPresent()) continue;
                        RelicsSupport rs = MythicMobs.inst().getCompatibility().getRelics().get();
                        Object[] argz = args == null ? null : args.split(",");
                        for (int i = 0; i < amount; ++i) {
                            Optional<ItemStack> maybeItem = rs.getItem(split2[1], argz);
                            if (!maybeItem.isPresent()) continue;
                            this.dropsList.add(maybeItem.get());
                        }
                        continue;
                    }
                    MythicMobs.debug(2, "-- Nothing special found, checking for Mythic things...");
                    String[] part = s.split(" ");
                    int amount = 1;
                    float chance = 1.0f;
                    if (part.length > 1) {
                        if (part[1].contains("-")) {
                            String[] range = part[1].split("-");
                            int min = Integer.parseInt(range[0]);
                            int max = Integer.parseInt(range[1]);
                            amount = MythicMobs.r.nextInt(max - min) + min;
                        } else if (part[1].matches("[0-9]*")) {
                            amount = Integer.parseInt(part[1]);
                        }
                    }
                    if (part.length > 2 && part[2].matches("[0-9]*[.]?[0-9]+")) {
                        chance = Float.parseFloat(part[2]);
                    }
                    if (MythicMobs.r.nextFloat() > chance) {
                        MythicMobs.debug(2, "-- Chance failed! Skipping item.");
                        continue;
                    }
                    ++ia;
                    Optional<MythicDropTable> maybeDT = MythicMobs.inst().getDropManager().getDropTable(s);
                    if (maybeDT.isPresent()) {
                        MythicMobs.debug(1, "Found MythicDropTable " + s + "!");
                        this.add(dropper, maybeDT.get());
                        continue;
                    }
                    String[] split3 = part[0].split(":");
                    short data = 0;
                    if (split3.length > 1 && split3[1].matches("\\d+")) {
                        data = Short.parseShort(split3[1]);
                    }
                    short slot = data;
                    Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(split3[0]);
                    if (maybeItem.isPresent()) {
                        MythicItem mi = maybeItem.get();
                        MythicMobs.debug(1, "Found MythicItem " + split3[0] + ", equipping to slot" + slot);
                        ItemStack is2 = BukkitAdapter.adapt(mi.generateItemStack(amount, dropper.getEntity(), killer));
                        this.dropsList.add(is2);
                        this.equipablesList.add(new MythicEquipable(is2, data));
                        continue;
                    }
                    MythicMobs.debug(2, "-- No MythicItem found, parsing as regular Minecraft item...");
                    String id = split3[0];
                    if (split3.length > 2 && split3[2].matches("\\d+")) {
                        slot = Short.parseShort(split3[2]);
                    }
                    if (id.matches("\\d+")) {
                        MythicMobs.debug(3, "---- Matched Minecraft item ID");
                        int iid = Integer.parseInt(id);
                        is = new ItemStack(Material.getMaterial((int)iid), amount, data);
                        this.dropsList.add(is);
                        this.equipablesList.add(new MythicEquipable(is, slot));
                        continue;
                    }
                    MythicMobs.debug(3, "---- Matched Minecraft item name");
                    Material mat = Material.getMaterial((String)id.toUpperCase());
                    if (mat == null) {
                        MythicMobs.error("Error in DropTable '" + this.dtName + "': Item " + id + " is not a valid material type!");
                        continue;
                    }
                    is = new ItemStack(Material.getMaterial((String)id.toUpperCase()), amount, data);
                    this.dropsList.add(is);
                    this.equipablesList.add(new MythicEquipable(is, slot));
                }
                catch (Exception e) {
                    ++ia;
                    MythicMobs.error("An error occured while parsing a drop table. Enable debugging for a stack trace.");
                    MythicMobs.debug(1, "== Error occured during parsing of following drop table string: " + s);
                    if (ConfigManager.debugLevel <= 0) continue;
                    e.printStackTrace();
                }
            }
        } while (ia < items && items >= 0);
    }

    public List<ItemStack> getDrops() {
        return this.dropsList;
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int exp) {
        this.exp = exp;
    }

    public int getChampionsExp() {
        return this.championsexp;
    }

    public void setChampionsExp(int exp) {
        this.championsexp = exp;
    }

    public boolean modifiesExperience() {
        return this.exp > 0;
    }

    public int getHeroesExp() {
        return this.heroesexp;
    }

    public void setHeroesExp(int exp) {
        this.heroesexp = exp;
    }

    public int getSkillAPIExp() {
        return this.skillapiexp;
    }

    public void setSkillAPIExp(int exp) {
        this.skillapiexp = exp;
    }

    public double getMoney() {
        return this.money;
    }

    public void setMoney(double money) {
        this.money = money;
    }

    public int getMcMMOExp() {
        return this.mcmmoexp;
    }

    public void setMcMMOExp(int exp) {
        this.mcmmoexp = exp;
    }

    public boolean hasConditions() {
        return this.hasConditions;
    }
}

