/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.spawners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import io.lumine.xikage.mythicmobs.util.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class ResetTimersCommand
extends Command<MythicMobs> {
    public ResetTimersCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        String name = args[0];
        if (name.startsWith("g:")) {
            String group = name.substring(2);
            ArrayList<MythicSpawner> msl = MythicMobs.inst().getSpawnerManager().getSpawnersByGroup(group);
            for (MythicSpawner ms : msl) {
                ms.resetTimers();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner timers reset on group " + group);
        } else if (name.equals("*")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                ms.resetTimers();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner timers reset on all spawners!");
        } else if (name.contains("*") || name.contains("?")) {
            for (MythicSpawner ms : MythicMobs.inst().getSpawnerManager().getSpawners()) {
                if (!ms.getName().matches(name.replace("?", ".?").replace("*", ".*?"))) continue;
                ms.resetTimers();
            }
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] Spawner timers reset on spawners matching pattern " + name + "!");
        } else {
            MythicSpawner ms = MythicMobs.inst().getSpawnerManager().getSpawnerByName(name);
            if (ms == null) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Spawner. That one was not found!");
                return true;
            }
            ms.resetTimers();
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "Spawner timers reset on spawner " + name);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.resettimers";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "resettimers";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"rt"};
    }
}

