/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.spawners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.spawning.spawners.MythicSpawner;
import io.lumine.xikage.mythicmobs.util.commands.Command;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateCommand
extends Command<MythicMobs> {
    public CreateCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        String mobName;
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Command Format: " + ChatColor.AQUA + "/mm spawners create [name] [mob_name]");
            return true;
        }
        String name = args[0];
        if (name == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a name for the spawner.");
            return true;
        }
        Optional<MythicSpawner> maybeSpawner = MythicMobs.inst().getSpawnerManager().getSpawnerByHashcode(name.hashCode());
        if (maybeSpawner.isPresent()) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Spawner name must resolve to a unique hashcode.");
            return true;
        }
        int level = 1;
        if (args[1].contains(":")) {
            String[] split = args[1].split(":");
            mobName = split[0];
            try {
                level = Integer.parseInt(split[1]);
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Invalid mob level supplied: must be an integer.");
                return true;
            }
        } else {
            mobName = args[1];
        }
        if (mobName == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a Mythic Mob for the spawner to spawn.");
            return true;
        }
        if (MythicMobs.inst().getMobManager().getMythicMob(args[1]) == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must enter a valid Mythic Mob. That one was not found!");
            return true;
        }
        Player p = (Player)sender;
        Location location = p.getTargetBlock((Set)null, 10).getLocation();
        if (location == null) {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "You must target a valid block to place the spawner!");
            return true;
        }
        MythicSpawner ms = MythicMobs.inst().getSpawnerManager().createSpawner(name, location, mobName);
        if (ms != null) {
            location.getWorld().playEffect(location, Effect.MOBSPAWNER_FLAMES, 0);
            location.getWorld().playEffect(location, Effect.EXTINGUISH, 0);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.GREEN + "New spawner was created successfully!");
            if (level > 1) {
                ms.setMobLevel(level);
            }
        } else {
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs] " + ChatColor.RED + "Spawner creation failed: spawner name is probably already taken!");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.spawners.create";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"cr", "c"};
    }
}

