/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntity;
import org.bukkit.GameMode;
import org.bukkit.WeatherType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BukkitPlayer
extends BukkitEntity
implements AbstractPlayer {
    private boolean pre8 = false;

    public BukkitPlayer(Player p) {
        super((Entity)p);
    }

    @Override
    public boolean isInCreativeMode() {
        return this.getEntityAsPlayer().getGameMode().equals((Object)GameMode.CREATIVE);
    }

    @Override
    public boolean isInSpectatorMode() {
        if (this.pre8) {
            return false;
        }
        try {
            return this.getEntityAsPlayer().getGameMode().equals((Object)GameMode.SPECTATOR);
        }
        catch (NoSuchFieldError er) {
            this.pre8 = true;
            return false;
        }
    }

    @Override
    public void sendMessage(String message) {
        this.getEntityAsPlayer().sendMessage(message);
    }

    @Override
    public boolean hasPermission(String perm) {
        return this.getEntityAsPlayer().hasPermission(perm);
    }

    @Override
    public float getExperience() {
        return this.getEntityAsPlayer().getExp();
    }

    @Override
    public void setExperience(float exp) {
        this.getEntityAsPlayer().setExp(exp);
    }

    @Override
    public void hidePlayer(AbstractPlayer target) {
        this.getEntityAsPlayer().hidePlayer((Player)target.getBukkitEntity());
    }

    @Override
    public void showPlayer(AbstractPlayer target) {
        this.getEntityAsPlayer().showPlayer((Player)target.getBukkitEntity());
    }

    @Override
    public boolean canSee(AbstractPlayer target) {
        return this.getEntityAsPlayer().canSee((Player)target.getBukkitEntity());
    }

    @Override
    public boolean isOnline() {
        return this.getEntityAsPlayer().isOnline();
    }

    @Override
    public int getLevel() {
        return this.getEntityAsPlayer().getLevel();
    }

    @Override
    public void setLevel(int level) {
        this.getEntityAsPlayer().setLevel(level);
    }

    @Override
    public void setHealthScale(double scale) {
        this.getEntityAsPlayer().setHealthScale(scale);
    }

    @Override
    public void setHealthScaled(boolean scale) {
        this.getEntityAsPlayer().setHealthScaled(scale);
    }

    @Override
    public void setPersonalTime(long time, boolean relative) {
        this.getEntityAsPlayer().setPlayerTime(time, relative);
    }

    @Override
    public void resetPersonalTime() {
        this.getEntityAsPlayer().resetPlayerTime();
    }

    @Override
    public void setPersonalWeather(String type) {
        this.getEntityAsPlayer().setPlayerWeather(WeatherType.valueOf((String)type.toUpperCase()));
    }

    @Override
    public void resetPersonalWeather() {
        this.getEntityAsPlayer().resetPlayerWeather();
    }

    @Override
    public void setAllowFlight(boolean b) {
        this.getEntityAsPlayer().setAllowFlight(b);
    }

    @Override
    public boolean getAllowFlight() {
        return this.getEntityAsPlayer().getAllowFlight();
    }

    @Override
    public void setFlying(boolean b) {
        this.getEntityAsPlayer().setFlying(b);
    }

    @Override
    public void setFlyingSpeed(float f) {
        this.getEntityAsPlayer().setFlySpeed(f);
    }

    @Override
    public void setWalkSpeed(float f) {
        this.getEntityAsPlayer().setWalkSpeed(f);
    }
}

