/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.util.UUIDUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class BukkitItemStack
implements AbstractItemStack {
    private final ItemStack item;

    public BukkitItemStack(String type) {
        this.item = new ItemStack(Material.valueOf((String)type.toUpperCase()));
    }

    public BukkitItemStack(Material m) {
        this.item = new ItemStack(m);
    }

    public BukkitItemStack(ItemStack stack) {
        this.item = stack;
    }

    public BukkitItemStack data(byte d) {
        this.item.setDurability((short)d);
        return this;
    }

    public BukkitItemStack amount(int a) {
        this.item.setAmount(a);
        return this;
    }

    public BukkitItemStack colorData(DyeColor dc) {
        this.item.setDurability((short)dc.getWoolData());
        return this;
    }

    public BukkitItemStack display(String d) {
        this.checkItemMeta();
        ItemMeta im = this.item.getItemMeta();
        im.setDisplayName(d);
        this.item.setItemMeta(im);
        return this;
    }

    public BukkitItemStack lore(String[] lore) {
        this.checkItemMeta();
        ItemMeta im = this.item.getItemMeta();
        ArrayList<String> lores = new ArrayList<String>();
        for (String l : lore) {
            lores.add(l);
        }
        im.setLore(lores);
        this.item.setItemMeta(im);
        return this;
    }

    public BukkitItemStack enchant(Enchantment ench, int level) {
        this.item.addUnsafeEnchantment(ench, level);
        return this;
    }

    public BukkitItemStack setOwner(String owner) {
        this.checkItemMeta();
        if (!(this.item.getItemMeta() instanceof SkullMeta)) {
            return this;
        }
        SkullMeta im = (SkullMeta)this.item.getItemMeta();
        im.setOwner(owner);
        this.item.setItemMeta((ItemMeta)im);
        return this;
    }

    public BukkitItemStack setSkullTexture(String texture) {
        this.checkItemMeta();
        if (!(this.item.getItemMeta() instanceof SkullMeta)) {
            return this;
        }
        SkullMeta im = (SkullMeta)this.item.getItemMeta();
        UUID skinUUID = im.getDisplayName() != null ? UUIDUtil.getUUIDFromString(im.getDisplayName()) : UUID.randomUUID();
        GameProfile profile = new GameProfile(skinUUID, null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
        Field profileField = null;
        try {
            profileField = im.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        profileField.setAccessible(true);
        try {
            profileField.set(im, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.item.setItemMeta((ItemMeta)im);
        return this;
    }

    public ItemStack build() {
        return this.item;
    }

    private void checkItemMeta() {
        if (!this.item.hasItemMeta()) {
            this.item.setItemMeta(Bukkit.getItemFactory().getItemMeta(this.item.getType()));
        }
    }

    public BukkitItemStack clone() {
        return this.clone();
    }
}

