/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.adapters.AbstractBiome;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitWorld;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class BukkitAdapter {
    HashMap<Entity, AbstractEntity> cachedEntities = new HashMap();

    public static AbstractEntity adapt(Entity entity) {
        if (entity == null) {
            return null;
        }
        return new BukkitEntity(entity);
    }

    public static Entity adapt(AbstractEntity entity) {
        if (entity == null) {
            return null;
        }
        return entity.getBukkitEntity();
    }

    public static AbstractPlayer adapt(Player player) {
        if (player == null) {
            return null;
        }
        return new BukkitPlayer(player);
    }

    public static ItemStack adapt(AbstractItemStack item) {
        if (item == null) {
            return null;
        }
        return ((BukkitItemStack)item).build();
    }

    public static AbstractItemStack adapt(ItemStack item) {
        if (item == null) {
            return null;
        }
        return new BukkitItemStack(item);
    }

    public static Player adapt(AbstractPlayer player) {
        if (player == null) {
            return null;
        }
        return (Player)player.getBukkitEntity();
    }

    public static AbstractWorld adapt(World world) {
        return new BukkitWorld(world);
    }

    public static World adapt(AbstractWorld world) {
        if (world instanceof BukkitWorld) {
            return ((BukkitWorld)world).getBukkitWorld();
        }
        World match = Bukkit.getServer().getWorld(world.getName());
        if (match != null) {
            return match;
        }
        throw new IllegalArgumentException("Can't find a Bukkit world for " + world);
    }

    public static AbstractLocation adapt(Location location) {
        if (location == null) {
            return null;
        }
        return new AbstractLocation(BukkitAdapter.adapt(location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Location adapt(AbstractLocation location) {
        return new Location(BukkitAdapter.adapt(location.getWorld()), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Deprecated
    public static AbstractBiome adapt(Biome b) {
        if (b == null) {
            return null;
        }
        return new AbstractBiome(b.toString());
    }
}

