/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.i18n;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.config.YmlMaker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class Language {
    public FileConfiguration enlocale;
    public FileConfiguration customlocale;
    private Jobs plugin;

    public Language(Jobs plugin) {
        this.plugin = plugin;
    }

    public void reload() {
        this.customlocale = new YmlMaker(this.plugin, "locale/messages_" + Jobs.getGCManager().localeString + ".yml").getConfig();
        this.enlocale = new YmlMaker(this.plugin, "locale/messages_en.yml").getConfig();
        if (this.customlocale == null) {
            this.customlocale = this.enlocale;
        }
    }

    public String getMessage(String key) {
        return this.getMessage(key, "");
    }

    public String getMessage(String key, Object ... variables) {
        String missing = "Missing locale for " + key + " ";
        String msg = "";
        try {
            msg = this.customlocale == null || !this.customlocale.contains(key) ? (this.enlocale.contains(key) ? ChatColor.translateAlternateColorCodes((char)'&', (String)this.enlocale.getString(key)) : missing) : (this.customlocale.contains(key) ? ChatColor.translateAlternateColorCodes((char)'&', (String)this.customlocale.getString(key)) : missing);
        }
        catch (Exception e) {
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)"&e[Jobs] &2Cant read language file. Plugin will be disabled.");
            ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
            console.sendMessage(message);
            throw e;
        }
        if (variables.length > 0) {
            int i = 0;
            while (i < variables.length) {
                if (variables.length >= i + 2) {
                    msg = msg.replace(String.valueOf(variables[i]), String.valueOf(variables[i + 1]));
                }
                ++i;
                ++i;
            }
        }
        return msg;
    }

    public String getDefaultMessage(String key) {
        return this.enlocale.contains(key) ? ChatColor.translateAlternateColorCodes((char)'&', (String)this.enlocale.getString(key)) : "Cant find locale";
    }

    public boolean containsKey(String key) {
        if (this.customlocale == null || !this.customlocale.contains(key)) {
            return this.enlocale.contains(key);
        }
        return this.customlocale.contains(key);
    }
}

