/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.economy;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.CurrencyType;
import java.util.HashMap;

public class PaymentData {
    Long lastAnnouced = 0L;
    HashMap<CurrencyType, Double> payments = new HashMap();
    HashMap<CurrencyType, Long> paymentsTimes = new HashMap();
    private boolean Informed = false;
    private boolean Reseted = false;

    public PaymentData(Long time, Double Payment, Double Points, Double Exp, Long lastAnnouced, boolean Informed) {
        this.paymentsTimes.put(CurrencyType.EXP, time);
        this.paymentsTimes.put(CurrencyType.MONEY, time);
        this.paymentsTimes.put(CurrencyType.POINTS, time);
        this.payments.put(CurrencyType.EXP, Exp);
        this.payments.put(CurrencyType.MONEY, Payment);
        this.payments.put(CurrencyType.POINTS, Points);
        this.lastAnnouced = lastAnnouced;
        this.Informed = Informed;
    }

    public PaymentData(CurrencyType type, Double amount) {
        this.paymentsTimes.put(type, System.currentTimeMillis());
        this.payments.put(type, amount);
        this.lastAnnouced = 0L;
        this.Informed = false;
    }

    public PaymentData() {
        this.resetLimits();
    }

    public Long GetTime(CurrencyType type) {
        return this.paymentsTimes.get((Object)type);
    }

    public void setReseted(boolean state) {
        this.Reseted = state;
    }

    public boolean isReseted() {
        return this.Reseted;
    }

    public Double GetAmount(CurrencyType type) {
        if (!this.payments.containsKey((Object)type)) {
            return 0.0;
        }
        return this.payments.get((Object)type);
    }

    public Double GetAmountBylimit(CurrencyType type, int limit2) {
        if (this.GetAmount(type) > (double)limit2) {
            return limit2;
        }
        return (double)((int)(this.GetAmount(type) * 100.0)) / 100.0;
    }

    public Long GetLastAnnounced() {
        return this.lastAnnouced;
    }

    public boolean IsAnnounceTime(int t) {
        if (this.lastAnnouced + (long)(t * 1000) > System.currentTimeMillis()) {
            return false;
        }
        this.SetAnnouncmentTime();
        return true;
    }

    public void SetAnnouncmentTime() {
        this.lastAnnouced = System.currentTimeMillis();
    }

    public void AddNewAmount(CurrencyType type, Double Payment) {
        this.AddNewAmount(type, Payment, null);
    }

    public void AddNewAmount(CurrencyType type, Double Payment, Long time) {
        this.paymentsTimes.put(type, time == null ? System.currentTimeMillis() : time);
        this.payments.put(type, Payment);
    }

    public void setInformed() {
        this.Informed = true;
    }

    public void setNotInformed() {
        this.Informed = false;
    }

    public void AddAmount(CurrencyType type, Double Payment) {
        this.payments.put(type, this.payments.get((Object)type) + Payment);
    }

    public long GetLeftTime(CurrencyType type) {
        long left = 0L;
        if (this.GetTime(type) + (long)(Jobs.getGCManager().getLimit(type).getTimeLimit() * 1000) > System.currentTimeMillis()) {
            left = this.GetTime(type) + (long)(Jobs.getGCManager().getLimit(type).getTimeLimit() * 1000) - System.currentTimeMillis();
        }
        return left;
    }

    public boolean IsOverLimit(CurrencyType type, int limit2) {
        return !(this.payments.get((Object)type) < (double)limit2);
    }

    public boolean IsOverTimeLimit(CurrencyType type) {
        if (this.GetTime(type) + (long)(Jobs.getGCManager().getLimit(type).getTimeLimit() * 1000) > System.currentTimeMillis()) {
            return false;
        }
        if (this.Informed) {
            this.Informed = false;
        }
        this.resetLimits();
        return true;
    }

    public void resetLimits() {
        CurrencyType[] currencyTypeArray = CurrencyType.values();
        int n = currencyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CurrencyType type = currencyTypeArray[n2];
            this.AddNewAmount(type, 0.0);
            ++n2;
        }
        this.Reseted = true;
    }

    public boolean IsReachedLimit(CurrencyType type, int money) {
        if (this.IsOverTimeLimit(type)) {
            return true;
        }
        return this.IsOverLimit(type, money);
    }

    public boolean isInformed() {
        return this.Informed;
    }

    public void setInformed(boolean informed) {
        this.Informed = informed;
    }
}

