/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.economy;

import com.gamingmesh.jobs.economy.Economy;
import com.iCo6.iConomy;
import com.iCo6.system.Accounts;
import org.bukkit.OfflinePlayer;

public class IConomy6Adapter
implements Economy {
    iConomy icon;

    public IConomy6Adapter(iConomy iconomy) {
        this.icon = iconomy;
    }

    public double getBalance(String playerName) {
        IConomy6Adapter.checkExist(playerName);
        return new Accounts().get(playerName).getHoldings().getBalance();
    }

    @Override
    public boolean hasMoney(OfflinePlayer offlinePlayer, double amount) {
        return this.hasMoney(offlinePlayer.getName(), amount);
    }

    @Override
    public boolean hasMoney(String PlayerName, double amount) {
        IConomy6Adapter.checkExist(PlayerName);
        double holdings = this.getBalance(PlayerName);
        return holdings >= amount;
    }

    @Override
    public boolean depositPlayer(String PlayerName, double amount) {
        IConomy6Adapter.checkExist(PlayerName);
        new Accounts().get(PlayerName).getHoldings().add(amount);
        return true;
    }

    @Override
    public boolean depositPlayer(OfflinePlayer offlinePlayer, double amount) {
        return this.depositPlayer(offlinePlayer.getName(), amount);
    }

    @Override
    public boolean withdrawPlayer(String playerName, double amount) {
        IConomy6Adapter.checkExist(playerName);
        if (this.hasMoney(playerName, amount)) {
            new Accounts().get(playerName).getHoldings().subtract(amount);
            return true;
        }
        return false;
    }

    @Override
    public boolean withdrawPlayer(OfflinePlayer offlinePlayer, double amount) {
        return this.withdrawPlayer(offlinePlayer.getName(), amount);
    }

    @Override
    public String format(double money) {
        return iConomy.format((double)money);
    }

    private static void checkExist(String playerName) {
        Accounts acc = new Accounts();
        if (!acc.exists(playerName)) {
            acc.create(playerName);
        }
    }
}

