/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.dao;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.dao.JobsConnection;
import com.gamingmesh.jobs.dao.JobsDrivers;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

public class JobsConnectionPool {
    private JobsConnection connection;
    private String url;
    private String username;
    private String password;

    public JobsConnectionPool(String driverName, String url, String username, String password) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        Driver driver = (Driver)Class.forName(driverName, true, Jobs.getJobsClassloader()).newInstance();
        JobsDrivers jDriver = new JobsDrivers(driver);
        DriverManager.registerDriver(jDriver);
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public synchronized JobsConnection getConnection() throws SQLException {
        if (this.connection != null && (this.connection.isClosed() || !this.connection.isValid(1))) {
            try {
                this.connection.closeConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
        }
        if (this.connection == null) {
            Connection conn = DriverManager.getConnection(this.url, this.username, this.password);
            this.connection = new JobsConnection(conn);
        }
        return this.connection;
    }

    public synchronized void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.closeConnection();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

