/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.container;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.BoostCounter;
import com.gamingmesh.jobs.container.BossBarInfo;
import com.gamingmesh.jobs.container.CurrencyLimit;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.DisplayMethod;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.Log;
import com.gamingmesh.jobs.container.Title;
import com.gamingmesh.jobs.dao.JobsDAO;
import com.gamingmesh.jobs.economy.PaymentData;
import com.gamingmesh.jobs.resources.jfep.Parser;
import com.gamingmesh.jobs.stuff.ChatColor;
import com.gamingmesh.jobs.stuff.Perm;
import com.gamingmesh.jobs.stuff.TimeManage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JobsPlayer {
    private String userName;
    public UUID playerUUID;
    public ArrayList<JobProgression> progression = new ArrayList();
    private PaymentData paymentLimits = null;
    private HashMap<String, ArrayList<BoostCounter>> boostCounter = new HashMap();
    private String honorific;
    private volatile boolean isSaved = true;
    private volatile boolean isOnline = false;
    private OfflinePlayer OffPlayer = null;
    private Player player = null;
    private HashMap<CurrencyType, Integer> limits = new HashMap();
    private int userid = -1;
    List<BossBarInfo> barMap = new ArrayList<BossBarInfo>();
    List<String> updateBossBarFor = new ArrayList<String>();
    private List<Log> logList = new ArrayList<Log>();
    private Long seen = System.currentTimeMillis();
    private HashMap<String, Boolean> permissionsCache = null;
    private Long lastPermissionUpdate = -1L;

    public JobsPlayer(String userName, OfflinePlayer player) {
        this.userName = userName;
        this.OffPlayer = player;
        this.player = Bukkit.getPlayer((String)userName);
    }

    public int getTotalLevels() {
        int i = 0;
        for (JobProgression job : this.progression) {
            i += job.getLevel();
        }
        return i;
    }

    public PaymentData getPaymentLimit() {
        if (this.paymentLimits == null) {
            this.paymentLimits = Jobs.getJobsDAO().getPlayersLimits(this);
        }
        return this.paymentLimits;
    }

    public boolean isUnderLimit(CurrencyType type, Double amount) {
        Player player = this.getPlayer();
        if (player == null) {
            return true;
        }
        if (amount == 0.0) {
            return true;
        }
        CurrencyLimit limit2 = Jobs.getGCManager().getLimit(type);
        if (!limit2.isEnabled()) {
            return true;
        }
        PaymentData data = this.getPaymentLimit();
        if (data.IsReachedLimit(type, this.limits.get((Object)type))) {
            if (player.isOnline() && !data.isInformed() && !data.isReseted()) {
                player.sendMessage(Jobs.getLanguage().getMessage("command.limit.output.reached" + type.getName().toLowerCase() + "limit"));
                player.sendMessage(Jobs.getLanguage().getMessage("command.limit.output.reached" + type.getName().toLowerCase() + "limit2"));
                data.setInformed();
            }
            if (data.IsAnnounceTime(limit2.getAnnouncmentDelay()) && player.isOnline()) {
                Jobs.getActionBar().send((CommandSender)player, Jobs.getLanguage().getMessage("command.limit.output." + type.getName().toLowerCase() + "time", "%time%", TimeManage.to24hourShort(data.GetLeftTime(type))));
            }
            if (data.isReseted()) {
                data.setReseted(false);
            }
            return false;
        }
        data.AddAmount(type, amount);
        return true;
    }

    public void setPlayer(Player p) {
        this.player = p;
    }

    public void loadLogFromDao() {
        Jobs.getJobsDAO().loadLog(this);
    }

    public synchronized List<String> getUpdateBossBarFor() {
        return this.updateBossBarFor;
    }

    public synchronized void clearUpdateBossBarFor() {
        this.updateBossBarFor.clear();
    }

    public synchronized List<BossBarInfo> getBossBarInfo() {
        return this.barMap;
    }

    public synchronized void hideBossBars() {
        for (BossBarInfo one : this.barMap) {
            one.getBar().setVisible(false);
        }
    }

    public List<Log> getLog() {
        return this.logList;
    }

    public void setUserId(int id) {
        this.userid = id;
    }

    public int getUserId() {
        return this.userid;
    }

    public Player getPlayer() {
        if (this.playerUUID != null) {
            this.player = Bukkit.getPlayer((UUID)this.playerUUID);
        }
        return this.player;
    }

    public double getBoost(String JobName, CurrencyType type) {
        return this.getBoost(JobName, type, false);
    }

    public double getBoost(String JobName, CurrencyType type, boolean force) {
        double Boost2 = 0.0;
        if (!this.isOnline()) {
            return Boost2;
        }
        long time = System.currentTimeMillis();
        if (this.boostCounter.containsKey(JobName)) {
            ArrayList<BoostCounter> counterList = this.boostCounter.get(JobName);
            for (BoostCounter counter : counterList) {
                if (counter.getType() != type) continue;
                if (force || time - counter.getTime() > 60000L) {
                    Boost2 = this.getPlayerBoostNew(JobName, type);
                    counter.setBoost(Boost2);
                    counter.setTime(time);
                    return Boost2;
                }
                return counter.getBoost();
            }
            Boost2 = this.getPlayerBoostNew(JobName, type);
            counterList.add(new BoostCounter(type, Boost2, time));
            return Boost2;
        }
        Boost2 = this.getPlayerBoostNew(JobName, type);
        ArrayList<BoostCounter> counterList = new ArrayList<BoostCounter>();
        counterList.add(new BoostCounter(type, Boost2, time));
        this.boostCounter.put(JobName, counterList);
        return Boost2;
    }

    private Double getPlayerBoostNew(String JobName, CurrencyType type) {
        Double v1;
        Double Boost2 = null;
        Boost2 = v1 = Jobs.getPermissionManager().getMaxPermission(this, "jobs.boost." + JobName + "." + type.getName().toLowerCase(), true);
        v1 = Jobs.getPermissionManager().getMaxPermission(this, "jobs.boost." + JobName + ".all");
        if (Boost2 == null || v1 != null && v1 > Boost2) {
            Boost2 = v1;
        }
        v1 = Jobs.getPermissionManager().getMaxPermission(this, "jobs.boost.all.all");
        if (Boost2 == null || v1 != null && v1 > Boost2) {
            Boost2 = v1;
        }
        v1 = Jobs.getPermissionManager().getMaxPermission(this, "jobs.boost.all." + type.getName().toLowerCase());
        if (Boost2 == null || v1 != null && v1 > Boost2) {
            Boost2 = v1;
        }
        return Boost2 == null ? 0.0 : Boost2;
    }

    public void reloadMaxExperience() {
        for (JobProgression prog : this.progression) {
            prog.reloadMaxExperience();
        }
    }

    public void reload(CurrencyType type) {
        int TotalLevel = 0;
        for (JobProgression prog : this.progression) {
            TotalLevel += prog.getLevel();
        }
        Parser eq = Jobs.getGCManager().currencyLimitUse.get((Object)type).getMaxEquation();
        eq.setVariable("totallevel", TotalLevel);
        this.limits.put(type, (int)eq.getValue());
        this.setSaved(false);
    }

    public void reloadLimits() {
        CurrencyType[] currencyTypeArray = CurrencyType.values();
        int n = currencyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CurrencyType type = currencyTypeArray[n2];
            this.reload(type);
            ++n2;
        }
    }

    public int getLimit(CurrencyType type) {
        return this.limits.get((Object)type);
    }

    public void resetPaymentLimit() {
        if (this.paymentLimits == null) {
            this.getPaymentLimit();
        }
        if (this.paymentLimits != null) {
            this.paymentLimits.resetLimits();
        }
        this.setSaved(false);
    }

    public List<JobProgression> getJobProgression() {
        return Collections.unmodifiableList(this.progression);
    }

    public boolean havePermission(String perm) {
        if (this.player == null) {
            this.player = Bukkit.getPlayer((UUID)this.getPlayerUUID());
        }
        if (this.player != null) {
            return Perm.hasPermission(this.player, perm);
        }
        return false;
    }

    public JobProgression getJobProgression(Job job) {
        for (JobProgression prog : this.progression) {
            if (!prog.getJob().isSame(job)) continue;
            return prog;
        }
        return null;
    }

    public String getUserName() {
        if (this.player != null) {
            this.userName = this.player.getName();
        }
        if (this.userName == null && this.OffPlayer != null) {
            this.userName = this.OffPlayer.getName();
        }
        return this.userName;
    }

    public UUID getPlayerUUID() {
        if (this.playerUUID == null && this.player != null) {
            this.playerUUID = this.player.getUniqueId();
        }
        if (this.playerUUID == null && this.OffPlayer != null) {
            this.playerUUID = this.OffPlayer.getUniqueId();
        }
        return this.playerUUID;
    }

    public void setPlayerUUID(UUID uuid) {
        this.playerUUID = uuid;
    }

    public String getDisplayHonorific() {
        if (this.honorific == null) {
            this.reloadHonorific();
        }
        return this.honorific;
    }

    public boolean joinJob(Job job) {
        if (!this.isInJob(job)) {
            int level = 1;
            boolean exp = false;
            if (Jobs.getJobsDAO().checkArchive(this, job).size() > 0) {
                List<Integer> info2 = Jobs.getJobsDAO().checkArchive(this, job);
                level = info2.get(0);
                Jobs.getJobsDAO().deleteArchive(this, job);
            }
            this.progression.add(new JobProgression(job, this, level, (double)exp));
            this.reloadMaxExperience();
            this.reloadLimits();
            this.reloadHonorific();
            Jobs.getPermissionHandler().recalculatePermissions(this);
            return true;
        }
        return false;
    }

    public boolean leaveJob(Job job) {
        JobProgression prog = this.getJobProgression(job);
        if (prog != null) {
            this.progression.remove(prog);
            this.reloadMaxExperience();
            this.reloadLimits();
            this.reloadHonorific();
            Jobs.getPermissionHandler().recalculatePermissions(this);
            return true;
        }
        return false;
    }

    public boolean leaveAllJobs() {
        this.progression.clear();
        this.reloadHonorific();
        Jobs.getPermissionHandler().recalculatePermissions(this);
        return true;
    }

    public void promoteJob(Job job, int levels) {
        JobProgression prog = this.getJobProgression(job);
        if (prog == null) {
            return;
        }
        if (levels <= 0) {
            return;
        }
        int newLevel = prog.getLevel() + levels;
        int maxLevel = job.getMaxLevel();
        if (this.havePermission("jobs." + job.getName() + ".vipmaxlevel") && job.getVipMaxLevel() != 0) {
            maxLevel = job.getVipMaxLevel();
        }
        if (maxLevel > 0 && newLevel > maxLevel) {
            newLevel = maxLevel;
        }
        this.setLevel(job, newLevel);
    }

    public void demoteJob(Job job, int levels) {
        JobProgression prog = this.getJobProgression(job);
        if (prog == null) {
            return;
        }
        if (levels <= 0) {
            return;
        }
        int newLevel = prog.getLevel() - levels;
        if (newLevel < 1) {
            newLevel = 1;
        }
        this.setLevel(job, newLevel);
    }

    private void setLevel(Job job, int level) {
        JobProgression prog = this.getJobProgression(job);
        if (prog == null) {
            return;
        }
        if (level != prog.getLevel()) {
            prog.setLevel(level);
            this.reloadHonorific();
            Jobs.getPermissionHandler().recalculatePermissions(this);
        }
    }

    public boolean transferJob(Job oldjob, Job newjob) {
        if (!this.isInJob(newjob)) {
            for (JobProgression prog : this.progression) {
                if (!prog.getJob().isSame(oldjob)) continue;
                prog.setJob(newjob);
                int maxLevel = 0;
                maxLevel = this.havePermission("jobs." + newjob.getName() + ".vipmaxlevel") ? newjob.getVipMaxLevel() : newjob.getMaxLevel();
                if (newjob.getMaxLevel() > 0 && prog.getLevel() > maxLevel) {
                    prog.setLevel(maxLevel);
                }
                this.reloadMaxExperience();
                this.reloadLimits();
                this.reloadHonorific();
                Jobs.getPermissionHandler().recalculatePermissions(this);
                return true;
            }
        }
        return false;
    }

    public boolean isInJob(Job job) {
        for (JobProgression prog : this.progression) {
            if (!prog.getJob().isSame(job)) continue;
            return true;
        }
        return false;
    }

    public void reloadHonorific() {
        StringBuilder builder = new StringBuilder();
        int numJobs = this.progression.size();
        boolean gotTitle = false;
        if (numJobs > 0) {
            for (JobProgression prog : this.progression) {
                String honorificpart;
                DisplayMethod method = prog.getJob().getDisplayMethod();
                if (method.equals((Object)DisplayMethod.NONE)) continue;
                if (gotTitle) {
                    builder.append(Jobs.getGCManager().getModifyChatSeparator());
                    gotTitle = false;
                }
                Title title = Jobs.gettitleManager().getTitle(prog.getLevel(), prog.getJob().getName());
                if (numJobs == 1) {
                    if ((method.equals((Object)DisplayMethod.FULL) || method.equals((Object)DisplayMethod.TITLE)) && title != null) {
                        honorificpart = (Object)((Object)title.getChatColor()) + title.getName() + (Object)((Object)ChatColor.WHITE);
                        if (honorificpart.contains("{level}")) {
                            honorificpart = honorificpart.replace("{level}", String.valueOf(prog.getLevel()));
                        }
                        builder.append(honorificpart);
                        gotTitle = true;
                    }
                    if (method.equals((Object)DisplayMethod.FULL) || method.equals((Object)DisplayMethod.JOB)) {
                        if (gotTitle) {
                            builder.append(" ");
                        }
                        if ((honorificpart = (Object)((Object)prog.getJob().getChatColor()) + prog.getJob().getName() + (Object)((Object)ChatColor.WHITE)).contains("{level}")) {
                            honorificpart = honorificpart.replace("{level}", String.valueOf(prog.getLevel()));
                        }
                        builder.append(honorificpart);
                        gotTitle = true;
                    }
                }
                if ((numJobs > 1 && (method.equals((Object)DisplayMethod.FULL) || method.equals((Object)DisplayMethod.TITLE)) || method.equals((Object)DisplayMethod.SHORT_FULL) || method.equals((Object)DisplayMethod.SHORT_TITLE)) && title != null) {
                    honorificpart = (Object)((Object)title.getChatColor()) + title.getShortName() + (Object)((Object)ChatColor.WHITE);
                    if (honorificpart.contains("{level}")) {
                        honorificpart = honorificpart.replace("{level}", String.valueOf(prog.getLevel()));
                    }
                    builder.append(honorificpart);
                    gotTitle = true;
                }
                if ((numJobs <= 1 || !method.equals((Object)DisplayMethod.FULL) && !method.equals((Object)DisplayMethod.JOB)) && !method.equals((Object)DisplayMethod.SHORT_FULL) && !method.equals((Object)DisplayMethod.SHORT_JOB)) continue;
                honorificpart = (Object)((Object)prog.getJob().getChatColor()) + prog.getJob().getShortName() + (Object)((Object)ChatColor.WHITE);
                if (honorificpart.contains("{level}")) {
                    honorificpart = honorificpart.replace("{level}", String.valueOf(prog.getLevel()));
                }
                builder.append(honorificpart);
                gotTitle = true;
            }
        } else {
            Job nonejob = Jobs.getNoneJob();
            if (nonejob != null) {
                String honorificpart;
                DisplayMethod metod = nonejob.getDisplayMethod();
                if (metod.equals((Object)DisplayMethod.FULL) || metod.equals((Object)DisplayMethod.TITLE)) {
                    honorificpart = (Object)((Object)Jobs.getNoneJob().getChatColor()) + Jobs.getNoneJob().getName() + (Object)((Object)ChatColor.WHITE);
                    if (honorificpart.contains("{level}")) {
                        honorificpart = honorificpart.replace("{level}", "");
                    }
                    builder.append(honorificpart);
                }
                if (metod.equals((Object)DisplayMethod.SHORT_FULL) || metod.equals((Object)DisplayMethod.SHORT_TITLE) || metod.equals((Object)DisplayMethod.SHORT_JOB)) {
                    honorificpart = (Object)((Object)Jobs.getNoneJob().getChatColor()) + Jobs.getNoneJob().getShortName() + (Object)((Object)ChatColor.WHITE);
                    if (honorificpart.contains("{level}")) {
                        honorificpart = honorificpart.replace("{level}", "");
                    }
                    builder.append(honorificpart);
                }
            }
        }
        this.honorific = builder.toString().trim();
        if (this.honorific.length() > 0) {
            this.honorific = String.valueOf(Jobs.getGCManager().getModifyChatPrefix()) + this.honorific + Jobs.getGCManager().getModifyChatSuffix();
        }
    }

    public void save() {
        if (!this.isSaved()) {
            JobsDAO dao = Jobs.getJobsDAO();
            dao.save(this);
            dao.saveLog(this);
            dao.savePoints(this);
            dao.recordPlayersLimits(this);
            dao.updateSeen(this);
            this.setSaved(true);
        }
    }

    public void onConnect() {
        this.isOnline = true;
    }

    public void onDisconnect() {
        this.clearBossMaps();
        this.isOnline = false;
    }

    public void clearBossMaps() {
        for (BossBarInfo one : this.barMap) {
            one.cancel();
        }
        this.barMap.clear();
    }

    public boolean isOnline() {
        if (this.getPlayer() != null) {
            return this.getPlayer().isOnline();
        }
        return this.isOnline;
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void setSaved(boolean value) {
        this.isSaved = value;
    }

    public Long getSeen() {
        return this.seen;
    }

    public void setSeen(Long seen) {
        this.seen = seen;
    }

    public HashMap<String, Boolean> getPermissionsCache() {
        return this.permissionsCache;
    }

    public void setPermissionsCache(HashMap<String, Boolean> permissionsCache) {
        this.permissionsCache = permissionsCache;
    }

    public void setPermissionsCache(String permission, Boolean state) {
        this.permissionsCache.put(permission, state);
    }

    public Long getLastPermissionUpdate() {
        return this.lastPermissionUpdate;
    }

    public void setLastPermissionUpdate(Long lastPermissionUpdate) {
        this.lastPermissionUpdate = lastPermissionUpdate;
    }
}

