/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.container;

import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobsPlayer;
import java.util.HashMap;

public class JobProgression {
    private Job job;
    private JobsPlayer jPlayer;
    private double experience;
    private int level;
    private transient int maxExperience = -1;

    public JobProgression(Job job, JobsPlayer jPlayer, int level, double experience) {
        this.job = job;
        this.jPlayer = jPlayer;
        this.experience = experience;
        this.level = level;
    }

    public boolean canLevelUp() {
        return this.experience >= (double)this.maxExperience;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.jPlayer.setSaved(false);
        this.job = job;
        this.reloadMaxExperienceAndCheckLevelUp();
    }

    public double getExperience() {
        return this.experience;
    }

    public boolean addExperience(double experience) {
        this.jPlayer.setSaved(false);
        this.experience += experience;
        return this.checkLevelUp();
    }

    public int getMaxExperience() {
        return this.maxExperience;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.jPlayer.setSaved(false);
        this.level = level;
        this.reloadMaxExperienceAndCheckLevelUp();
    }

    public void reloadMaxExperience() {
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("joblevel", Double.valueOf(this.level));
        param.put("numjobs", Double.valueOf(this.jPlayer.getJobProgression().size()));
        this.maxExperience = (int)this.job.getMaxExp(param);
    }

    private boolean checkLevelUp() {
        boolean ret = false;
        while (this.canLevelUp()) {
            int maxLevel = 0;
            maxLevel = this.jPlayer.havePermission("jobs." + this.job.getName() + ".vipmaxlevel") && this.job.getVipMaxLevel() != 0 ? this.job.getVipMaxLevel() : this.job.getMaxLevel();
            if (this.job.getMaxLevel() > 0 && this.level >= maxLevel) break;
            ++this.level;
            this.experience -= (double)this.maxExperience;
            ret = true;
            this.reloadMaxExperience();
        }
        if (this.experience > (double)this.maxExperience) {
            this.experience = this.maxExperience;
        }
        return ret;
    }

    private boolean reloadMaxExperienceAndCheckLevelUp() {
        this.reloadMaxExperience();
        return this.checkLevelUp();
    }
}

