/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.container;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.ActionType;
import com.gamingmesh.jobs.resources.jfep.Parser;

public class JobInfo {
    private ActionType actionType;
    private int id;
    private String meta;
    private String name;
    private double baseIncome;
    private double baseXp;
    private double basePoints;
    private Parser moneyEquation;
    private Parser xpEquation;
    private Parser pointsEquation;
    private int fromLevel = 0;
    private int untilLevel = Integer.MAX_VALUE;

    public JobInfo(ActionType actionType, int id, String meta, String name, double baseIncome, Parser moneyEquation, double baseXp, Parser xpEquation, Parser pointsEquation, double basePoints, int fromLevel, int untilLevel) {
        this.actionType = actionType;
        this.id = id;
        this.meta = meta;
        this.name = name;
        this.baseIncome = baseIncome;
        this.moneyEquation = moneyEquation;
        this.pointsEquation = pointsEquation;
        this.basePoints = basePoints;
        this.baseXp = baseXp;
        this.xpEquation = xpEquation;
        this.fromLevel = fromLevel;
        this.untilLevel = untilLevel;
    }

    public int getFromLevel() {
        return this.fromLevel;
    }

    public int getUntilLevel() {
        return this.untilLevel;
    }

    public boolean isInLevelRange(int level) {
        return level >= this.fromLevel && (level <= this.untilLevel || this.untilLevel == -1);
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getMeta() {
        return this.meta;
    }

    public double getBaseIncome() {
        return this.baseIncome;
    }

    public double getBaseXp() {
        return this.baseXp;
    }

    public double getBasePoints() {
        return this.basePoints;
    }

    public double getIncome(double level, double numjobs) {
        if (this.baseIncome == 0.0 || !Jobs.getGCManager().PaymentMethodsMoney) {
            return 0.0;
        }
        this.moneyEquation.setVariable("joblevel", level);
        this.moneyEquation.setVariable("numjobs", numjobs);
        this.moneyEquation.setVariable("baseincome", this.baseIncome);
        return this.moneyEquation.getValue();
    }

    public double getExperience(double level, double numjobs) {
        if (this.baseXp == 0.0 || !Jobs.getGCManager().PaymentMethodsExp) {
            return 0.0;
        }
        this.xpEquation.setVariable("joblevel", level);
        this.xpEquation.setVariable("numjobs", numjobs);
        this.xpEquation.setVariable("baseexperience", this.baseXp);
        return this.xpEquation.getValue();
    }

    public double getPoints(double level, double numjobs) {
        if (this.basePoints == 0.0 || !Jobs.getGCManager().PaymentMethodsPoints) {
            return 0.0;
        }
        this.pointsEquation.setVariable("joblevel", level);
        this.pointsEquation.setVariable("numjobs", numjobs);
        this.pointsEquation.setVariable("basepoints", this.basePoints);
        return this.pointsEquation.getValue();
    }
}

