/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.config;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.CuboidArea;
import com.gamingmesh.jobs.container.RestrictedArea;
import com.gamingmesh.jobs.stuff.ChatColor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class RestrictedAreaManager {
    protected HashMap<String, RestrictedArea> restrictedAreas = new HashMap();
    private Jobs plugin;

    public RestrictedAreaManager(Jobs plugin) {
        this.plugin = plugin;
    }

    public boolean isExist(String name) {
        for (Map.Entry<String, RestrictedArea> area2 : this.restrictedAreas.entrySet()) {
            if (!area2.getKey().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void addNew(RestrictedArea ra) {
        this.addNew(ra, false);
    }

    public void addNew(RestrictedArea ra, boolean save) {
        this.restrictedAreas.put(ra.getName(), ra);
        if (save) {
            this.save();
        }
    }

    public void remove(String name, boolean save) {
        for (Map.Entry<String, RestrictedArea> area2 : this.restrictedAreas.entrySet()) {
            if (!area2.getKey().equalsIgnoreCase(name)) continue;
            this.restrictedAreas.remove(area2.getKey());
            break;
        }
        if (save) {
            this.save();
        }
    }

    public HashMap<String, RestrictedArea> getRestrictedAres() {
        return this.restrictedAreas;
    }

    private void save() {
        File f = new File(this.plugin.getDataFolder(), "restrictedAreas.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        conf.options().indent(2);
        conf.options().copyDefaults(true);
        StringBuilder header = new StringBuilder();
        header = RestrictedAreaManager.addHeader(header);
        for (Map.Entry<String, RestrictedArea> area2 : this.restrictedAreas.entrySet()) {
            String areaKey = area2.getKey();
            CuboidArea cuboid = area2.getValue().getCuboidArea();
            conf.set("restrictedareas." + areaKey + ".world", (Object)cuboid.getWorld().getName());
            conf.set("restrictedareas." + areaKey + ".multiplier", (Object)area2.getValue().getMultiplier());
            conf.set("restrictedareas." + areaKey + ".point1.x", (Object)cuboid.getLowLoc().getBlockX());
            conf.set("restrictedareas." + areaKey + ".point1.y", (Object)cuboid.getLowLoc().getBlockY());
            conf.set("restrictedareas." + areaKey + ".point1.z", (Object)cuboid.getLowLoc().getBlockZ());
            conf.set("restrictedareas." + areaKey + ".point2.x", (Object)cuboid.getHighLoc().getBlockX());
            conf.set("restrictedareas." + areaKey + ".point2.y", (Object)cuboid.getHighLoc().getBlockY());
            conf.set("restrictedareas." + areaKey + ".point2.z", (Object)cuboid.getHighLoc().getBlockZ());
        }
        try {
            conf.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized double getRestrictedMultiplier(Player player) {
        if (player == null) {
            return 0.0;
        }
        for (Map.Entry<String, RestrictedArea> area2 : this.restrictedAreas.entrySet()) {
            if (!area2.getValue().inRestrictedArea(player.getLocation())) continue;
            return area2.getValue().getMultiplier();
        }
        return 0.0;
    }

    public synchronized List<RestrictedArea> getRestrictedAreasByLoc(Location loc) {
        ArrayList<RestrictedArea> areas = new ArrayList<RestrictedArea>();
        for (Map.Entry<String, RestrictedArea> area2 : this.restrictedAreas.entrySet()) {
            if (!area2.getValue().inRestrictedArea(loc)) continue;
            areas.add(area2.getValue());
        }
        return areas;
    }

    private static StringBuilder addHeader(StringBuilder header) {
        header.append("Restricted area configuration");
        header.append(System.getProperty("line.separator")).append(System.getProperty("line.separator")).append("Configures restricted areas where you cannot get experience or money").append(System.getProperty("line.separator")).append("when performing a job.").append(System.getProperty("line.separator")).append(System.getProperty("line.separator")).append("The multiplier changes the experience/money gains in an area.").append(System.getProperty("line.separator")).append("A multiplier of 0.0 means no bonus, while 0.5 means you will get 50% more the normal income").append(System.getProperty("line.separator")).append("While -0.5 means that you will get 50% less the normal income").append(System.getProperty("line.separator")).append(System.getProperty("line.separator")).append("restrictedareas:").append(System.getProperty("line.separator")).append("  area1:").append(System.getProperty("line.separator")).append("    world: 'world'").append(System.getProperty("line.separator")).append("    multiplier: 0.0").append(System.getProperty("line.separator")).append("    point1:").append(System.getProperty("line.separator")).append("      x: 125").append(System.getProperty("line.separator")).append("      y: 0").append(System.getProperty("line.separator")).append("      z: 125").append(System.getProperty("line.separator")).append("    point2:").append(System.getProperty("line.separator")).append("      x: 150").append(System.getProperty("line.separator")).append("      y: 100").append(System.getProperty("line.separator")).append("      z: 150").append(System.getProperty("line.separator")).append("  area2:").append(System.getProperty("line.separator")).append("    world: 'world_nether'").append(System.getProperty("line.separator")).append("    multiplier: 0.0").append(System.getProperty("line.separator")).append("    point1:").append(System.getProperty("line.separator")).append("      x: -100").append(System.getProperty("line.separator")).append("      y: 0").append(System.getProperty("line.separator")).append("      z: -100").append(System.getProperty("line.separator")).append("    point2:").append(System.getProperty("line.separator")).append("      x: -150").append(System.getProperty("line.separator")).append("      y: 100").append(System.getProperty("line.separator")).append("      z: -150");
        return header;
    }

    public synchronized void load() {
        this.restrictedAreas.clear();
        File f = new File(this.plugin.getDataFolder(), "restrictedAreas.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        conf.options().indent(2);
        conf.options().copyDefaults(true);
        StringBuilder header = new StringBuilder();
        header = RestrictedAreaManager.addHeader(header);
        conf.options().header(header.toString());
        ConfigurationSection areaSection = conf.getConfigurationSection("restrictedareas");
        if (areaSection != null) {
            for (String areaKey : areaSection.getKeys(false)) {
                String worldName = conf.getString("restrictedareas." + areaKey + ".world");
                double multiplier = conf.getDouble("restrictedareas." + areaKey + ".multiplier", 0.0);
                World world = Bukkit.getServer().getWorld(worldName);
                if (world == null) continue;
                Location point1 = new Location(world, conf.getDouble("restrictedareas." + areaKey + ".point1.x", 0.0), conf.getDouble("restrictedareas." + areaKey + ".point1.y", 0.0), conf.getDouble("restrictedareas." + areaKey + ".point1.z", 0.0));
                Location point2 = new Location(world, conf.getDouble("restrictedareas." + areaKey + ".point2.x", 0.0), conf.getDouble("restrictedareas." + areaKey + ".point2.y", 0.0), conf.getDouble("restrictedareas." + areaKey + ".point2.z", 0.0));
                this.addNew(new RestrictedArea(areaKey, new CuboidArea(point1, point2), multiplier));
            }
        }
        Bukkit.getConsoleSender().sendMessage((Object)((Object)ChatColor.YELLOW) + "[Jobs] Loaded " + this.restrictedAreas.size() + " restricted areas!");
        try {
            conf.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

