/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.config;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.bukkit.configuration.file.YamlConfiguration;

public class CommentedYamlConfiguration
extends YamlConfiguration {
    private HashMap<String, String> comments = new HashMap();

    public void save(String file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        this.save(new File(file));
    }

    public void save(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        Files.createParentDirs((File)file);
        String data = this.insertComments(this.saveToString());
        try (PrintWriter writer = new PrintWriter(file, "UTF-8");){
            writer.write(data);
        }
    }

    private String insertComments(String yaml) {
        block22: {
            if (this.comments.isEmpty()) break block22;
            String[] yamlContents = yaml.split("[" + System.getProperty("line.separator") + "]");
            StringBuilder newContents = new StringBuilder();
            StringBuilder currentPath = new StringBuilder();
            boolean commentedPath = false;
            boolean node = false;
            int depth = 0;
            boolean firstLine = true;
            String[] stringArray = yamlContents;
            int n = yamlContents.length;
            int n2 = 0;
            while (n2 < n) {
                block24: {
                    String line;
                    block23: {
                        line = stringArray[n2];
                        if (!firstLine) break block23;
                        firstLine = false;
                        if (line.startsWith("#")) break block24;
                    }
                    if (line.contains(": ") || line.length() > 1 && line.charAt(line.length() - 1) == ':') {
                        commentedPath = false;
                        node = true;
                        int index = 0;
                        index = line.indexOf(": ");
                        if (index < 0) {
                            index = line.length() - 1;
                        }
                        if (currentPath.toString().isEmpty()) {
                            currentPath = new StringBuilder(line.substring(0, index));
                        } else {
                            int whiteSpace = 0;
                            int n3 = 0;
                            while (n3 < line.length()) {
                                if (line.charAt(n3) != ' ') break;
                                ++whiteSpace;
                                ++n3;
                            }
                            if (whiteSpace / 2 > depth) {
                                currentPath.append(".").append(line.substring(whiteSpace, index));
                                ++depth;
                            } else if (whiteSpace / 2 < depth) {
                                int newDepth = whiteSpace / 2;
                                int i = 0;
                                while (i < depth - newDepth) {
                                    currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "");
                                    ++i;
                                }
                                int lastIndex = currentPath.lastIndexOf(".");
                                if (lastIndex < 0) {
                                    currentPath = new StringBuilder();
                                } else {
                                    currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "").append(".");
                                }
                                currentPath.append(line.substring(whiteSpace, index));
                                depth = newDepth;
                            } else {
                                int lastIndex = currentPath.lastIndexOf(".");
                                if (lastIndex < 0) {
                                    currentPath = new StringBuilder();
                                } else {
                                    currentPath.replace(currentPath.lastIndexOf("."), currentPath.length(), "").append(".");
                                }
                                currentPath.append(line.substring(whiteSpace, index));
                            }
                        }
                    } else {
                        node = false;
                    }
                    StringBuilder newLine = new StringBuilder(line);
                    if (node) {
                        String comment = null;
                        if (!commentedPath) {
                            comment = this.comments.get(currentPath.toString());
                        }
                        if (comment != null && !comment.isEmpty()) {
                            newLine.insert(0, System.getProperty("line.separator")).insert(0, comment);
                            comment = null;
                            commentedPath = true;
                        }
                    }
                    newLine.append(System.getProperty("line.separator"));
                    newContents.append(newLine.toString());
                }
                ++n2;
            }
            return newContents.toString();
        }
        return yaml;
    }

    public void addComment(String path, String ... commentLines) {
        StringBuilder commentstring = new StringBuilder();
        String leadingSpaces = "";
        int n = 0;
        while (n < path.length()) {
            if (path.charAt(n) == '.') {
                leadingSpaces = String.valueOf(leadingSpaces) + "  ";
            }
            ++n;
        }
        String[] stringArray = commentLines;
        int n2 = commentLines.length;
        int n3 = 0;
        while (n3 < n2) {
            String line = stringArray[n3];
            if (!line.isEmpty()) {
                line = String.valueOf(leadingSpaces) + "# " + line;
            }
            if (commentstring.length() > 0) {
                commentstring.append(System.getProperty("line.separator"));
            }
            commentstring.append(line);
            ++n3;
        }
        this.comments.put(path, commentstring.toString());
    }
}

