/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.config;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.BossBarInfo;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BossBarManager {
    Jobs plugin;

    public BossBarManager(Jobs plugin) {
        this.plugin = plugin;
    }

    public synchronized void ShowJobProgression(JobsPlayer player) {
        if (Jobs.getActionBar().getVersion() < 1900) {
            return;
        }
        if (player == null) {
            return;
        }
        ArrayList<String> temp = new ArrayList<String>();
        temp.addAll(player.getUpdateBossBarFor());
        for (String one : temp) {
            for (JobProgression oneJob : player.getJobProgression()) {
                if (!one.equalsIgnoreCase(oneJob.getJob().getName())) continue;
                this.ShowJobProgression(player, oneJob);
            }
        }
        player.clearUpdateBossBarFor();
    }

    public synchronized void ShowJobProgression(final JobsPlayer player, final JobProgression jobProg) {
        if (Jobs.getActionBar().getVersion() < 1900) {
            return;
        }
        String playername = player.getUserName();
        if (!Jobs.getBossBarToggleList().containsKey(playername) && Jobs.getGCManager().BossBarsMessageByDefault) {
            Jobs.getBossBarToggleList().put(playername, true);
        }
        if (!Jobs.getBossBarToggleList().containsKey(playername)) {
            return;
        }
        Boolean show = Jobs.getBossBarToggleList().get(playername);
        if (!show.booleanValue()) {
            return;
        }
        BossBar bar = null;
        BossBarInfo OldOne = null;
        for (BossBarInfo one : player.getBossBarInfo()) {
            if (!one.getJobName().equalsIgnoreCase(jobProg.getJob().getName())) continue;
            one.cancel();
            bar = one.getBar();
            OldOne = one;
            break;
        }
        DecimalFormat formatter = new DecimalFormat("#0.00");
        String message = Jobs.getLanguage().getMessage("command.stats.output", "%joblevel%", Integer.valueOf(jobProg.getLevel()).toString(), "%jobname%", (Object)((Object)jobProg.getJob().getChatColor()) + jobProg.getJob().getName() + ChatColor.WHITE, "%jobxp%", formatter.format((double)Math.round(jobProg.getExperience() * 100.0) / 100.0), "%jobmaxxp%", jobProg.getMaxExperience());
        if (bar == null) {
            BarColor color = BossBarManager.getColor(jobProg.getJob());
            if (color == null) {
                switch (player.getBossBarInfo().size()) {
                    case 1: {
                        color = BarColor.GREEN;
                        break;
                    }
                    case 2: {
                        color = BarColor.RED;
                        break;
                    }
                    case 3: {
                        color = BarColor.WHITE;
                        break;
                    }
                    case 4: {
                        color = BarColor.YELLOW;
                        break;
                    }
                    case 5: {
                        color = BarColor.PINK;
                        break;
                    }
                    case 6: {
                        color = BarColor.PURPLE;
                        break;
                    }
                    default: {
                        color = BarColor.BLUE;
                    }
                }
            }
            bar = Bukkit.createBossBar((String)message, (BarColor)color, (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
        } else {
            bar.setTitle(message);
        }
        double percentage = jobProg.getExperience() / (double)jobProg.getMaxExperience();
        try {
            bar.setProgress(percentage);
            if (OldOne == null) {
                Player target = Bukkit.getPlayer((UUID)player.getPlayer().getUniqueId());
                if (target == null) {
                    return;
                }
                bar.addPlayer(target);
                OldOne = new BossBarInfo(player.getUserName(), jobProg.getJob().getName(), bar);
                player.getBossBarInfo().add(OldOne);
            }
            bar.setVisible(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (OldOne == null) {
            return;
        }
        OldOne.setId(Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (BossBarInfo one : player.getBossBarInfo()) {
                    if (!one.getPlayerName().equalsIgnoreCase(player.getUserName()) || !one.getJobName().equalsIgnoreCase(jobProg.getJob().getName())) continue;
                    BossBar tempBar = one.getBar();
                    tempBar.setVisible(false);
                    break;
                }
            }
        }, (long)Jobs.getGCManager().BossBarTimer * 20L));
    }

    private static BarColor getColor(Job job) {
        if (job.getBossbar() == null) {
            return null;
        }
        BarColor[] barColorArray = BarColor.values();
        int n = barColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            BarColor color = barColorArray[n2];
            if (job.getBossbar().equalsIgnoreCase(color.name())) {
                return color;
            }
            ++n2;
        }
        return null;
    }
}

