/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.config;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.BlockProtection;
import com.gamingmesh.jobs.container.DBAction;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.util.Vector;

public class BlockProtectionManager {
    private HashMap<World, HashMap<String, HashMap<String, HashMap<Vector, BlockProtection>>>> map = new HashMap();
    public Long timer = 0L;

    public HashMap<World, HashMap<String, HashMap<String, HashMap<Vector, BlockProtection>>>> getMap() {
        return this.map;
    }

    public int getSize() {
        int i = 0;
        for (Map.Entry<World, HashMap<String, HashMap<String, HashMap<Vector, BlockProtection>>>> worlds : this.map.entrySet()) {
            for (Map.Entry<String, HashMap<String, HashMap<Vector, BlockProtection>>> regions : worlds.getValue().entrySet()) {
                for (Map.Entry<String, HashMap<Vector, BlockProtection>> chunks : regions.getValue().entrySet()) {
                    i += chunks.getValue().size();
                }
            }
        }
        return i;
    }

    public void add(Block block, boolean paid) {
        this.add(block, (Long)-1L, paid);
    }

    public void add(Block block) {
        this.add(block, (Long)-1L, true);
    }

    public void add(Block block, Long time, boolean paid) {
        this.add(block.getLocation(), time, paid);
    }

    public void add(Block block, Integer cd) {
        this.add(block, cd, true);
    }

    public void add(Block block, Integer cd, boolean paid) {
        if (cd == null) {
            return;
        }
        if (cd != -1) {
            this.add(block, (Long)(System.currentTimeMillis() + (long)(cd * 1000)), paid);
        } else {
            this.add(block, paid);
        }
    }

    public void add(Block block, Long time) {
        this.add(block.getLocation(), time, true);
    }

    public void add(Location loc, Long time) {
        this.add(loc, time, true);
    }

    public BlockProtection add(Location loc, Long time, boolean paid) {
        BlockProtection Bp;
        String chunk;
        HashMap<Object, BlockProtection> Bpm;
        String region;
        HashMap<String, HashMap<Object, BlockProtection>> chunks;
        Vector v = new Vector(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        HashMap<String, HashMap<String, HashMap<Object, BlockProtection>>> regions = this.map.get(loc.getWorld());
        if (regions == null) {
            regions = new HashMap();
        }
        if ((chunks = regions.get(region = BlockProtectionManager.locToRegion(loc))) == null) {
            chunks = new HashMap();
        }
        if ((Bpm = chunks.get(chunk = BlockProtectionManager.locToChunk(loc))) == null) {
            Bpm = new HashMap();
        }
        if ((Bp = Bpm.get(v)) == null) {
            Bp = new BlockProtection(DBAction.INSERT);
        } else {
            Bp.setAction(DBAction.UPDATE);
        }
        Bp.setPaid(paid);
        Bp.setTime(time);
        Bpm.put(v, Bp);
        chunks.put(chunk, Bpm);
        regions.put(region, chunks);
        this.map.put(loc.getWorld(), regions);
        return Bp;
    }

    public BlockProtection remove(Block block) {
        return this.remove(block.getLocation());
    }

    public BlockProtection remove(Location loc) {
        HashMap<String, HashMap<String, HashMap<Vector, BlockProtection>>> world = this.map.get(loc.getWorld());
        if (world == null) {
            return null;
        }
        HashMap<String, HashMap<Vector, BlockProtection>> region = world.get(BlockProtectionManager.locToRegion(loc));
        if (region == null) {
            return null;
        }
        HashMap<Vector, BlockProtection> chunk = region.get(BlockProtectionManager.locToChunk(loc));
        if (chunk == null) {
            return null;
        }
        Vector v = new Vector(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        BlockProtection bp2 = chunk.get(v);
        if (bp2 != null) {
            bp2.setAction(DBAction.DELETE);
        }
        return bp2;
    }

    public Long getTime(Block block) {
        return this.getTime(block.getLocation());
    }

    public Long getTime(Location loc) {
        BlockProtection Bp = this.getBp(loc);
        if (Bp == null) {
            return null;
        }
        return Bp.getTime();
    }

    public BlockProtection getBp(Location loc) {
        HashMap<String, HashMap<String, HashMap<Vector, BlockProtection>>> world = this.map.get(loc.getWorld());
        if (world == null) {
            return null;
        }
        HashMap<String, HashMap<Vector, BlockProtection>> region = world.get(BlockProtectionManager.locToRegion(loc));
        if (region == null) {
            return null;
        }
        HashMap<Vector, BlockProtection> chunk = region.get(BlockProtectionManager.locToChunk(loc));
        if (chunk == null) {
            return null;
        }
        Vector v = new Vector(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        BlockProtection Bp = chunk.get(v);
        if (Bp == null) {
            return null;
        }
        return Bp;
    }

    private static String locToChunk(Location loc) {
        int x = (int)Math.floor(loc.getBlockX() / 16);
        int z = (int)Math.floor(loc.getBlockZ() / 16);
        return String.valueOf(x) + ":" + z;
    }

    private static String locToRegion(Location loc) {
        int x = (int)Math.floor(loc.getBlockX() / 16);
        int z = (int)Math.floor(loc.getBlockZ() / 16);
        String reg = String.valueOf((int)Math.floor(x / 32)) + ":" + (int)Math.floor(z / 32);
        return reg;
    }

    public Integer getBlockDelayTime(Block block) {
        return Jobs.getRestrictedBlockManager().restrictedBlocksTimer.get(block.getTypeId());
    }

    public boolean checkVegybreak(Block block, Player player) {
        if (!Jobs.getRestrictedBlockManager().restrictedBlocksTimer.containsKey(block.getTypeId())) {
            return false;
        }
        return this.CheckVegyTimer(block, Jobs.getRestrictedBlockManager().restrictedBlocksTimer.get(block.getTypeId()), player);
    }

    public boolean CheckVegyTimer(Block block, int time, Player player) {
        long currentTime = System.currentTimeMillis();
        if (!block.hasMetadata("VegyTimer")) {
            return false;
        }
        long BlockTime = ((MetadataValue)block.getMetadata("VegyTimer").get(0)).asLong();
        if (currentTime >= BlockTime + (long)(time * 1000)) {
            return false;
        }
        int sec = Math.round((BlockTime + (long)(time * 1000) - currentTime) / 1000L);
        Jobs.getActionBar().send((CommandSender)player, Jobs.getLanguage().getMessage("message.blocktimer", "[time]", sec));
        return true;
    }
}

