/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs.commands.list;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.PlayerManager;
import com.gamingmesh.jobs.commands.Cmd;
import com.gamingmesh.jobs.commands.JobCommand;
import com.gamingmesh.jobs.container.Boost;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gamingmesh.jobs.stuff.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class bonus
implements Cmd {
    String mc = ChatColor.DARK_GREEN.toString();
    String pc = ChatColor.GOLD.toString();
    String ec = ChatColor.YELLOW.toString();

    @Override
    @JobCommand(value=300)
    public boolean perform(Jobs plugin, CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Jobs.getLanguage().getMessage("general.error.ingame"));
            return false;
        }
        if (args.length != 1) {
            Jobs.getCommandManager().sendUsage(sender, "bonus");
            return true;
        }
        Player player = (Player)sender;
        Job job = Jobs.getJob(args[0]);
        if (job == null) {
            sender.sendMessage(Jobs.getLanguage().getMessage("general.error.job"));
            return true;
        }
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        if (jPlayer == null) {
            return false;
        }
        Boost boost = Jobs.getPlayerManager().getFinalBonus(jPlayer, job, true, true);
        sender.sendMessage(Jobs.getLanguage().getMessage("command.bonus.output.topline"));
        this.printBoost(sender, boost, PlayerManager.BoostOf.Permission);
        this.printBoost(sender, boost, PlayerManager.BoostOf.Item);
        this.printBoost(sender, boost, PlayerManager.BoostOf.Global);
        if (Jobs.getGCManager().useDynamicPayment) {
            this.printBoost(sender, boost, PlayerManager.BoostOf.Dynamic);
        }
        this.printBoost(sender, boost, PlayerManager.BoostOf.Area);
        if (Jobs.getGCManager().payNearSpawner()) {
            this.printBoost(sender, boost, PlayerManager.BoostOf.NearSpawner);
        }
        this.printBoost(sender, boost, PlayerManager.BoostOf.PetPay);
        if (Jobs.getMcMMOlistener().mcMMOPresent && boost.get(PlayerManager.BoostOf.McMMO, CurrencyType.EXP) != 0.0) {
            this.printBoost(sender, boost, PlayerManager.BoostOf.McMMO);
        }
        sender.sendMessage(Jobs.getLanguage().getMessage("general.info.separator"));
        String msg = Jobs.getLanguage().getMessage("command.bonus.output.final", "%money%", String.valueOf(this.mc) + bonus.formatText(boost.getFinal(CurrencyType.MONEY, true, true)), "%points%", String.valueOf(this.pc) + bonus.formatText(boost.getFinal(CurrencyType.POINTS, true, true)), "%exp%", String.valueOf(this.ec) + bonus.formatText(boost.getFinal(CurrencyType.EXP, true, true)));
        String txt = "[\"\",{\"text\":\"" + msg + "\",\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\"" + Jobs.getLanguage().getMessage("command.bonus.output.finalExplanation") + "\"}]}}}]";
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("tellraw " + player.getName() + " " + txt));
        return true;
    }

    private void printBoost(CommandSender sender, Boost boost, PlayerManager.BoostOf type) {
        String msg;
        String prefix = (Object)((Object)ChatColor.GOLD) + "*";
        if (type != PlayerManager.BoostOf.NearSpawner && type != PlayerManager.BoostOf.PetPay) {
            prefix = "";
        }
        if ((msg = Jobs.getLanguage().getMessage("command.bonus.output." + type.name().toLowerCase(), "%money%", String.valueOf(this.mc) + bonus.formatText(boost.get(type, CurrencyType.MONEY, true)), "%points%", String.valueOf(this.pc) + bonus.formatText(boost.get(type, CurrencyType.POINTS, true)), "%exp%", String.valueOf(this.ec) + bonus.formatText(boost.get(type, CurrencyType.EXP, true)))).startsWith(" ") && (type == PlayerManager.BoostOf.NearSpawner || type == PlayerManager.BoostOf.PetPay)) {
            msg = msg.substring(1, msg.length());
        }
        sender.sendMessage(String.valueOf(prefix) + msg);
    }

    private static String formatText(double amount) {
        return String.valueOf(amount > 0.0 ? "+" : "") + amount + "%";
    }
}

