/*
 * Decompiled with CFR 0.152.
 */
package com.gamingmesh.jobs;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.api.JobsJoinEvent;
import com.gamingmesh.jobs.api.JobsLeaveEvent;
import com.gamingmesh.jobs.api.JobsLevelUpEvent;
import com.gamingmesh.jobs.container.Boost;
import com.gamingmesh.jobs.container.BoostMultiplier;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobCommands;
import com.gamingmesh.jobs.container.JobItems;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.gamingmesh.jobs.container.PlayerInfo;
import com.gamingmesh.jobs.dao.JobsDAO;
import com.gamingmesh.jobs.dao.JobsDAOData;
import com.gamingmesh.jobs.economy.PointsData;
import com.gamingmesh.jobs.stuff.ChatColor;
import com.gamingmesh.jobs.stuff.PerformCommands;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class PlayerManager {
    private ConcurrentHashMap<String, JobsPlayer> playersCache = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, JobsPlayer> playersUUIDCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, JobsPlayer> players = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, JobsPlayer> playersUUID = new ConcurrentHashMap();
    private PointsData PointsDatabase = new PointsData();
    private final String mobSpawnerMetadata = "jobsMobSpawner";
    private HashMap<UUID, PlayerInfo> PlayerUUIDMap = new HashMap();
    private HashMap<Integer, PlayerInfo> PlayerIDMap = new HashMap();
    private HashMap<String, PlayerInfo> PlayerNameMap = new HashMap();
    Jobs plugin;

    public PlayerManager(Jobs plugin) {
        this.plugin = plugin;
    }

    public PointsData getPointsData() {
        return this.PointsDatabase;
    }

    public int getMapSize() {
        return this.PlayerUUIDMap.size();
    }

    public void clearMaps() {
        this.PlayerUUIDMap.clear();
        this.PlayerIDMap.clear();
        this.PlayerNameMap.clear();
    }

    public void addPlayerToMap(PlayerInfo info2) {
        this.PlayerUUIDMap.put(info2.getUuid(), info2);
        this.PlayerIDMap.put(info2.getID(), info2);
        this.PlayerNameMap.put(info2.getName().toLowerCase(), info2);
    }

    public void addPlayerToCache(JobsPlayer jPlayer) {
        if (jPlayer.getUserName() != null) {
            this.playersCache.put(jPlayer.getUserName().toLowerCase(), jPlayer);
        }
        if (jPlayer.getPlayerUUID() != null) {
            this.playersUUIDCache.put(jPlayer.getPlayerUUID(), jPlayer);
        }
    }

    public void addPlayer(JobsPlayer jPlayer) {
        if (jPlayer.getUserName() != null) {
            this.players.put(jPlayer.getUserName().toLowerCase(), jPlayer);
        }
        if (jPlayer.getPlayerUUID() != null) {
            this.playersUUID.put(jPlayer.getPlayerUUID(), jPlayer);
        }
    }

    public JobsPlayer removePlayer(Player player) {
        if (player == null) {
            return null;
        }
        this.players.remove(player.getName().toLowerCase());
        JobsPlayer jPlayer = this.playersUUID.remove(player.getUniqueId());
        return jPlayer;
    }

    public ConcurrentHashMap<UUID, JobsPlayer> getPlayersCache() {
        return this.playersUUIDCache;
    }

    public HashMap<UUID, PlayerInfo> getPlayersInfoUUIDMap() {
        return this.PlayerUUIDMap;
    }

    public int getPlayerId(String name) {
        PlayerInfo info2 = this.getPlayerInfo(name);
        return info2 == null ? -1 : info2.getID();
    }

    public int getPlayerId(UUID uuid) {
        PlayerInfo info2 = this.PlayerUUIDMap.get(uuid);
        return info2 == null ? -1 : info2.getID();
    }

    public PlayerInfo getPlayerInfo(String name) {
        return this.PlayerNameMap.get(name.toLowerCase());
    }

    public PlayerInfo getPlayerInfo(int id) {
        return this.PlayerIDMap.get(id);
    }

    public PlayerInfo getPlayerInfo(UUID uuid) {
        return this.PlayerUUIDMap.get(uuid);
    }

    public void playerJoin(Player player) {
        JobsPlayer jPlayer = this.playersUUIDCache.get(player.getUniqueId());
        if (jPlayer == null || Jobs.getGCManager().MultiServerCompatability()) {
            jPlayer = Jobs.getJobsDAO().loadFromDao((OfflinePlayer)player);
            jPlayer.loadLogFromDao();
        }
        this.addPlayer(jPlayer);
        jPlayer.setPlayer(player);
        this.AutoJoinJobs(player);
        jPlayer.onConnect();
        jPlayer.reloadHonorific();
        Jobs.getPermissionHandler().recalculatePermissions(jPlayer);
    }

    public void playerQuit(Player player) {
        JobsPlayer jPlayer = this.removePlayer(player);
        if (jPlayer == null) {
            jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        }
        if (jPlayer == null) {
            return;
        }
        this.addPlayerToCache(jPlayer);
        if (Jobs.getGCManager().saveOnDisconnect()) {
            jPlayer.save();
            jPlayer.onDisconnect();
        } else {
            jPlayer.onDisconnect();
        }
    }

    public void saveAll() {
        ArrayList<JobsPlayer> list = new ArrayList<JobsPlayer>(this.players.values());
        for (JobsPlayer jPlayer : list) {
            jPlayer.save();
        }
        Iterator<JobsPlayer> iter = this.players.values().iterator();
        while (iter.hasNext()) {
            JobsPlayer jPlayer = iter.next();
            if (jPlayer.isOnline() || !jPlayer.isSaved()) continue;
            iter.remove();
        }
    }

    public JobsPlayer getJobsPlayer(Player player) {
        return this.getJobsPlayer(player.getUniqueId());
    }

    public JobsPlayer getJobsPlayer(UUID uuid) {
        JobsPlayer jPlayer = this.playersUUID.get(uuid);
        if (jPlayer != null) {
            return jPlayer;
        }
        return this.playersUUIDCache.get(uuid);
    }

    public JobsPlayer getJobsPlayer(String playerName) {
        JobsPlayer jPlayer = this.players.get(playerName.toLowerCase());
        if (jPlayer != null) {
            return jPlayer;
        }
        return this.playersCache.get(playerName.toLowerCase());
    }

    public JobsPlayer getJobsPlayerOffline(PlayerInfo info2) {
        if (info2 == null) {
            return null;
        }
        if (info2.getName() == null) {
            return null;
        }
        JobsPlayer jPlayer = new JobsPlayer(info2.getName(), null);
        jPlayer.setPlayerUUID(info2.getUuid());
        jPlayer.setUserId(info2.getID());
        List<JobsDAOData> list = Jobs.getJobsDAO().getAllJobs(info2.getName(), info2.getUuid());
        for (JobsDAOData jobdata : list) {
            Job job;
            if (Jobs.getJob(jobdata.getJobName()) == null || (job = Jobs.getJob(jobdata.getJobName())) == null) continue;
            JobProgression jobProgression = new JobProgression(job, jPlayer, jobdata.getLevel(), jobdata.getExperience());
            jPlayer.progression.add(jobProgression);
            jPlayer.reloadMaxExperience();
            jPlayer.reloadLimits();
        }
        Jobs.getJobsDAO().loadPoints(jPlayer);
        jPlayer.loadLogFromDao();
        return jPlayer;
    }

    public void joinJob(JobsPlayer jPlayer, Job job) {
        if (jPlayer.isInJob(job)) {
            return;
        }
        if (!jPlayer.joinJob(job)) {
            return;
        }
        JobsJoinEvent jobsjoinevent = new JobsJoinEvent(jPlayer, job);
        Bukkit.getServer().getPluginManager().callEvent((Event)jobsjoinevent);
        if (jobsjoinevent.isCancelled()) {
            return;
        }
        Jobs.getJobsDAO().joinJob(jPlayer, job);
        PerformCommands.PerformCommandsOnJoin(jPlayer, job);
        Jobs.takeSlot(job);
        Jobs.getSignUtil().SignUpdate(job.getName());
        Jobs.getSignUtil().SignUpdate("gtoplist");
        job.updateTotalPlayers();
    }

    public boolean leaveJob(JobsPlayer jPlayer, Job job) {
        if (!jPlayer.isInJob(job)) {
            return false;
        }
        JobsLeaveEvent jobsleaveevent = new JobsLeaveEvent(jPlayer, job);
        Bukkit.getServer().getPluginManager().callEvent((Event)jobsleaveevent);
        if (jobsleaveevent.isCancelled()) {
            return false;
        }
        Jobs.getJobsDAO().recordToArchive(jPlayer, job);
        if (!jPlayer.leaveJob(job)) {
            return false;
        }
        if (!Jobs.getJobsDAO().quitJob(jPlayer, job)) {
            return false;
        }
        PerformCommands.PerformCommandsOnLeave(jPlayer, job);
        Jobs.leaveSlot(job);
        Jobs.getSignUtil().SignUpdate(job.getName());
        Jobs.getSignUtil().SignUpdate("gtoplist");
        job.updateTotalPlayers();
        return true;
    }

    public void leaveAllJobs(JobsPlayer jPlayer) {
        ArrayList<JobProgression> jobs = new ArrayList<JobProgression>();
        jobs.addAll(jPlayer.getJobProgression());
        for (JobProgression job : jobs) {
            this.leaveJob(jPlayer, job.getJob());
        }
        jPlayer.leaveAllJobs();
    }

    public boolean transferJob(JobsPlayer jPlayer, Job oldjob, Job newjob) {
        if (!jPlayer.transferJob(oldjob, newjob)) {
            return false;
        }
        JobsDAO dao = Jobs.getJobsDAO();
        if (!dao.quitJob(jPlayer, oldjob)) {
            return false;
        }
        oldjob.updateTotalPlayers();
        dao.joinJob(jPlayer, newjob);
        newjob.updateTotalPlayers();
        jPlayer.save();
        return true;
    }

    public void promoteJob(JobsPlayer jPlayer, Job job, int levels) {
        jPlayer.promoteJob(job, levels);
        jPlayer.save();
        Jobs.getSignUtil().SignUpdate(job.getName());
        Jobs.getSignUtil().SignUpdate("gtoplist");
    }

    public void demoteJob(JobsPlayer jPlayer, Job job, int levels) {
        jPlayer.demoteJob(job, levels);
        jPlayer.save();
        Jobs.getSignUtil().SignUpdate(job.getName());
        Jobs.getSignUtil().SignUpdate("gtoplist");
    }

    public void addExperience(JobsPlayer jPlayer, Job job, double experience) {
        JobProgression prog = jPlayer.getJobProgression(job);
        if (prog == null) {
            return;
        }
        int oldLevel = prog.getLevel();
        if (prog.addExperience(experience)) {
            this.performLevelUp(jPlayer, job, oldLevel);
        }
        jPlayer.save();
        Jobs.getSignUtil().SignUpdate(job.getName());
        Jobs.getSignUtil().SignUpdate("gtoplist");
    }

    public void removeExperience(JobsPlayer jPlayer, Job job, double experience) {
        JobProgression prog = jPlayer.getJobProgression(job);
        if (prog == null) {
            return;
        }
        prog.addExperience(-experience);
        jPlayer.save();
        Jobs.getSignUtil().SignUpdate(job.getName());
        Jobs.getSignUtil().SignUpdate("gtoplist");
    }

    public void performLevelUp(JobsPlayer jPlayer, Job job, int oldLevel) {
        String line;
        Player player = jPlayer.getPlayer();
        JobProgression prog = jPlayer.getJobProgression(job);
        if (prog == null) {
            return;
        }
        JobsLevelUpEvent levelUpEvent = new JobsLevelUpEvent(jPlayer, job.getName(), prog.getLevel(), Jobs.gettitleManager().getTitle(oldLevel, prog.getJob().getName()), Jobs.gettitleManager().getTitle(prog.getLevel(), prog.getJob().getName()), Jobs.getGCManager().SoundLevelupSound.toUpperCase(), Jobs.getGCManager().SoundLevelupVolume, Jobs.getGCManager().SoundLevelupPitch, Jobs.getGCManager().SoundTitleChangeSound.toUpperCase(), Jobs.getGCManager().SoundTitleChangeVolume, Jobs.getGCManager().SoundTitleChangePitch);
        Bukkit.getServer().getPluginManager().callEvent((Event)levelUpEvent);
        if (levelUpEvent.isCancelled()) {
            return;
        }
        try {
            if (Jobs.getGCManager().SoundLevelupUse) {
                Sound sound = levelUpEvent.getSound();
                if (sound != null && player != null && player.getLocation() != null) {
                    player.getWorld().playSound(player.getLocation(), sound, (float)levelUpEvent.getSoundVolume(), (float)levelUpEvent.getSoundPitch());
                } else {
                    Bukkit.getConsoleSender().sendMessage("[Jobs] Cant find sound by name: " + levelUpEvent.getTitleChangeSound().name() + ". Please update it");
                }
            }
        }
        catch (Exception sound) {
            // empty catch block
        }
        String message = Jobs.getGCManager().isBroadcastingLevelups() ? Jobs.getLanguage().getMessage("message.levelup.broadcast") : Jobs.getLanguage().getMessage("message.levelup.nobroadcast");
        message = message.replace("%jobname%", (Object)((Object)job.getChatColor()) + job.getName() + (Object)((Object)ChatColor.WHITE));
        if (levelUpEvent.getOldTitle() != null) {
            message = message.replace("%titlename%", String.valueOf(levelUpEvent.getOldTitleColor()) + levelUpEvent.getOldTitleName() + (Object)((Object)ChatColor.WHITE));
        }
        message = player != null ? message.replace("%playername%", player.getDisplayName()) : message.replace("%playername%", jPlayer.getUserName());
        message = message.replace("%joblevel%", "" + prog.getLevel());
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            line = stringArray[n2];
            if (Jobs.getGCManager().isBroadcastingLevelups()) {
                if (Jobs.getGCManager().BroadcastingLevelUpLevels.contains(oldLevel + 1) || Jobs.getGCManager().BroadcastingLevelUpLevels.contains(0)) {
                    Bukkit.getServer().broadcastMessage(line);
                }
            } else if (player != null) {
                if (Jobs.getGCManager().LevelChangeActionBar) {
                    Jobs.getActionBar().send((CommandSender)player, line);
                }
                if (Jobs.getGCManager().LevelChangeChat) {
                    player.sendMessage(line);
                }
            }
            ++n2;
        }
        if (levelUpEvent.getNewTitle() != null && !levelUpEvent.getNewTitle().equals(levelUpEvent.getOldTitle())) {
            try {
                if (Jobs.getGCManager().SoundTitleChangeUse) {
                    Sound sound = levelUpEvent.getTitleChangeSound();
                    if (sound != null && player != null && player.getLocation() != null) {
                        player.getWorld().playSound(player.getLocation(), sound, (float)levelUpEvent.getTitleChangeVolume(), (float)levelUpEvent.getTitleChangePitch());
                    } else {
                        Bukkit.getConsoleSender().sendMessage("[Jobs] Cant find sound by name: " + levelUpEvent.getTitleChangeSound().name() + ". Please update it");
                    }
                }
            }
            catch (Exception sound) {
                // empty catch block
            }
            message = Jobs.getGCManager().isBroadcastingSkillups() ? Jobs.getLanguage().getMessage("message.skillup.broadcast") : Jobs.getLanguage().getMessage("message.skillup.nobroadcast");
            message = player != null ? message.replace("%playername%", player.getDisplayName()) : message.replace("%playername%", jPlayer.getUserName());
            message = message.replace("%titlename%", String.valueOf(levelUpEvent.getNewTitleColor()) + levelUpEvent.getNewTitleName() + (Object)((Object)ChatColor.WHITE));
            message = message.replace("%jobname%", (Object)((Object)job.getChatColor()) + job.getName() + (Object)((Object)ChatColor.WHITE));
            stringArray = message.split("\n");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                line = stringArray[n2];
                if (Jobs.getGCManager().isBroadcastingLevelups()) {
                    Bukkit.getServer().broadcastMessage(line);
                } else if (player != null) {
                    if (Jobs.getGCManager().TitleChangeActionBar) {
                        Jobs.getActionBar().send((CommandSender)player, line);
                    }
                    if (Jobs.getGCManager().TitleChangeChat) {
                        player.sendMessage(line);
                    }
                }
                ++n2;
            }
        }
        jPlayer.reloadHonorific();
        Jobs.getPermissionHandler().recalculatePermissions(jPlayer);
        this.performCommandOnLevelUp(jPlayer, prog.getJob(), oldLevel);
        Jobs.getSignUtil().SignUpdate(job.getName());
        Jobs.getSignUtil().SignUpdate("gtoplist");
    }

    public void performCommandOnLevelUp(JobsPlayer jPlayer, Job job, int oldLevel) {
        int newLevel = oldLevel + 1;
        Player player = Bukkit.getServer().getPlayer(jPlayer.getPlayerUUID());
        JobProgression prog = jPlayer.getJobProgression(job);
        if (prog == null) {
            return;
        }
        for (JobCommands command : job.getCommands()) {
            if (newLevel < command.getLevelFrom() || newLevel > command.getLevelUntil()) continue;
            String commandString = command.getCommand();
            commandString = commandString.replace("[player]", player.getName());
            commandString = commandString.replace("[oldlevel]", String.valueOf(oldLevel));
            commandString = commandString.replace("[newlevel]", String.valueOf(newLevel));
            commandString = commandString.replace("[jobname]", job.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)commandString);
        }
    }

    public boolean getJobsLimit(JobsPlayer jPlayer, Short currentCount) {
        Double max = Jobs.getPermissionManager().getMaxPermission(jPlayer, "jobs.max");
        max = max == null ? (double)Jobs.getGCManager().getMaxJobs() : max;
        return max > (double)currentCount.shortValue();
    }

    public BoostMultiplier getBoost(JobsPlayer player, Job job) {
        return this.getBoost(player, job, false);
    }

    public BoostMultiplier getBoost(JobsPlayer player, Job job, boolean force) {
        BoostMultiplier b = new BoostMultiplier();
        CurrencyType[] currencyTypeArray = CurrencyType.values();
        int n = currencyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CurrencyType one = currencyTypeArray[n2];
            b.add(one, this.getBoost(player, job, one, force));
            ++n2;
        }
        return b;
    }

    public double getBoost(JobsPlayer player, Job job, CurrencyType type) {
        return this.getBoost(player, job, type, false);
    }

    public double getBoost(JobsPlayer player, Job job, CurrencyType type, boolean force) {
        return player.getBoost(job.getName(), type, force);
    }

    public void reload() {
        for (JobsPlayer jPlayer : this.players.values()) {
            for (JobProgression progression : jPlayer.getJobProgression()) {
                String jobName = progression.getJob().getName();
                Job job = Jobs.getJob(jobName);
                if (job == null) continue;
                progression.setJob(job);
            }
            if (!jPlayer.isOnline()) continue;
            jPlayer.reloadHonorific();
            jPlayer.reloadLimits();
            Jobs.getPermissionHandler().recalculatePermissions(jPlayer);
        }
    }

    public BoostMultiplier getItemBoost(Player player, Job prog) {
        BoostMultiplier data = new BoostMultiplier();
        if (player == null) {
            return data;
        }
        if (prog == null) {
            return data;
        }
        ItemStack iih = Jobs.getNms().getItemInMainHand(player);
        data = Jobs.getPlayerManager().getItemBoost(prog, iih);
        ItemStack[] itemStackArray = player.getInventory().getArmorContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack OneArmor = itemStackArray[n2];
            if (OneArmor != null && OneArmor.getType() != Material.AIR) {
                BoostMultiplier armorboost = Jobs.getPlayerManager().getItemBoost(prog, OneArmor);
                data.add(armorboost);
            }
            ++n2;
        }
        return data;
    }

    public BoostMultiplier getItemBoost(Job prog, ItemStack item) {
        BoostMultiplier bonus2 = new BoostMultiplier();
        if (prog.getItems().isEmpty()) {
            return bonus2;
        }
        if (item == null) {
            return bonus2;
        }
        ItemMeta meta = item.getItemMeta();
        String name = null;
        List lore = new ArrayList();
        if (item.hasItemMeta()) {
            if (meta.hasDisplayName()) {
                name = meta.getDisplayName();
            }
            if (meta.hasLore()) {
                lore = meta.getLore();
            }
        }
        Map enchants = item.getEnchantments();
        block0: for (JobItems oneItem : prog.getItems()) {
            if (oneItem.getId() != item.getTypeId() || oneItem.getName() != null && name != null && !org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)oneItem.getName()).equalsIgnoreCase(name)) continue;
            for (String string : oneItem.getLore()) {
                if (lore.size() == 0 || !lore.contains(string)) continue block0;
            }
            for (Map.Entry entry : enchants.entrySet()) {
                if (!oneItem.getEnchants().containsKey(entry.getKey()) || oneItem.getEnchants().get(entry.getKey()) < (Integer)entry.getValue()) continue block0;
            }
            return oneItem.getBoost();
        }
        return bonus2;
    }

    public Boost getFinalBonus(JobsPlayer player, Job prog, boolean force, boolean getall) {
        return this.getFinalBonus(player, prog, null, null, force, getall);
    }

    public Boost getFinalBonus(JobsPlayer player, Job prog, boolean force) {
        return this.getFinalBonus(player, prog, null, null, force, false);
    }

    public Boost getFinalBonus(JobsPlayer player, Job prog) {
        return this.getFinalBonus(player, prog, null, null, false, false);
    }

    public Boost getFinalBonus(JobsPlayer player, Job prog, Entity ent, LivingEntity victim) {
        return this.getFinalBonus(player, prog, ent, victim, false, false);
    }

    public Boost getFinalBonus(JobsPlayer player, Job prog, Entity ent, LivingEntity victim, boolean force, boolean getall) {
        Double amount;
        Double amount2;
        Tameable t;
        Boost boost = new Boost();
        if (player == null || prog == null) {
            return boost;
        }
        if (Jobs.getMcMMOlistener().mcMMOPresent) {
            boost.add(BoostOf.McMMO, new BoostMultiplier().add(Jobs.getMcMMOlistener().getMultiplier(player.getPlayer())));
        }
        if (ent != null && ent instanceof Tameable && (t = (Tameable)ent).isTamed() && t.getOwner() instanceof Player && (amount2 = Jobs.getPermissionManager().getMaxPermission(player, "jobs.petpay")) != null) {
            boost.add(BoostOf.PetPay, new BoostMultiplier().add(amount2));
        }
        if (victim != null && victim.hasMetadata(this.getMobSpawnerMetadata()) && (amount = Jobs.getPermissionManager().getMaxPermission(player, "jobs.nearspawner")) != null) {
            boost.add(BoostOf.NearSpawner, new BoostMultiplier().add(amount));
        }
        if (getall) {
            amount = Jobs.getPermissionManager().getMaxPermission(player, "jobs.petpay", force);
            if (amount != null) {
                boost.add(BoostOf.PetPay, new BoostMultiplier().add(amount));
            }
            if ((amount = Jobs.getPermissionManager().getMaxPermission(player, "jobs.nearspawner", force)) != null) {
                boost.add(BoostOf.NearSpawner, new BoostMultiplier().add(amount));
            }
        }
        boost.add(BoostOf.Permission, Jobs.getPlayerManager().getBoost(player, prog, force));
        boost.add(BoostOf.Global, prog.getBoost());
        if (Jobs.getGCManager().useDynamicPayment) {
            boost.add(BoostOf.Dynamic, new BoostMultiplier().add(prog.getBonus()));
        }
        boost.add(BoostOf.Item, Jobs.getPlayerManager().getItemBoost(player.getPlayer(), prog));
        boost.add(BoostOf.Area, new BoostMultiplier().add(Jobs.getRestrictedAreaManager().getRestrictedMultiplier(player.getPlayer())));
        return boost;
    }

    public void AutoJoinJobs(final Player player) {
        if (player == null) {
            return;
        }
        if (player.isOp()) {
            return;
        }
        if (!Jobs.getGCManager().AutoJobJoinUse) {
            return;
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
                if (jPlayer == null) {
                    return;
                }
                if (player.hasPermission("jobs.*")) {
                    return;
                }
                int confMaxJobs = Jobs.getGCManager().getMaxJobs();
                for (Job one : Jobs.getJobs()) {
                    if (one.getMaxSlots() != null && Jobs.getUsedSlots(one) >= one.getMaxSlots()) continue;
                    short PlayerMaxJobs = (short)jPlayer.getJobProgression().size();
                    if (confMaxJobs > 0 && PlayerMaxJobs >= confMaxJobs && !Jobs.getPlayerManager().getJobsLimit(jPlayer, PlayerMaxJobs)) break;
                    if (jPlayer.isInJob(one) || !player.hasPermission("jobs.autojoin." + one.getName().toLowerCase())) continue;
                    Jobs.getPlayerManager().joinJob(jPlayer, one);
                }
            }
        }, (long)Jobs.getGCManager().AutoJobJoinDelay * 20L);
    }

    public String getMobSpawnerMetadata() {
        return "jobsMobSpawner";
    }

    public static enum BoostOf {
        McMMO,
        PetPay,
        NearSpawner,
        Permission,
        Global,
        Dynamic,
        Item,
        Area;

    }
}

