/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.config.Config;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.LoggingUtil;
import de.diddiz.util.MaterialName;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Location;
import org.bukkit.Material;

public class BlockChange
implements LookupCacheElement {
    public final long id;
    public final long date;
    public final Location loc;
    public final Actor actor;
    public final String playerName;
    public final int replaced;
    public final int type;
    public final byte data;
    public final String signtext;
    public final ChestAccess ca;

    public BlockChange(long date, Location loc, Actor actor, int replaced, int type, byte data, String signtext, ChestAccess ca) {
        this.id = 0L;
        this.date = date;
        this.loc = loc;
        this.actor = actor;
        this.replaced = replaced;
        this.type = type;
        this.data = data;
        this.signtext = LoggingUtil.checkText(signtext);
        this.ca = ca;
        this.playerName = actor == null ? null : actor.getName();
    }

    public BlockChange(ResultSet rs, QueryParams p) throws SQLException {
        this.id = p.needId ? (long)rs.getInt("id") : 0L;
        this.date = p.needDate ? rs.getTimestamp("date").getTime() : 0L;
        this.loc = p.needCoords ? new Location(p.world, (double)rs.getInt("x"), (double)rs.getInt("y"), (double)rs.getInt("z")) : null;
        this.actor = p.needPlayer ? new Actor(rs) : null;
        this.playerName = p.needPlayer ? rs.getString("playername") : null;
        this.replaced = p.needType ? rs.getInt("replaced") : 0;
        this.type = p.needType ? rs.getInt("type") : 0;
        this.data = p.needData ? rs.getByte("data") : (byte)0;
        this.signtext = p.needSignText ? rs.getString("signtext") : null;
        this.ca = p.needChestAccess && rs.getShort("itemtype") != 0 && rs.getShort("itemamount") != 0 ? new ChestAccess(rs.getShort("itemtype"), rs.getShort("itemamount"), rs.getShort("itemdata")) : null;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.date > 0L) {
            msg.append(Config.formatter.format(this.date)).append(" ");
        }
        if (this.actor != null) {
            msg.append(this.actor.getName()).append(" ");
        }
        if (this.signtext != null) {
            String action;
            String string = action = this.type == 0 ? "destroyed " : "created ";
            if (!this.signtext.contains("\u0000")) {
                msg.append(action).append(this.signtext);
            } else {
                msg.append(action).append(MaterialName.materialName(this.type != 0 ? this.type : this.replaced)).append(" [").append(this.signtext.replace("\u0000", "] [")).append("]");
            }
        } else if (this.type == this.replaced) {
            if (this.type == 0) {
                msg.append("did an unspecified action");
            } else if (this.ca != null) {
                if (this.ca.itemType == 0 || this.ca.itemAmount == 0) {
                    msg.append("looked inside ").append(MaterialName.materialName(this.type));
                } else if (this.ca.itemAmount < 0) {
                    msg.append("took ").append(-this.ca.itemAmount).append("x ").append(MaterialName.materialName(this.ca.itemType, this.ca.itemData)).append(" from ").append(MaterialName.materialName(this.type));
                } else {
                    msg.append("put ").append(this.ca.itemAmount).append("x ").append(MaterialName.materialName(this.ca.itemType, this.ca.itemData)).append(" into ").append(MaterialName.materialName(this.type));
                }
            } else if (BukkitUtils.getContainerBlocks().contains(Material.getMaterial((int)this.type))) {
                msg.append("opened ").append(MaterialName.materialName(this.type));
            } else if (this.type == 64 || this.type == 71) {
                msg.append("moved ").append(MaterialName.materialName(this.type));
            } else if (this.type == 96) {
                msg.append(this.data < 8 || this.data > 11 ? "opened" : "closed").append(" ").append(MaterialName.materialName(this.type));
            } else if (this.type == 107) {
                msg.append(this.data > 3 ? "opened" : "closed").append(" ").append(MaterialName.materialName(this.type));
            } else if (this.type == 69) {
                msg.append("switched ").append(MaterialName.materialName(this.type));
            } else if (this.type == 77 || this.type == 143) {
                msg.append("pressed ").append(MaterialName.materialName(this.type));
            } else if (this.type == 92) {
                msg.append("ate a piece of ").append(MaterialName.materialName(this.type));
            } else if (this.type == 25 || this.type == 93 || this.type == 94 || this.type == 149 || this.type == 150) {
                msg.append("changed ").append(MaterialName.materialName(this.type));
            } else if (this.type == 70 || this.type == 72 || this.type == 147 || this.type == 148) {
                msg.append("stepped on ").append(MaterialName.materialName(this.type));
            } else if (this.type == 132) {
                msg.append("ran into ").append(MaterialName.materialName(this.type));
            }
        } else if (this.type == 0) {
            msg.append("destroyed ").append(MaterialName.materialName(this.replaced, this.data));
        } else if (this.replaced == 0) {
            msg.append("created ").append(MaterialName.materialName(this.type, this.data));
        } else {
            msg.append("replaced ").append(MaterialName.materialName(this.replaced, (short)0)).append(" with ").append(MaterialName.materialName(this.type, this.data));
        }
        if (this.loc != null) {
            msg.append(" at ").append(this.loc.getBlockX()).append(":").append(this.loc.getBlockY()).append(":").append(this.loc.getBlockZ());
        }
        return msg.toString();
    }

    @Override
    public Location getLocation() {
        return this.loc;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }
}

