/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener;

import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.BlockInfo;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PlayerListener
extends Queue
implements Listener {
    public static ConcurrentHashMap<String, Object[]> lastInspectorEvent = new ConcurrentHashMap();

    private void onInventoryInteract(HumanEntity entity, Inventory inventory) {
        World world = entity.getWorld();
        if (Functions.checkConfig(world, "item-transactions") == 1) {
            InventoryHolder i;
            Player player = (Player)entity;
            if (inventory != null && (i = inventory.getHolder()) != null) {
                BlockState state;
                Material type = Material.CHEST;
                Location l = null;
                if (i instanceof BlockState) {
                    state = (BlockState)i;
                    type = state.getType();
                    if (BlockInfo.containers.contains(type)) {
                        l = state.getLocation();
                    }
                } else if (i instanceof DoubleChest) {
                    state = (DoubleChest)i;
                    l = state.getLocation();
                }
                if (l != null) {
                    int x = l.getBlockX();
                    int y = l.getBlockY();
                    int z = l.getBlockZ();
                    for (HumanEntity viewer : inventory.getViewers()) {
                        List<ItemStack[]> list;
                        String logging_chest_id;
                        if (viewer.getName().equals(player.getName()) || Config.old_container.get(logging_chest_id = viewer.getName().toLowerCase() + "." + x + "." + y + "." + z) == null) continue;
                        int size_old = Config.old_container.get(logging_chest_id).size();
                        if (Config.force_containers.get(logging_chest_id) == null) {
                            Config.force_containers.put(logging_chest_id, new ArrayList());
                        }
                        if ((list = Config.force_containers.get(logging_chest_id)).size() >= size_old) continue;
                        list.add(Functions.get_container_state(inventory.getContents()));
                        Config.force_containers.put(logging_chest_id, list);
                    }
                    int chest_id = 0;
                    String logging_chest_id = player.getName().toLowerCase() + "." + x + "." + y + "." + z;
                    if (Config.logging_chest.get(logging_chest_id) != null) {
                        if (Config.force_containers.get(logging_chest_id) != null) {
                            int force_size = Config.force_containers.get(logging_chest_id).size();
                            List<ItemStack[]> list = Config.old_container.get(logging_chest_id);
                            if (list.size() > force_size) {
                                list.set(force_size, Functions.get_container_state(inventory.getContents()));
                            } else {
                                list.add(Functions.get_container_state(inventory.getContents()));
                            }
                            Config.old_container.put(logging_chest_id, list);
                        }
                        chest_id = Config.logging_chest.get(logging_chest_id) + 1;
                    } else {
                        ArrayList<ItemStack[]> list = new ArrayList<ItemStack[]>();
                        list.add(Functions.get_container_state(inventory.getContents()));
                        Config.old_container.put(logging_chest_id, list);
                    }
                    Config.logging_chest.put(logging_chest_id, chest_id);
                    Queue.queueContainerTransaction(player.getName(), l.getBlock().getState(), type, inventory, chest_id);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onInventoryClick(InventoryClickEvent event) {
        this.onInventoryInteract(event.getWhoClicked(), event.getInventory());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onInventoryDragEvent(InventoryDragEvent event) {
        this.onInventoryInteract(event.getWhoClicked(), event.getInventory());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onPlayerArmorStandManipulateEvent(PlayerArmorStandManipulateEvent event) {
        Player player = event.getPlayer();
        final ArmorStand armorStand = event.getRightClicked();
        EntityEquipment equipment = armorStand.getEquipment();
        ItemStack[] contents = equipment.getArmorContents();
        ItemStack item = event.getArmorStandItem();
        ItemStack playerItem = event.getPlayerItem();
        if (Functions.checkConfig(player.getWorld(), "item-transactions") != 1) {
            return;
        }
        if (Config.inspecting.get(player.getName()) != null && Config.inspecting.get(player.getName()).booleanValue()) {
            final Player player2 = player;
            if (BlockInfo.containers.contains(Material.ARMOR_STAND)) {
                class BasicThread
                implements Runnable {
                    BasicThread() {
                    }

                    @Override
                    public void run() {
                        try {
                            if (Config.converter_running) {
                                player2.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                return;
                            }
                            if (Config.purge_running) {
                                player2.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                return;
                            }
                            Connection connection = Database.getConnection(false);
                            if (connection != null) {
                                Location l;
                                Statement statement = connection.createStatement();
                                String blockdata = Lookup.chest_transactions(statement, l = armorStand.getLocation(), player2.getName(), 1, 7);
                                if (blockdata.contains("\n")) {
                                    for (String b : blockdata.split("\n")) {
                                        player2.sendMessage(b);
                                    }
                                } else {
                                    player2.sendMessage(blockdata);
                                }
                                statement.close();
                                connection.close();
                            } else {
                                player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                BasicThread runnable = new BasicThread();
                Thread thread = new Thread(runnable);
                thread.start();
            }
            event.setCancelled(true);
        }
        if (event.isCancelled()) {
            return;
        }
        if (item == null && playerItem == null) {
            return;
        }
        Material type = Material.ARMOR_STAND;
        Location l = armorStand.getLocation();
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        int chest_id = 0;
        String logging_chest_id = player.getName().toLowerCase() + "." + x + "." + y + "." + z;
        if (Config.logging_chest.get(logging_chest_id) != null) {
            if (Config.force_containers.get(logging_chest_id) != null) {
                int force_size = Config.force_containers.get(logging_chest_id).size();
                List<ItemStack[]> list = Config.old_container.get(logging_chest_id);
                if (list.size() > force_size) {
                    list.set(force_size, Functions.get_container_state(contents));
                } else {
                    list.add(Functions.get_container_state(contents));
                }
                Config.old_container.put(logging_chest_id, list);
            }
            chest_id = Config.logging_chest.get(logging_chest_id) + 1;
        } else {
            ArrayList<ItemStack[]> list = new ArrayList<ItemStack[]>();
            list.add(Functions.get_container_state(contents));
            Config.old_container.put(logging_chest_id, list);
        }
        Config.logging_chest.put(logging_chest_id, chest_id);
        Queue.queueContainerTransaction(player.getName(), l.getBlock().getState(), type, equipment, chest_id);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        String player = event.getPlayer().getName();
        Block block = event.getBlockClicked().getRelative(event.getBlockFace());
        World world = block.getWorld();
        boolean inspect = false;
        if (Config.inspecting.get(player) != null && Config.inspecting.get(player).booleanValue()) {
            inspect = true;
            event.setCancelled(true);
        }
        if (!event.isCancelled() && Functions.checkConfig(world, "buckets") == 1 && !inspect) {
            int wid = Functions.getWorldId(block.getWorld().getName());
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            Material type = Material.WATER;
            if (event.getBucket().equals((Object)Material.LAVA_BUCKET)) {
                type = Material.LAVA;
            }
            Config.lookup_cache.put("" + block.getX() + "." + block.getY() + "." + block.getZ() + "." + wid + "", new Object[]{unixtimestamp, player, type});
            Queue.queueBlockPlace(player, block.getState(), type, 0);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onPlayerBucketFill(PlayerBucketFillEvent event) {
        String player = event.getPlayer().getName();
        Block block = event.getBlockClicked().getRelative(event.getBlockFace());
        World world = block.getWorld();
        Material type = block.getType();
        byte data = Functions.getData(block);
        boolean inspect = false;
        if (Config.inspecting.get(player) != null && Config.inspecting.get(player).booleanValue()) {
            inspect = true;
            event.setCancelled(true);
        }
        if (!event.isCancelled() && Functions.checkConfig(world, "buckets") == 1 && !inspect) {
            Queue.queueBlockBreak(player, block.getState(), type, data);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!event.getMessage().startsWith("/") && Functions.checkConfig(player.getWorld(), "player-messages") == 1) {
            int time = (int)(System.currentTimeMillis() / 1000L);
            Queue.queuePlayerChat(player, event.getMessage(), time);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (Functions.checkConfig(player.getWorld(), "player-commands") == 1) {
            int time = (int)(System.currentTimeMillis() / 1000L);
            Queue.queuePlayerCommand(player, event.getMessage(), time);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    protected void onPlayerInteract(PlayerInteractEvent event) {
        Material type;
        Block block;
        Player player = event.getPlayer();
        World world = player.getWorld();
        boolean inspecting_or_something = false;
        List<Material> interact_blocks = Arrays.asList(Material.SPRUCE_DOOR, Material.BIRCH_DOOR, Material.JUNGLE_DOOR, Material.ACACIA_DOOR, Material.DARK_OAK_DOOR, Material.SPRUCE_FENCE_GATE, Material.BIRCH_FENCE_GATE, Material.JUNGLE_FENCE_GATE, Material.DARK_OAK_FENCE_GATE, Material.ACACIA_FENCE_GATE, Material.DISPENSER, Material.NOTE_BLOCK, Material.CHEST, Material.FURNACE, Material.BURNING_FURNACE, Material.WOODEN_DOOR, Material.LEVER, Material.STONE_BUTTON, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.TRAP_DOOR, Material.FENCE_GATE, Material.BREWING_STAND, Material.WOOD_BUTTON, Material.ANVIL, Material.TRAPPED_CHEST, Material.REDSTONE_COMPARATOR_OFF, Material.REDSTONE_COMPARATOR_ON, Material.HOPPER, Material.DROPPER, Material.BLACK_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.SILVER_SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX);
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            if (Config.inspecting.get(player.getName()) != null && Config.inspecting.get(player.getName()).booleanValue()) {
                Block check_block = event.getClickedBlock();
                if (check_block.getType().equals((Object)Material.DOUBLE_PLANT) && Functions.getData(check_block) >= 8) {
                    check_block = world.getBlockAt(check_block.getX(), check_block.getY() - 1, check_block.getZ());
                }
                final Block block_final = check_block;
                final Player player_final = player;
                class BasicThread
                implements Runnable {
                    BasicThread() {
                    }

                    @Override
                    public void run() {
                        try {
                            if (Config.converter_running) {
                                player_final.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                return;
                            }
                            if (Config.purge_running) {
                                player_final.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                return;
                            }
                            Connection connection = Database.getConnection(false);
                            if (connection != null) {
                                Statement statement = connection.createStatement();
                                String result_data = Lookup.block_lookup(statement, block_final, player_final.getName(), 0, 1, 7);
                                if (result_data.contains("\n")) {
                                    for (String b : result_data.split("\n")) {
                                        player_final.sendMessage(b);
                                    }
                                } else if (result_data.length() > 0) {
                                    player_final.sendMessage(result_data);
                                }
                                statement.close();
                                connection.close();
                            } else {
                                player_final.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                BasicThread runnable = new BasicThread();
                Thread thread = new Thread(runnable);
                thread.start();
                event.setCancelled(true);
            }
        } else if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && Config.inspecting.get(player.getName()) != null && Config.inspecting.get(player.getName()).booleanValue()) {
            List<Material> safe_blocks = Arrays.asList(Material.WOODEN_DOOR, Material.LEVER, Material.STONE_BUTTON, Material.TRAP_DOOR, Material.FENCE_GATE, Material.SPRUCE_DOOR, Material.BIRCH_DOOR, Material.JUNGLE_DOOR, Material.ACACIA_DOOR, Material.DARK_OAK_DOOR, Material.SPRUCE_FENCE_GATE, Material.BIRCH_FENCE_GATE, Material.JUNGLE_FENCE_GATE, Material.DARK_OAK_FENCE_GATE, Material.ACACIA_FENCE_GATE);
            Block block2 = event.getClickedBlock();
            if (block2 != null) {
                final Material type2 = block2.getType();
                if (interact_blocks.contains(type2)) {
                    final Block cblock = event.getClickedBlock();
                    final Player player2 = player;
                    if (BlockInfo.containers.contains(type2) && Functions.checkConfig(world, "item-transactions") == 1) {
                        class BasicThread
                        implements Runnable {
                            BasicThread() {
                            }

                            @Override
                            public void run() {
                                try {
                                    if (Config.converter_running) {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                        return;
                                    }
                                    if (Config.purge_running) {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                        return;
                                    }
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        String blockdata;
                                        Statement statement = connection.createStatement();
                                        Location l = null;
                                        if (type2.equals((Object)Material.CHEST) || type2.equals((Object)Material.TRAPPED_CHEST)) {
                                            Chest chest = (Chest)cblock.getState();
                                            InventoryHolder i = chest.getInventory().getHolder();
                                            if (i instanceof DoubleChest) {
                                                DoubleChest c = (DoubleChest)i;
                                                l = c.getLocation();
                                            } else {
                                                l = chest.getLocation();
                                            }
                                        }
                                        if (l == null) {
                                            l = cblock.getLocation();
                                        }
                                        if ((blockdata = Lookup.chest_transactions(statement, l, player2.getName(), 1, 7)).contains("\n")) {
                                            for (String b : blockdata.split("\n")) {
                                                player2.sendMessage(b);
                                            }
                                        } else {
                                            player2.sendMessage(blockdata);
                                        }
                                        statement.close();
                                        connection.close();
                                    } else {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        BasicThread runnable = new BasicThread();
                        Thread thread = new Thread(runnable);
                        thread.start();
                        event.setCancelled(true);
                    } else {
                        Block interact_block = cblock;
                        if (type2.equals((Object)Material.WOODEN_DOOR) || type2.equals((Object)Material.SPRUCE_DOOR) || type2.equals((Object)Material.BIRCH_DOOR) || type2.equals((Object)Material.JUNGLE_DOOR) || type2.equals((Object)Material.ACACIA_DOOR) || type2.equals((Object)Material.DARK_OAK_DOOR)) {
                            int y = interact_block.getY() - 1;
                            Block block_under = interact_block.getWorld().getBlockAt(interact_block.getX(), y, interact_block.getZ());
                            if (block_under.getType().equals((Object)type2)) {
                                interact_block = block_under;
                            }
                        }
                        final Block final_interact_block = interact_block;
                        class BasicThread
                        implements Runnable {
                            BasicThread() {
                            }

                            @Override
                            public void run() {
                                try {
                                    if (Config.converter_running) {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                        return;
                                    }
                                    if (Config.purge_running) {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                        return;
                                    }
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        Statement statement = connection.createStatement();
                                        String blockdata = Lookup.interaction_lookup(statement, final_interact_block, player2.getName(), 0, 1, 7);
                                        if (blockdata.contains("\n")) {
                                            for (String b : blockdata.split("\n")) {
                                                player2.sendMessage(b);
                                            }
                                        } else {
                                            player2.sendMessage(blockdata);
                                        }
                                        statement.close();
                                        connection.close();
                                    } else {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        BasicThread runnable = new BasicThread();
                        Thread thread = new Thread(runnable);
                        thread.start();
                        if (!safe_blocks.contains(type2)) {
                            event.setCancelled(true);
                        }
                    }
                    inspecting_or_something = true;
                } else {
                    boolean performLookup = true;
                    EquipmentSlot eventHand = event.getHand();
                    String uuid = event.getPlayer().getUniqueId().toString();
                    long systemTime = System.currentTimeMillis();
                    if (lastInspectorEvent.get(uuid) != null) {
                        Object[] lastEvent = lastInspectorEvent.get(uuid);
                        long lastTime = (Long)lastEvent[0];
                        EquipmentSlot lastHand = (EquipmentSlot)lastEvent[1];
                        long timeSince = systemTime - lastTime;
                        if (timeSince < 50L && !eventHand.equals((Object)lastHand)) {
                            performLookup = false;
                        }
                    }
                    if (performLookup) {
                        final Player player2 = player;
                        final Block fblock = event.getClickedBlock().getRelative(event.getBlockFace());
                        class BasicThread
                        implements Runnable {
                            BasicThread() {
                            }

                            @Override
                            public void run() {
                                try {
                                    if (Config.converter_running) {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
                                        return;
                                    }
                                    if (Config.purge_running) {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
                                        return;
                                    }
                                    Connection connection = Database.getConnection(false);
                                    if (connection != null) {
                                        Statement statement = connection.createStatement();
                                        if (fblock.getType().equals((Object)Material.AIR)) {
                                            String blockdata = Lookup.block_lookup(statement, fblock, player2.getName(), 0, 1, 7);
                                            if (blockdata.contains("\n")) {
                                                for (String b : blockdata.split("\n")) {
                                                    player2.sendMessage(b);
                                                }
                                            } else if (blockdata.length() > 0) {
                                                player2.sendMessage(blockdata);
                                            }
                                        } else {
                                            String blockdata = Lookup.block_lookup(statement, fblock, player2.getName(), 0, 1, 7);
                                            if (blockdata.contains("\n")) {
                                                for (String b : blockdata.split("\n")) {
                                                    player2.sendMessage(b);
                                                }
                                            } else if (blockdata.length() > 0) {
                                                player2.sendMessage(blockdata);
                                            }
                                        }
                                        statement.close();
                                        connection.close();
                                    } else {
                                        player2.sendMessage("\u00a73CoreProtect \u00a7f- Database busy. Please try again later.");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        BasicThread runnable = new BasicThread();
                        Thread thread = new Thread(runnable);
                        thread.start();
                        Functions.updateInventory(event.getPlayer());
                        lastInspectorEvent.put(uuid, new Object[]{systemTime, eventHand});
                    }
                    event.setCancelled(true);
                }
            }
        }
        if ((block = event.getClickedBlock()) != null && interact_blocks.contains(type = block.getType())) {
            boolean valid_click = true;
            if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                valid_click = false;
            }
            if (!inspecting_or_something && valid_click && event.getHand().equals((Object)EquipmentSlot.HAND) && !event.isCancelled() && Functions.checkConfig(world, "player-interactions") == 1) {
                Block interact_block = event.getClickedBlock();
                if (type.equals((Object)Material.WOODEN_DOOR) || type.equals((Object)Material.SPRUCE_DOOR) || type.equals((Object)Material.BIRCH_DOOR) || type.equals((Object)Material.JUNGLE_DOOR) || type.equals((Object)Material.ACACIA_DOOR) || type.equals((Object)Material.DARK_OAK_DOOR)) {
                    int y = interact_block.getY() - 1;
                    Block block_under = interact_block.getWorld().getBlockAt(interact_block.getX(), y, interact_block.getZ());
                    if (block_under.getType().equals((Object)type)) {
                        interact_block = block_under;
                    }
                }
                Queue.queuePlayerInteraction(player.getName(), interact_block.getState());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onPlayerInteract_Monitor(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            Block relative_block;
            World world = event.getClickedBlock().getWorld();
            if (!event.isCancelled() && Functions.checkConfig(world, "block-break") == 1 && (relative_block = event.getClickedBlock().getRelative(event.getBlockFace())).getType().equals((Object)Material.FIRE)) {
                Player player = event.getPlayer();
                Material type = relative_block.getType();
                byte data = Functions.getData(relative_block);
                Queue.queueBlockBreak(player.getName(), relative_block.getState(), type, data);
            }
        } else if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            World world = event.getClickedBlock().getWorld();
            if (!event.isCancelled() && Functions.checkConfig(world, "block-place") == 1) {
                Player player = event.getPlayer();
                List<Material> entityBlockTypes = Arrays.asList(Material.ARMOR_STAND, Material.END_CRYSTAL);
                Material handType = null;
                ItemStack mainHand = player.getInventory().getItemInMainHand();
                ItemStack offHand = player.getInventory().getItemInOffHand();
                if (event.getHand().equals((Object)EquipmentSlot.HAND) && mainHand != null && entityBlockTypes.contains(mainHand.getType())) {
                    handType = mainHand.getType();
                } else if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND) && offHand != null && entityBlockTypes.contains(offHand.getType())) {
                    handType = offHand.getType();
                } else {
                    return;
                }
                if (handType.equals((Object)Material.END_CRYSTAL)) {
                    Location crystalLocation = event.getClickedBlock().getLocation();
                    if (crystalLocation.getBlock().getType().equals((Object)Material.OBSIDIAN) || crystalLocation.getBlock().getType().equals((Object)Material.BEDROCK)) {
                        crystalLocation.setY(crystalLocation.getY() + 1.0);
                        boolean exists = false;
                        for (Entity entity : crystalLocation.getChunk().getEntities()) {
                            if (!(entity instanceof EnderCrystal) || entity.getLocation().getBlockX() != crystalLocation.getBlockX() || entity.getLocation().getBlockY() != crystalLocation.getBlockY() || entity.getLocation().getBlockZ() != crystalLocation.getBlockZ()) continue;
                            exists = true;
                            break;
                        }
                        if (!exists) {
                            final Player playerFinal = player;
                            final Location locationFinal = crystalLocation;
                            CoreProtect.getInstance().getServer().getScheduler().runTask((Plugin)CoreProtect.getInstance(), new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        boolean exists = false;
                                        int showingBottom = 0;
                                        for (Entity entity : locationFinal.getChunk().getEntities()) {
                                            if (!(entity instanceof EnderCrystal) || entity.getLocation().getBlockX() != locationFinal.getBlockX() || entity.getLocation().getBlockY() != locationFinal.getBlockY() || entity.getLocation().getBlockZ() != locationFinal.getBlockZ()) continue;
                                            EnderCrystal enderCrystal = (EnderCrystal)entity;
                                            showingBottom = enderCrystal.isShowingBottom() ? 1 : 0;
                                            exists = true;
                                            break;
                                        }
                                        if (exists) {
                                            PlayerListener.queueBlockPlace(playerFinal.getName(), locationFinal.getBlock().getState(), locationFinal.getBlock(), locationFinal.getBlock().getState(), Material.END_CRYSTAL, showingBottom, 1);
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                } else {
                    Block relative_block = event.getClickedBlock().getRelative(event.getBlockFace());
                    Location location_1 = relative_block.getLocation();
                    Location location_2 = event.getClickedBlock().getLocation();
                    String key_1 = world.getName() + "-" + location_1.getBlockX() + "-" + location_1.getBlockY() + "-" + location_1.getBlockZ();
                    String key_2 = world.getName() + "-" + location_2.getBlockX() + "-" + location_2.getBlockY() + "-" + location_2.getBlockZ();
                    Object[] keys = new Object[]{key_1, key_2, handType};
                    Config.entity_block_mapper.put(player.getUniqueId(), keys);
                }
            }
        } else if (event.getAction().equals((Object)Action.PHYSICAL)) {
            Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if (!block.getType().equals((Object)Material.SOIL)) {
                return;
            }
            World world = block.getWorld();
            if (!event.isCancelled() && Functions.checkConfig(world, "block-break") == 1) {
                Player player = event.getPlayer();
                Block block_above = world.getBlockAt(block.getX(), block.getY() + 1, block.getZ());
                Material type = block_above.getType();
                if (!type.equals((Object)Material.AIR)) {
                    byte data = Functions.getData(block_above);
                    Queue.queueBlockBreak(player.getName(), block_above.getState(), type, data);
                }
                Queue.queueBlockPlace(player.getName(), block, block.getState(), Material.DIRT, (int)Functions.getData(block));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        ItemFrame frame;
        if (event instanceof PlayerArmorStandManipulateEvent) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        World world = entity.getWorld();
        if (entity instanceof ItemFrame && !event.isCancelled() && Functions.checkConfig(world, "block-place") == 1 && (frame = (ItemFrame)entity).getItem().getType().equals((Object)Material.AIR) && !player.getInventory().getItemInMainHand().getType().equals((Object)Material.AIR)) {
            Material t = Material.ITEM_FRAME;
            int hand = Functions.block_id(player.getInventory().getItemInMainHand().getType());
            int d = 0;
            if (frame.getItem() != null) {
                d = Functions.block_id(frame.getItem().getType());
            }
            String playername = player.getName();
            Block block = frame.getLocation().getBlock();
            Queue.queueBlockBreak(playername, block.getState(), t, d);
            Queue.queueBlockPlace(playername, block.getState(), t, hand);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        int time = (int)(System.currentTimeMillis() / 1000L);
        Queue.queuePlayerLogin(player, time, Functions.checkConfig(player.getWorld(), "player-sessions"), Functions.checkConfig(player.getWorld(), "username-changes"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (Functions.checkConfig(player.getWorld(), "player-sessions") == 1) {
            int time = (int)(System.currentTimeMillis() / 1000L);
            Queue.queuePlayerQuit(player, time);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onSignChange(SignChangeEvent event) {
        String player = event.getPlayer().getName();
        Block block = event.getBlock();
        String line1 = event.getLine(0);
        String line2 = event.getLine(1);
        String line3 = event.getLine(2);
        String line4 = event.getLine(3);
        if (!event.isCancelled() && Functions.checkConfig(block.getWorld(), "sign-text") == 1) {
            Queue.queueSignText(player, block.getState(), line1, line2, line3, line4, 0);
        }
    }
}

