/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.Functions;
import net.coreprotect.consumer.Queue;
import net.coreprotect.database.Database;
import net.coreprotect.database.Lookup;
import net.coreprotect.model.BlockInfo;
import net.coreprotect.model.Config;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.inventory.ItemStack;

public class BlockListener
extends Queue
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockBreak(BlockBreakEvent event) {
        if (!event.isCancelled()) {
            String player = event.getPlayer().getName();
            Block bl = event.getBlock();
            int x = bl.getX();
            int y = bl.getY();
            int z = bl.getZ();
            World world = bl.getWorld();
            Location l1 = new Location(world, (double)(x + 1), (double)y, (double)z);
            Location l2 = new Location(world, (double)(x - 1), (double)y, (double)z);
            Location l3 = new Location(world, (double)x, (double)y, (double)(z + 1));
            Location l4 = new Location(world, (double)x, (double)y, (double)(z - 1));
            Location l5 = new Location(world, (double)x, (double)(y + 1), (double)z);
            Location l6 = new Location(world, (double)x, (double)(y - 1), (double)z);
            byte l = 1;
            byte m = 7;
            if (Functions.checkConfig(world, "natural-break") == 0) {
                l = 6;
            }
            if (Functions.checkConfig(world, "block-break") == 0) {
                m = 6;
            }
            Block block = bl;
            Material type = bl.getType();
            byte data = Functions.getData(bl);
            while (l < m) {
                Location lc = l1;
                if (l == 2) {
                    lc = l2;
                }
                if (l == 3) {
                    lc = l3;
                }
                if (l == 4) {
                    lc = l4;
                }
                if (l == 5) {
                    lc = l5;
                }
                Block b = block;
                boolean check_down = false;
                Material bt = type;
                byte bd = data;
                boolean log = true;
                if (l < 6) {
                    byte check_data;
                    if (l == 4 && (type.equals((Object)Material.WOODEN_DOOR) || type.equals((Object)Material.SPRUCE_DOOR) || type.equals((Object)Material.BIRCH_DOOR) || type.equals((Object)Material.JUNGLE_DOOR) || type.equals((Object)Material.ACACIA_DOOR) || type.equals((Object)Material.DARK_OAK_DOOR) || type.equals((Object)Material.IRON_DOOR_BLOCK))) {
                        lc = l6;
                        check_down = true;
                    }
                    Block block_t = world.getBlockAt(lc);
                    Material t = block_t.getType();
                    if (l == 5 && BlockInfo.falling_block_types.contains(t) && Functions.checkConfig(world, "block-movement") == 1) {
                        int yc = y + 2;
                        boolean topfound = false;
                        while (!topfound) {
                            Block block_up = world.getBlockAt(x, yc, z);
                            Material up = block_up.getType();
                            if (!BlockInfo.falling_block_types.contains(up)) {
                                lc = new Location(world, (double)x, (double)(yc - 1), (double)z);
                                topfound = true;
                            }
                            ++yc;
                        }
                    }
                    if (!BlockInfo.track_any.contains(t)) {
                        if (l != 5 && !check_down) {
                            if (!BlockInfo.track_side.contains(t)) {
                                log = false;
                            } else if (type.equals((Object)Material.STONE_BUTTON) || type.equals((Object)Material.WOOD_BUTTON)) {
                                Block check = world.getBlockAt(lc);
                                check_data = Functions.getData(check);
                                if (check_data != l) {
                                    log = false;
                                }
                            } else if (t.equals((Object)Material.RAILS) || t.equals((Object)Material.POWERED_RAIL) || t.equals((Object)Material.DETECTOR_RAIL) || t.equals((Object)Material.ACTIVATOR_RAIL)) {
                                byte check_data2 = Functions.getData(block_t);
                                if (l == 1 && check_data2 != 3) {
                                    log = false;
                                } else if (l == 2 && check_data2 != 2) {
                                    log = false;
                                } else if (l == 3 && check_data2 != 4) {
                                    log = false;
                                } else if (l == 4 && check_data2 != 5) {
                                    log = false;
                                }
                            } else if (t.equals((Object)Material.BED_BLOCK) && !type.equals((Object)Material.BED_BLOCK)) {
                                log = false;
                            }
                        } else if (!BlockInfo.track_top.contains(t)) {
                            log = false;
                        }
                        if (!log) {
                            if (type.equals((Object)Material.PISTON_EXTENSION)) {
                                if (t.equals((Object)Material.PISTON_STICKY_BASE) || t.equals((Object)Material.PISTON_BASE)) {
                                    log = true;
                                }
                            } else if (l == 5 && BlockInfo.falling_block_types.contains(t)) {
                                log = true;
                            }
                        }
                    } else if (t.equals((Object)Material.PISTON_EXTENSION)) {
                        if (!type.equals((Object)Material.PISTON_STICKY_BASE) && !type.equals((Object)Material.PISTON_BASE)) {
                            log = false;
                        }
                    } else {
                        Block check = world.getBlockAt(lc);
                        check_data = Functions.getData(check);
                        if (check_data != l) {
                            log = false;
                        }
                    }
                    if (log) {
                        b = world.getBlockAt(lc);
                        bt = b.getType();
                        bd = Functions.getData(b);
                    }
                }
                BlockState b1 = b.getState();
                Material bt1 = bt;
                byte bd1 = bd;
                byte bn = l;
                if (log && (bt.equals((Object)Material.SKULL) || bt.equals((Object)Material.WALL_BANNER) || bt.equals((Object)Material.STANDING_BANNER))) {
                    try {
                        if (b1 instanceof Banner || b1 instanceof Skull) {
                            Queue.queueAdvancedBreak(player, b1, bt1, bd1, type, bn);
                        }
                        log = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (log && (bt.equals((Object)Material.SIGN_POST) || bt.equals((Object)Material.WALL_SIGN)) && Functions.checkConfig(world, "sign-text") == 1) {
                    try {
                        Sign sign = (Sign)b.getState();
                        String line1 = sign.getLine(0);
                        String line2 = sign.getLine(1);
                        String line3 = sign.getLine(2);
                        String line4 = sign.getLine(3);
                        Queue.queueSignText(player, b1, line1, line2, line3, line4, 5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (log) {
                    Database.containerBreakCheck(player, block.getType(), block, block.getLocation());
                    Functions.iceBreakCheck(b1, player, bt1);
                    Queue.queueBlockBreak(player, b1, bt1, bd1, type, bn);
                }
                ++l;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockBurn(BlockBurnEvent event) {
        World world = event.getBlock().getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "block-burn") == 1) {
            String player = "#fire";
            Block block = event.getBlock();
            Material type = block.getType();
            byte data = Functions.getData(event.getBlock());
            Queue.queueBlockBreak(player, block.getState(), type, data);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockFromTo(BlockFromToEvent event) {
        List<Material> flow_break;
        World world;
        Material type = event.getBlock().getType();
        Material type2 = event.getToBlock().getType();
        if (!event.isCancelled() && (Functions.checkConfig(world = event.getBlock().getWorld(), "water-flow") == 1 && (type.equals((Object)Material.WATER) || type.equals((Object)Material.STATIONARY_WATER)) || Functions.checkConfig(world, "lava-flow") == 1 && (type.equals((Object)Material.LAVA) || type.equals((Object)Material.STATIONARY_LAVA))) && ((flow_break = Arrays.asList(Material.AIR, Material.SAPLING, Material.POWERED_RAIL, Material.DETECTOR_RAIL, Material.WEB, Material.LONG_GRASS, Material.DEAD_BUSH, Material.YELLOW_FLOWER, Material.RED_ROSE, Material.BROWN_MUSHROOM, Material.RED_MUSHROOM, Material.TORCH, Material.FIRE, Material.REDSTONE_WIRE, Material.CROPS, Material.RAILS, Material.LEVER, Material.REDSTONE_TORCH_OFF, Material.REDSTONE_TORCH_ON, Material.STONE_BUTTON, Material.SNOW, Material.DIODE_BLOCK_OFF, Material.DIODE_BLOCK_ON, Material.VINE, Material.COCOA, Material.TRIPWIRE_HOOK, Material.TRIPWIRE, Material.CARROT, Material.POTATO, Material.WOOD_BUTTON, Material.SKULL, Material.REDSTONE_COMPARATOR_OFF, Material.REDSTONE_COMPARATOR_ON, Material.ACTIVATOR_RAIL, Material.CARPET, Material.DOUBLE_PLANT)).contains(type2) || (type.equals((Object)Material.WATER) || type.equals((Object)Material.STATIONARY_WATER)) && (type2.equals((Object)Material.LAVA) || type2.equals((Object)Material.STATIONARY_LAVA)) || (type.equals((Object)Material.LAVA) || type.equals((Object)Material.STATIONARY_LAVA)) && (type2.equals((Object)Material.WATER) || type2.equals((Object)Material.STATIONARY_WATER)))) {
            String p;
            String f = "#flow";
            if (type.equals((Object)Material.WATER) || type.equals((Object)Material.STATIONARY_WATER)) {
                f = "#water";
            } else if (type.equals((Object)Material.LAVA) || type.equals((Object)Material.STATIONARY_LAVA)) {
                f = "#lava";
            }
            Block block = event.getBlock();
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            int x = event.getToBlock().getX();
            int y = event.getToBlock().getY();
            int z = event.getToBlock().getZ();
            int wid = Functions.getWorldId(block.getWorld().getName());
            if (Functions.checkConfig(world, "liquid-tracking") == 1 && (p = Lookup.who_placed_cache(block)).length() > 0) {
                f = p;
            }
            Config.lookup_cache.put("" + x + "." + y + "." + z + "." + wid + "", new Object[]{unixtimestamp, f, type});
            Queue.queueBlockPlace(f, event.getToBlock(), event.getToBlock().getState(), type, (int)Functions.getData(event.getBlock()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockIgnite(BlockIgniteEvent event) {
        World world = event.getBlock().getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "block-ignite") == 1) {
            Block block = event.getBlock();
            if (block == null) {
                return;
            }
            if (event.getPlayer() == null) {
                Queue.queueBlockPlace("#fire", block.getState(), block.getState(), Material.FIRE);
            } else {
                Player player = event.getPlayer();
                Queue.queueBlockPlace(player.getName(), block.getState(), null, Material.FIRE);
                int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
                int world_id = Functions.getWorldId(block.getWorld().getName());
                Config.lookup_cache.put("" + block.getX() + "." + block.getY() + "." + block.getZ() + "." + world_id + "", new Object[]{unixtimestamp, player.getName(), block.getType()});
            }
        }
    }

    protected void onBlockPiston(BlockPistonEvent event) {
        List event_blocks = null;
        if (event instanceof BlockPistonExtendEvent) {
            event_blocks = ((BlockPistonExtendEvent)event).getBlocks();
        } else if (event instanceof BlockPistonRetractEvent) {
            event_blocks = ((BlockPistonRetractEvent)event).getBlocks();
        }
        World world = event.getBlock().getWorld();
        if (Functions.checkConfig(world, "pistons") == 1 && !event.isCancelled()) {
            ArrayList<Block> nblocks = new ArrayList<Block>();
            ArrayList<BlockState> blocks = new ArrayList<BlockState>();
            for (Block block : event_blocks) {
                Block block_relative = block.getRelative(event.getDirection());
                if (Functions.checkConfig(world, "block-movement") == 1) {
                    block_relative = Functions.fallingSand(block_relative, block.getState(), "#piston");
                }
                nblocks.add(block_relative);
                blocks.add(block.getState());
            }
            Block b = event.getBlock();
            BlockFace d = event.getDirection();
            Block bm = b.getRelative(d);
            int wid = Functions.getWorldId(bm.getWorld().getName());
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            boolean log = false;
            for (int l = 0; l <= nblocks.size(); ++l) {
                int ll = l - 1;
                Block n = null;
                n = ll == -1 ? bm : (Block)nblocks.get(ll);
                if (n == null) continue;
                int x = n.getX();
                int y = n.getY();
                int z = n.getZ();
                Material t = n.getType();
                String cords = "" + x + "." + y + "." + z + "." + wid + "." + t.name() + "";
                if (Config.piston_cache.get(cords) == null) {
                    log = true;
                }
                Config.piston_cache.put(cords, new Object[]{unixtimestamp});
            }
            if (log) {
                String e = "#piston";
                for (BlockState block : blocks) {
                    Queue.queueBlockBreak(e, block, block.getType(), Functions.getData(block));
                }
                int c = 0;
                for (Block nblock : nblocks) {
                    BlockState block = (BlockState)blocks.get(c);
                    Queue.queueBlockPlace(e, nblock.getState(), block.getType(), (int)Functions.getData(block));
                    ++c;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.onBlockPiston((BlockPistonEvent)event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.onBlockPiston((BlockPistonEvent)event);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockPlace(BlockPlaceEvent event) {
        World world = event.getBlockPlaced().getWorld();
        if (!event.isCancelled() && Functions.checkConfig(world, "block-place") == 1) {
            ItemStack item;
            Block b;
            Player player = event.getPlayer();
            Block block = b = event.getBlockPlaced();
            BlockState breplaced = event.getBlockReplacedState();
            Material force_type = null;
            int force_data = -1;
            boolean abort = false;
            Material block_type = b.getType();
            List<Material> stairs = Arrays.asList(Material.WOOD_STAIRS, Material.COBBLESTONE_STAIRS, Material.BRICK_STAIRS, Material.SMOOTH_STAIRS, Material.NETHER_BRICK_STAIRS, Material.SANDSTONE_STAIRS, Material.SPRUCE_WOOD_STAIRS, Material.BIRCH_WOOD_STAIRS, Material.JUNGLE_WOOD_STAIRS, Material.QUARTZ_STAIRS);
            List<Material> dir_blocks = Arrays.asList(Material.PISTON_STICKY_BASE, Material.PISTON_BASE, Material.DIODE_BLOCK_OFF, Material.SKULL, Material.REDSTONE_COMPARATOR_OFF);
            if (Functions.listContains(BlockInfo.containers, block_type) || Functions.listContains(dir_blocks, block_type) || Functions.listContains(stairs, block_type)) {
                Queue.queueBlockPlaceDelayed(player.getName(), block, breplaced, 0);
                abort = true;
            } else if (block_type.equals((Object)Material.FIRE) && !(item = event.getItemInHand()).getType().equals((Object)Material.FIRE)) {
                abort = true;
            }
            if (!abort) {
                if (Functions.checkConfig(world, "block-movement") == 1 && !(block = Functions.fallingSand(block, null, player.getName())).equals(b)) {
                    force_type = b.getType();
                }
                Queue.queueBlockPlace(player, block.getState(), b, breplaced, force_type, force_data);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    protected void onBlockSpread(BlockSpreadEvent event) {
        if (!event.isCancelled() && Functions.checkConfig(event.getBlock().getWorld(), "vine-growth") == 1) {
            Block block = event.getBlock();
            BlockState blockstate = event.getNewState();
            if (blockstate.getType().equals((Object)Material.VINE)) {
                Queue.queueBlockPlace("#vine", block.getState(), blockstate.getType(), (int)Functions.getData(blockstate));
            }
        }
    }
}

