/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.Functions;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.database.Database;
import net.coreprotect.model.Config;
import net.coreprotect.patch.Patch;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PurgeCommand
extends Consumer {
    protected static void runCommand(final CommandSender player, boolean permission, String[] args) {
        int resultc = args.length;
        final int seconds = CommandHandler.parseTime(args);
        if (Config.converter_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Upgrade in progress. Please try again later.");
            return;
        }
        if (Config.purge_running) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Purge in progress. Please try again later.");
            return;
        }
        if (!permission) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You do not have permission to do that.");
            return;
        }
        if (resultc <= 1) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co purge t:<time>\".");
            return;
        }
        if (seconds <= 0) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- Please use \"/co purge t:<time>\".");
            return;
        }
        if (player instanceof Player && seconds < 2592000) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You can only purge data older than 30 days.");
            return;
        }
        if (seconds < 86400) {
            player.sendMessage("\u00a73CoreProtect \u00a7f- You can only purge data older than 24 hours.");
            return;
        }
        class BasicThread
        implements Runnable {
            BasicThread() {
            }

            @Override
            public void run() {
                try {
                    int timestamp = (int)(System.currentTimeMillis() / 1000L);
                    int ptime = timestamp - seconds;
                    long removed = 0L;
                    Connection connection = null;
                    for (int i = 0; i <= 5 && (connection = Database.getConnection(false)) == null; ++i) {
                        Thread.sleep(1000L);
                    }
                    if (connection == null) {
                        Functions.messageOwnerAndUser(player, "Database busy. Please try again later.");
                        return;
                    }
                    Functions.messageOwnerAndUser(player, "Data purge started. This may take some time.");
                    Functions.messageOwnerAndUser(player, "Do not restart your server until completed.");
                    Config.purge_running = true;
                    while (!pause_success) {
                        Thread.sleep(1L);
                    }
                    Consumer.is_paused = true;
                    String query = "";
                    PreparedStatement preparedStmt = null;
                    boolean abort = false;
                    String purge_prefix = "tmp_" + Config.prefix;
                    if (Config.config.get("use-mysql") == 0) {
                        query = "ATTACH DATABASE '" + Config.sqlite + ".tmp' AS tmp_db";
                        preparedStmt = connection.prepareStatement(query);
                        preparedStmt.execute();
                        preparedStmt.close();
                        purge_prefix = "tmp_db." + Config.prefix;
                    }
                    String[] version_split = CoreProtect.getInstance().getDescription().getVersion().split("\\.");
                    Integer[] current_version = new Integer[]{Integer.parseInt(version_split[0]), Integer.parseInt(version_split[1]), Integer.parseInt(version_split[2])};
                    Integer[] last_version = Patch.getLastVersion(connection);
                    boolean newVersion = Functions.newVersion(last_version, current_version);
                    if (newVersion) {
                        Functions.messageOwnerAndUser(player, "Purge failed. Please try again later.");
                        Consumer.is_paused = false;
                        Config.purge_running = false;
                        return;
                    }
                    for (String table : Config.databaseTables) {
                        try {
                            query = "DROP TABLE IF EXISTS " + purge_prefix + table + "";
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Functions.createDatabaseTables(purge_prefix, true);
                    List<String> purge_tables = Arrays.asList("sign", "container", "skull", "session", "chat", "command", "block");
                    for (String table : Config.databaseTables) {
                        String tableName = table.replaceAll("_", " ");
                        Functions.messageOwnerAndUser(player, "Processing " + tableName + " data...");
                        String columns = "";
                        ResultSet rs = connection.createStatement().executeQuery("SELECT * FROM " + purge_prefix + table);
                        ResultSetMetaData resultSetMetaData = rs.getMetaData();
                        int columnCount = resultSetMetaData.getColumnCount();
                        for (int i = 1; i <= columnCount; ++i) {
                            String name = resultSetMetaData.getColumnName(i);
                            columns = columns.length() == 0 ? name : columns + "," + name;
                        }
                        rs.close();
                        boolean error = false;
                        try {
                            String time_limit = "";
                            if (purge_tables.contains(table)) {
                                time_limit = " WHERE time >= '" + ptime + "'";
                            }
                            query = "INSERT INTO " + purge_prefix + table + " SELECT " + columns + " FROM " + Config.prefix + table + time_limit;
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                        }
                        catch (Exception e) {
                            error = true;
                            e.printStackTrace();
                        }
                        if (error) {
                            Functions.messageOwnerAndUser(player, "Unable to process " + tableName + " data!");
                            Functions.messageOwnerAndUser(player, "Attempting to repair. This may take some time...");
                            try {
                                query = Config.config.get("use-mysql") == 1 ? "TRUNCATE TABLE " + purge_prefix + table : "DELETE FROM " + purge_prefix + table;
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                preparedStmt.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                query = "REINDEX " + Config.prefix + table;
                                if (Config.config.get("use-mysql") == 1) {
                                    query = "OPTIMIZE TABLE " + Config.prefix + table;
                                }
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                preparedStmt.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                String index = " USE INDEX ()";
                                if (Config.config.get("use-mysql") == 0) {
                                    index = " NOT INDEXED";
                                }
                                query = "INSERT INTO " + purge_prefix + table + " SELECT " + columns + " FROM " + Config.prefix + table + index;
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                preparedStmt.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                abort = true;
                                break;
                            }
                            if (purge_tables.contains(table)) {
                                try {
                                    query = "DELETE FROM " + purge_prefix + table + " WHERE time < '" + ptime + "'";
                                    preparedStmt = connection.prepareStatement(query);
                                    preparedStmt.execute();
                                    preparedStmt.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        int old_count = 0;
                        try {
                            query = "SELECT COUNT(*) as count FROM " + Config.prefix + table + " LIMIT 0, 1";
                            preparedStmt = connection.prepareStatement(query);
                            ResultSet resultSet = preparedStmt.executeQuery();
                            while (resultSet.next()) {
                                old_count = resultSet.getInt("count");
                            }
                            resultSet.close();
                            preparedStmt.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        int new_count = 0;
                        try {
                            query = "SELECT COUNT(*) as count FROM " + purge_prefix + table + " LIMIT 0, 1";
                            preparedStmt = connection.prepareStatement(query);
                            ResultSet resultSet = preparedStmt.executeQuery();
                            while (resultSet.next()) {
                                new_count = resultSet.getInt("count");
                            }
                            resultSet.close();
                            preparedStmt.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        removed += (long)(old_count - new_count);
                        if (Config.config.get("use-mysql") != 1) continue;
                        try {
                            query = "DROP TABLE IF EXISTS _" + purge_prefix + table;
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                            query = "RENAME TABLE " + Config.prefix + table + " TO _" + purge_prefix + table + ", " + purge_prefix + table + " TO " + Config.prefix + table + ", _" + purge_prefix + table + " TO " + purge_prefix + table;
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                            query = "DROP TABLE " + purge_prefix + table;
                            preparedStmt = connection.prepareStatement(query);
                            preparedStmt.execute();
                            preparedStmt.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (abort && Config.config.get("use-mysql") == 1) {
                        for (String table : Config.databaseTables) {
                            try {
                                query = "DROP TABLE IF EXISTS tmp_" + Config.prefix + table + "";
                                preparedStmt = connection.prepareStatement(query);
                                preparedStmt.execute();
                                preparedStmt.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    connection.close();
                    if (abort) {
                        if (Config.config.get("use-mysql") == 0) {
                            new File(Config.sqlite + ".tmp").delete();
                        }
                        Config.loadDatabase();
                        Functions.messageOwnerAndUser(player, "\u00a7cPurge failed. Database may be corrupt.");
                        Consumer.is_paused = false;
                        Config.purge_running = false;
                        return;
                    }
                    if (Config.config.get("use-mysql") == 0) {
                        new File(Config.sqlite).delete();
                        new File(Config.sqlite + ".tmp").renameTo(new File(Config.sqlite));
                        Functions.messageOwnerAndUser(player, "Indexing database. Please wait...");
                    }
                    Config.loadDatabase();
                    Functions.messageOwnerAndUser(player, "Data purge successful.");
                    Functions.messageOwnerAndUser(player, NumberFormat.getInstance().format(removed) + " row(s) of data deleted.");
                }
                catch (Exception e) {
                    Functions.messageOwnerAndUser(player, "Purge failed. Please try again later.");
                    e.printStackTrace();
                }
                Consumer.is_paused = false;
                Config.purge_running = false;
            }
        }
        BasicThread runnable = new BasicThread();
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

