/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.benchmark;

import java.io.PrintStream;
import org.jblas.Info;
import org.jblas.benchmark.Benchmark;
import org.jblas.benchmark.BenchmarkResult;
import org.jblas.benchmark.JavaDoubleMultiplicationBenchmark;
import org.jblas.benchmark.JavaFloatMultiplicationBenchmark;
import org.jblas.benchmark.NativeDoubleMultiplicationBenchmark;
import org.jblas.benchmark.NativeFloatMultiplicationBenchmark;
import org.jblas.util.ArchFlavor;
import org.jblas.util.Logger;
import org.jblas.util.SanityChecks;

public class Main {
    static Benchmark[] multiplicationBenchmarks = new Benchmark[]{new JavaDoubleMultiplicationBenchmark(), new JavaFloatMultiplicationBenchmark(), new NativeDoubleMultiplicationBenchmark(), new NativeFloatMultiplicationBenchmark()};

    public static void printHelp() {
        System.out.printf("Usage: benchmark [opts]%n%nwith options:%n%n  --arch-flavor=value     overriding arch flavor (e.g. --arch-flavor=sse2)%n  --skip-java             don't run java benchmarks%n  --help                  show this help%n  --debug                 set config levels to debug%n%njblas version " + Info.VERSION + "%n", new Object[0]);
    }

    public static void main(String[] args) {
        int[] multiplicationSizes = new int[]{10, 100, 1000};
        PrintStream out = System.out;
        boolean skipJava = false;
        boolean unrecognizedOptions = false;
        Logger log = Logger.getLogger();
        log.info("jblas version is " + Info.VERSION);
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = objectArray[n2];
            if (arg.startsWith("--")) {
                int i = arg.indexOf(61);
                String value = null;
                if (i != -1) {
                    value = arg.substring(i + 1);
                    arg = arg.substring(0, i);
                }
                if (arg.equals("--arch-flavor")) {
                    Logger.getLogger().info("Setting arch flavor to " + value);
                    ArchFlavor.overrideArchFlavor(value);
                } else if (arg.equals("--skip-java")) {
                    skipJava = true;
                } else {
                    if (arg.equals("--help")) {
                        Main.printHelp();
                        return;
                    }
                    if (arg.equals("--debug")) {
                        Logger.getLogger().setLevel(1);
                    } else {
                        Logger.getLogger().warning("Unrecognized option \"" + arg + "\"");
                        unrecognizedOptions = true;
                    }
                }
            }
            ++n2;
        }
        if (unrecognizedOptions) {
            return;
        }
        out.println("Simple benchmark for jblas");
        out.println();
        out.println("Running sanity benchmarks.");
        out.println();
        SanityChecks.main(args);
        out.println();
        out.println("Each benchmark will take about 5 seconds...");
        objectArray = multiplicationBenchmarks;
        n = multiplicationBenchmarks.length;
        n2 = 0;
        while (n2 < n) {
            Object b = objectArray[n2];
            if (!skipJava || !b.getName().contains("Java")) {
                out.println();
                out.println("Running benchmark \"" + b.getName() + "\".");
                int[] nArray = multiplicationSizes;
                int n3 = multiplicationSizes.length;
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = nArray[n4];
                    out.printf("n = %-5d: ", n5);
                    out.flush();
                    BenchmarkResult result = b.run(n5, 5.0);
                    result.printResult();
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

