/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.serializetools;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class Utf8YamlConfiguration
extends YamlConfiguration {
    public static Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public void load(InputStream stream) throws IOException, InvalidConfigurationException {
        Validate.notNull((Object)stream, (String)"Stream cannot be null");
        InputStreamReader reader = new InputStreamReader(stream, UTF8_CHARSET);
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = new BufferedReader(reader);){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    public void save(File file) throws IOException {
        Validate.notNull((Object)file, (String)"File cannot be null");
        Files.createParentDirs((File)file);
        String data = this.saveToString();
        FileOutputStream stream = new FileOutputStream(file);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, UTF8_CHARSET);){
            writer.write(data);
        }
    }
}

