/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase.commands;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.generallib.pluginbase.PluginBase;
import org.generallib.pluginbase.PluginLanguage;
import org.generallib.pluginbase.commands.SubCommand;
import org.generallib.pluginbase.language.DefaultLanguages;

public class SubCommandHelp
extends SubCommand {
    public SubCommandHelp(PluginBase base, String permission) {
        super(base, permission, DefaultLanguages.Command_Help_Description, new PluginLanguage.Language[]{DefaultLanguages.Command_Help_Usage}, -1, "help", new String[0]);
    }

    @Override
    protected boolean executeConsole(CommandSender sender, String[] args) {
        int page = 0;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
                --page;
            }
            catch (NumberFormatException e) {
                this.base.lang.addString(args[0]);
                this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.General_NotANumber);
                return true;
            }
        }
        this.show(sender, page);
        return true;
    }

    @Override
    protected boolean executeOp(Player op, String[] args) {
        int page = 0;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
                --page;
            }
            catch (NumberFormatException e) {
                this.base.lang.addString(args[0]);
                this.base.sendMessage(op, (PluginLanguage.Language)DefaultLanguages.General_NotANumber);
                return true;
            }
        }
        this.show((CommandSender)op, page);
        return true;
    }

    @Override
    protected boolean executeUser(Player player, String[] args) {
        int page = 0;
        if (args.length > 0) {
            try {
                page = Integer.parseInt(args[0]);
                --page;
            }
            catch (NumberFormatException e) {
                this.base.lang.addString(args[0]);
                this.base.sendMessage(player, (PluginLanguage.Language)DefaultLanguages.General_NotANumber);
                return true;
            }
        }
        this.show((CommandSender)player, page);
        return true;
    }

    private void show(CommandSender sender, int page) {
        this.base.executor.showHelp(sender, page);
    }
}

