/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase.commands;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.generallib.database.tasks.DatabaseTransferTask;
import org.generallib.pluginbase.PluginBase;
import org.generallib.pluginbase.PluginLanguage;
import org.generallib.pluginbase.PluginManager;
import org.generallib.pluginbase.commands.SubCommandAdmin;
import org.generallib.pluginbase.language.DefaultLanguages;

public class SubCommandAdminImport
extends SubCommandAdmin {
    public SubCommandAdminImport(PluginBase base, String permission) {
        super(base, permission, DefaultLanguages.Command_Import_Description, new PluginLanguage.Language[]{DefaultLanguages.Command_Import_Usage}, 1, "import", new String[0]);
    }

    @Override
    protected boolean executeConsole(CommandSender sender, String[] args) {
        String fromName = args[0];
        HashSet<DatabaseTransferTask.TransferPair> pairs = new HashSet<DatabaseTransferTask.TransferPair>();
        for (Map.Entry<Class<? extends PluginManager>, PluginManager> entry : this.base.getPluginManagers().entrySet()) {
            Set<String> allowedTypes = entry.getValue().getValidDBTypes();
            if (!allowedTypes.contains(fromName)) {
                this.base.getLogger().severe(String.valueOf(entry.getKey().getSimpleName()) + "@Invalid db type -- " + fromName);
                return false;
            }
            Set<DatabaseTransferTask.TransferPair> pair = entry.getValue().getTransferPair(fromName);
            if (pair == null) continue;
            pairs.addAll(pair);
        }
        new Thread(new DatabaseTransferTask((Plugin)this.base, pairs)).start();
        return true;
    }
}

