/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase.api;

import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.generallib.pluginbase.PluginAPISupport;
import org.generallib.pluginbase.PluginBase;

public class VaultSupport
extends PluginAPISupport.APISupport {
    public Permission permission = null;
    public Economy economy = null;
    public Chat chat = null;

    public VaultSupport(PluginBase base) {
        super(base);
    }

    @Override
    public void init() throws Exception {
        if (this.setupPermissions()) {
            this.base.getLogger().info("Vault permission hooked.");
        }
        if (this.setupChat()) {
            this.base.getLogger().info("Vault chat hooked.");
        }
        if (this.setupEconomy()) {
            this.base.getLogger().info("Vault economy hooked.");
        }
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider permissionProvider = this.base.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            this.permission = (Permission)permissionProvider.getProvider();
        }
        return this.permission != null;
    }

    private boolean setupChat() {
        RegisteredServiceProvider chatProvider = this.base.getServer().getServicesManager().getRegistration(Chat.class);
        if (chatProvider != null) {
            this.chat = (Chat)chatProvider.getProvider();
        }
        return this.chat != null;
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.base.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        return this.economy != null;
    }
}

