/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.chatlib.main.ChatLibAPI;
import org.chatlib.utils.chat.JsonMessage;
import org.chatlib.utils.chat.JsonMessagePlain;
import org.chatlib.utils.chat.handlers.JsonMessageClickEvent;
import org.chatlib.utils.chat.handlers.JsonMessageHoverEvent;
import org.generallib.pluginbase.PluginBase;
import org.generallib.pluginbase.PluginConfig;
import org.generallib.pluginbase.PluginLanguage;
import org.generallib.pluginbase.PluginProcedure;
import org.generallib.pluginbase.commands.SubCommand;
import org.generallib.pluginbase.commands.SubCommandAdminReload;
import org.generallib.pluginbase.commands.SubCommandHelp;
import org.generallib.pluginbase.language.DefaultLanguages;

public final class PluginCommandExecutor
implements PluginProcedure {
    private PluginBase base;
    public final String mainCommand;
    public final String adminPermission;
    private SubCommandMap commandMap;
    private final Queue<Runnable> commandAddQueue = new LinkedList<Runnable>();
    private final Map<String, SubCommand> commandList = new LinkedHashMap<String, SubCommand>();
    private final Map<String, String> aliasMap = new HashMap<String, String>();

    protected PluginCommandExecutor(String mainCommand, String adminPermission) {
        this.mainCommand = mainCommand;
        this.adminPermission = adminPermission;
    }

    @Override
    public void onEnable(PluginBase base) throws Exception {
        this.base = base;
        this.commandMap = new SubCommandMap();
        this.addCommand(new SubCommandAdminReload(base, this.adminPermission));
        this.addCommand(new SubCommandHelp(base, null));
        while (!this.commandAddQueue.isEmpty()) {
            Runnable run = this.commandAddQueue.poll();
            run.run();
        }
    }

    @Override
    public void onDisable(PluginBase base) throws Exception {
    }

    @Override
    public void onReload(PluginBase base) throws Exception {
    }

    public void addCommand(final SubCommand cmd) {
        this.commandAddQueue.add(new Runnable(){

            @Override
            public void run() {
                PluginCommandExecutor.this.commandMap.register(null, cmd);
            }
        });
    }

    public boolean onCommand(CommandSender sender, Command arg0, String label, String[] args) {
        if (!label.equalsIgnoreCase(this.mainCommand)) {
            // empty if block
        }
        String cmdLine = "";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            cmdLine = String.valueOf(cmdLine) + str + " ";
            ++n2;
        }
        this.commandMap.dispatch(sender, cmdLine);
        return true;
    }

    public void showHelp(CommandSender sender, int page) {
        ArrayList<SubCommand> list = new ArrayList<SubCommand>();
        for (Map.Entry<String, SubCommand> entry : this.commandList.entrySet()) {
            SubCommand cmd = entry.getValue();
            if (!cmd.testPermissionSilent(sender)) continue;
            list.add(cmd);
        }
        this.base.lang.addString(this.base.getDescription().getName());
        this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.General_Header);
        sender.sendMessage("");
        int max = ((PluginConfig)this.base.getPluginConfig()).Command_Help_SentencePerPage;
        int remainder = list.size() % ((PluginConfig)this.base.getPluginConfig()).Command_Help_SentencePerPage;
        int divided = list.size() / ((PluginConfig)this.base.getPluginConfig()).Command_Help_SentencePerPage;
        int outof = remainder == 0 ? divided : divided + 1;
        page = Math.max(page, 0);
        page = Math.min(page, outof - 1);
        int index = page * max;
        while (index >= 0 && index < (page + 1) * max) {
            int n;
            if (index >= list.size()) break;
            SubCommand c = (SubCommand)list.get(index);
            ChatColor color = ChatColor.GOLD;
            color = c.getCommandColor();
            String desc = this.base.lang.parseFirstString(sender, c.getDescription());
            this.base.lang.addString(color + c.toString());
            this.base.lang.addString(desc);
            if (this.base.APISupport.isHooked("ChatLib")) {
                if (sender instanceof Player) {
                    ChatLibAPI.sendJsonMessage((Player)((Player)sender), (String)ChatLibAPI.toJsonString((JsonMessage[])new JsonMessage[]{new JsonMessagePlain(this.base.lang.parseFirstString(sender, DefaultLanguages.Command_Format_Description), c, sender){
                        {
                            StringBuilder builder = new StringBuilder();
                            StringBuilder builderAliases = new StringBuilder();
                            Object[] objectArray = subCommand.getAliases();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String alias = objectArray[n2];
                                builderAliases.append(" " + alias);
                                ++n2;
                            }
                            ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(builderAliases.toString());
                            builder.append(String.valueOf(((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.parseFirstString(commandSender, DefaultLanguages.Command_Format_Aliases)) + "\n");
                            builder.append("/" + PluginCommandExecutor.this.mainCommand + " " + subCommand.toString() + " ");
                            objectArray = subCommand.getUsage();
                            n = objectArray.length;
                            n2 = 0;
                            while (n2 < n) {
                                Object lang = objectArray[n2];
                                builder.append(String.valueOf(((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.parseFirstString(commandSender, (PluginLanguage.Language)lang)) + "\n");
                                ++n2;
                            }
                            this.setHoverEvent(new JsonMessageHoverEvent(JsonMessageHoverEvent.HoverAction.show_text, builder.toString()));
                            this.setClickEvent(new JsonMessageClickEvent(JsonMessageClickEvent.ClickAction.suggest_command, "/" + PluginCommandExecutor.this.mainCommand + " " + subCommand.toString() + " "));
                        }
                    }}));
                } else {
                    this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.Command_Format_Description);
                    StringBuilder builder = new StringBuilder();
                    Object[] objectArray = c.getAliases();
                    int n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        String alias = objectArray[n];
                        builder.append(" " + alias);
                        ++n;
                    }
                    this.base.lang.addString(builder.toString());
                    this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.Command_Format_Aliases);
                    objectArray = c.getUsage();
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        Object lang = objectArray[n];
                        String usage = this.base.lang.parseFirstString(sender, (PluginLanguage.Language)lang);
                        this.base.lang.addString(c.getName());
                        this.base.lang.addString(usage);
                        this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.Command_Format_Usage);
                        ++n;
                    }
                }
            } else {
                this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.Command_Format_Description);
                PluginLanguage.Language[] languageArray = c.getUsage();
                n = languageArray.length;
                int lang = 0;
                while (lang < n) {
                    PluginLanguage.Language lang2 = languageArray[lang];
                    String usage = this.base.lang.parseFirstString(sender, lang2);
                    this.base.lang.addString(c.getName());
                    this.base.lang.addString(usage);
                    this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.Command_Format_Usage);
                    ++lang;
                }
            }
            ++index;
        }
        sender.sendMessage("" + ChatColor.LIGHT_PURPLE);
        this.base.lang.addInteger(page + 1);
        this.base.lang.addInteger(outof);
        this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.Command_Help_PageDescription);
        this.base.sendMessage(sender, (PluginLanguage.Language)DefaultLanguages.Command_Help_TypeHelpToSeeMore);
        if (this.base.APISupport.isHooked("ChatLib") && sender instanceof Player) {
            String leftArrow = ChatColor.DARK_GRAY + "[" + ChatColor.GREEN + "<---" + ChatColor.DARK_GRAY + "]";
            String home = ChatColor.DARK_GRAY + "[" + ChatColor.YELLOW + "Home" + ChatColor.DARK_GRAY + "]";
            String rightArrow = ChatColor.DARK_GRAY + "[" + ChatColor.GREEN + "--->" + ChatColor.DARK_GRAY + "]";
            String previousCmd = "/" + this.mainCommand + " help " + page;
            String homeCmd = "/" + this.mainCommand + " help ";
            String nextCmd = "/" + this.mainCommand + " help " + (page + 2);
            ChatLibAPI.sendJsonMessage((Player)((Player)sender), (String)ChatLibAPI.toJsonString((JsonMessage[])new JsonMessage[]{new JsonMessagePlain(leftArrow, previousCmd){
                {
                    this.setHoverEvent(new JsonMessageHoverEvent(JsonMessageHoverEvent.HoverAction.show_text, string));
                    this.setClickEvent(new JsonMessageClickEvent(JsonMessageClickEvent.ClickAction.run_command, string));
                }
            }, new JsonMessagePlain(home, homeCmd){
                {
                    this.setHoverEvent(new JsonMessageHoverEvent(JsonMessageHoverEvent.HoverAction.show_text, string));
                    this.setClickEvent(new JsonMessageClickEvent(JsonMessageClickEvent.ClickAction.run_command, string));
                }
            }, new JsonMessagePlain(rightArrow, nextCmd){
                {
                    this.setHoverEvent(new JsonMessageHoverEvent(JsonMessageHoverEvent.HoverAction.show_text, string));
                    this.setClickEvent(new JsonMessageClickEvent(JsonMessageClickEvent.ClickAction.run_command, string));
                }
            }}));
        }
        sender.sendMessage("" + ChatColor.GRAY);
    }

    private class SubCommandMap {
        private SubCommandMap() {
        }

        public void clearCommands() {
            PluginCommandExecutor.this.commandList.clear();
            PluginCommandExecutor.this.aliasMap.clear();
        }

        public boolean dispatch(CommandSender arg0, String arg1) throws CommandException {
            String[] split = arg1.split(" ");
            String cmd = split[0];
            if (PluginCommandExecutor.this.aliasMap.containsKey(cmd)) {
                cmd = (String)PluginCommandExecutor.this.aliasMap.get(cmd);
            }
            String[] args = new String[split.length - 1];
            int i = 1;
            while (i < split.length) {
                args[i - 1] = split[i];
                ++i;
            }
            SubCommand command = (SubCommand)PluginCommandExecutor.this.commandList.get(cmd);
            if (command != null) {
                if (command.getArguments() != -1 && command.getArguments() != args.length) {
                    ChatColor color = command.getCommandColor();
                    String desc = ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.parseFirstString(arg0, command.getDescription());
                    ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(color + command.toString());
                    ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(desc);
                    PluginCommandExecutor.this.base.sendMessage(arg0, (PluginLanguage.Language)DefaultLanguages.Command_Format_Description);
                    StringBuilder builder = new StringBuilder();
                    Object[] objectArray = command.getAliases();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String alias = objectArray[n2];
                        builder.append(" " + alias);
                        ++n2;
                    }
                    ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(builder.toString());
                    PluginCommandExecutor.this.base.sendMessage(arg0, (PluginLanguage.Language)DefaultLanguages.Command_Format_Aliases);
                    objectArray = command.getUsage();
                    n = objectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object lang = objectArray[n2];
                        String usage = ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.parseFirstString(arg0, (PluginLanguage.Language)lang);
                        ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(command.getName());
                        ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(usage);
                        PluginCommandExecutor.this.base.sendMessage(arg0, (PluginLanguage.Language)DefaultLanguages.Command_Format_Usage);
                        ++n2;
                    }
                    return true;
                }
                if (command.getPermission() != null && !arg0.hasPermission(command.getPermission())) {
                    PluginCommandExecutor.this.base.sendMessage(arg0, (PluginLanguage.Language)DefaultLanguages.General_NotEnoughPermission);
                    return true;
                }
                boolean result = command.execute(arg0, cmd, args);
                if (!result) {
                    ChatColor color = command.getCommandColor();
                    String desc = ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.parseFirstString(arg0, command.getDescription());
                    ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(color + command.toString());
                    ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(desc);
                    PluginCommandExecutor.this.base.sendMessage(arg0, (PluginLanguage.Language)DefaultLanguages.Command_Format_Description);
                    StringBuilder builder = new StringBuilder();
                    Object[] objectArray = command.getAliases();
                    int n = objectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String alias = objectArray[n3];
                        builder.append(" " + alias);
                        ++n3;
                    }
                    ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(builder.toString());
                    PluginCommandExecutor.this.base.sendMessage(arg0, (PluginLanguage.Language)DefaultLanguages.Command_Format_Aliases);
                    objectArray = command.getUsage();
                    n = objectArray.length;
                    n3 = 0;
                    while (n3 < n) {
                        Object lang = objectArray[n3];
                        String usage = ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.parseFirstString(arg0, (PluginLanguage.Language)lang);
                        ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(command.getName());
                        ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(usage);
                        PluginCommandExecutor.this.base.sendMessage(arg0, (PluginLanguage.Language)DefaultLanguages.Command_Format_Usage);
                        ++n3;
                    }
                }
                return true;
            }
            if (cmd.equals("")) {
                return this.dispatch(arg0, "help");
            }
            ((PluginCommandExecutor)PluginCommandExecutor.this).base.lang.addString(cmd);
            PluginCommandExecutor.this.base.sendMessage(arg0, (PluginLanguage.Language)DefaultLanguages.General_NoSuchCommand);
            return true;
        }

        public SubCommand getCommand(String arg0) {
            return (SubCommand)PluginCommandExecutor.this.commandList.get(arg0);
        }

        public boolean register(String arg0, SubCommand arg1) {
            String[] aliases = arg1.getAliases();
            if (aliases != null) {
                String[] stringArray = aliases;
                int n = aliases.length;
                int n2 = 0;
                while (n2 < n) {
                    String alias = stringArray[n2];
                    PluginCommandExecutor.this.aliasMap.put(alias, arg1.getName());
                    ++n2;
                }
            }
            if (PluginCommandExecutor.this.commandList.containsKey(arg1.getName())) {
                return false;
            }
            PluginCommandExecutor.this.commandList.put(arg1.getName(), arg1);
            return true;
        }

        public boolean register(String arg0, String arg1, SubCommand arg2) {
            if (PluginCommandExecutor.this.commandList.containsKey(arg0)) {
                return false;
            }
            PluginCommandExecutor.this.commandList.put(arg0, arg2);
            return true;
        }

        public void registerAll(String arg0, List<SubCommand> arg1) {
            for (SubCommand cmd : arg1) {
                this.register(null, cmd);
            }
        }

        public List<String> tabComplete(CommandSender arg0, String arg1) throws IllegalArgumentException {
            return null;
        }
    }
}

