/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.pluginbase;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.generallib.pluginbase.PluginBase;
import org.generallib.pluginbase.PluginProcedure;
import org.generallib.pluginbase.api.VaultSupport;

public final class PluginAPISupport
implements PluginProcedure {
    private final Queue<Runnable> hookQueue = new LinkedList<Runnable>();
    final Map<String, APISupport> apis = new HashMap<String, APISupport>();
    private PluginBase base;

    public PluginAPISupport() {
        this.hookAPI("ChatLib");
        this.hookAPI("UserInterfaceLib");
        this.hookAPI("SkillsLib");
        this.hookAPI("Vault", VaultSupport.class);
    }

    @Override
    public void onEnable(PluginBase base) throws Exception {
        this.base = base;
        while (!this.hookQueue.isEmpty()) {
            Runnable run = this.hookQueue.poll();
            run.run();
        }
    }

    @Override
    public void onDisable(PluginBase base) throws Exception {
    }

    @Override
    public void onReload(PluginBase base) throws Exception {
    }

    public void hookAPI(final String pluginName, final Class<? extends APISupport> api) {
        this.hookQueue.add(new Runnable(){

            @Override
            public void run() {
                PluginManager pm = PluginAPISupport.this.base.getServer().getPluginManager();
                Plugin plugin = pm.getPlugin(pluginName);
                if (plugin != null && plugin.isEnabled()) {
                    PluginAPISupport.this.base.getLogger().info("Hooked Plugin [" + pluginName + "]");
                    PluginAPISupport.this.base.getLogger().info("Info: " + plugin.getDescription().getFullName());
                    if (api != null) {
                        try {
                            Constructor con = api.getConstructor(PluginBase.class);
                            APISupport supp = (APISupport)con.newInstance(new Object[]{PluginAPISupport.this.base});
                            supp.init();
                            pm.registerEvents((Listener)supp, (Plugin)PluginAPISupport.this.base);
                            PluginAPISupport.this.apis.put(pluginName, supp);
                        }
                        catch (Exception e) {
                            PluginAPISupport.this.base.getLogger().severe("Failed to initialize [" + pluginName + "]");
                            PluginAPISupport.this.base.getLogger().severe(e.getMessage());
                        }
                    } else {
                        PluginAPISupport.this.apis.put(pluginName, new APISupport(PluginAPISupport.this.base){

                            @Override
                            public void init() throws Exception {
                            }
                        });
                    }
                }
            }
        });
    }

    public void hookAPI(String pluginName) {
        this.hookAPI(pluginName, null);
    }

    public boolean isExist(String pluginName) {
        return this.base.getServer().getPluginManager().getPlugin(pluginName) != null;
    }

    public boolean isHooked(String pluginName) {
        return this.apis.containsKey(pluginName);
    }

    public <T extends APISupport> T getAPI(String pluginName) {
        return (T)this.apis.get(pluginName);
    }

    public static abstract class APISupport
    implements Listener {
        protected final PluginBase base;

        public APISupport(PluginBase base) {
            this.base = base;
        }

        public abstract void init() throws Exception;
    }
}

