/*
 * Decompiled with CFR 0.152.
 */
package org.generallib.database.mysql;

import com.mysql.jdbc.jdbc2.optional.MysqlConnectionPoolDataSource;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import org.generallib.database.Database;
import org.generallib.database.mysql.MiniConnectionPoolManager;

public class DatabaseMysql<T>
extends Database<T> {
    private final Type type;
    private String dbName;
    private String tablename;
    private final String KEY = "dbkey";
    private final String VALUE = "dbval";
    private final MysqlConnectionPoolDataSource ds;
    private final MiniConnectionPoolManager pool;
    private final String CREATEDATABASEQUARY = "CREATE DATABASE IF NOT EXISTS %s";
    private final String CREATETABLEQUARY = "CREATE TABLE IF NOT EXISTS %s (dbkey CHAR(128) PRIMARY KEY,dbval MEDIUMBLOB)";
    private final String SELECTKEY = "SELECT dbval FROM %s WHERE dbkey = ?";
    private final String UPDATEQUARY = "INSERT INTO %s VALUES (?,?) ON DUPLICATE KEY UPDATE dbval = VALUES(dbval)";
    private final String DELETEQUARY = "DELETE FROM %s WHERE dbkey = ?";
    private final String SELECTKEYS = "SELECT dbkey FROM %s";
    private final String SELECTKEYSWHERE = "SELECT dbkey FROM %s WHERE dbkey = ?";

    public DatabaseMysql(String address, String dbName, String tablename, String userName, String password, Type type) throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, NamingException {
        this.type = type;
        this.dbName = dbName;
        this.tablename = tablename;
        this.ds = new MysqlConnectionPoolDataSource();
        this.ds.setURL("jdbc:mysql://" + address + "/" + dbName);
        this.ds.setUser(userName);
        this.ds.setPassword(password);
        this.ds.setCharacterEncoding("UTF-8");
        this.ds.setUseUnicode(true);
        this.ds.setAutoReconnectForPools(true);
        this.ds.setAutoReconnect(true);
        this.ds.setAutoReconnectForConnectionPools(true);
        this.pool = new MiniConnectionPoolManager((ConnectionPoolDataSource)this.ds, 4);
        Connection conn = this.createConnection();
        this.initTable(conn);
        conn.close();
    }

    private Connection createConnection() {
        Connection conn = null;
        try {
            try {
                conn = this.pool.getConnection();
            }
            catch (SQLException sQLException) {
                if (conn == null) {
                    conn = this.pool.getValidConnection();
                }
            }
        }
        finally {
            if (conn == null) {
                conn = this.pool.getValidConnection();
            }
        }
        return conn;
    }

    private void initTable(Connection conn) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement(String.format("CREATE TABLE IF NOT EXISTS %s (dbkey CHAR(128) PRIMARY KEY,dbval MEDIUMBLOB)", this.tablename));
        pstmt.executeUpdate();
        pstmt.close();
    }

    @Override
    public T load(String key, T def) {
        Object result;
        block15: {
            Connection conn = null;
            result = def;
            try {
                try {
                    conn = this.createConnection();
                    PreparedStatement pstmt = conn.prepareStatement(String.format("SELECT dbval FROM %s WHERE dbkey = ?", this.tablename));
                    pstmt.setString(1, key);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        InputStream input = rs.getBinaryStream("dbval");
                        InputStreamReader isr = new InputStreamReader(input, StandardCharsets.UTF_8);
                        BufferedReader br = new BufferedReader(isr);
                        String ser = br.readLine();
                        result = this.deserialize(ser, this.type);
                    }
                    pstmt.close();
                }
                catch (IOException | SQLException e) {
                    e.printStackTrace();
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block15;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public synchronized void save(String key, T value) {
        block14: {
            Connection conn = null;
            try {
                try {
                    conn = this.createConnection();
                    if (value != null) {
                        String ser = this.serialize(value, this.type);
                        ByteArrayInputStream input = new ByteArrayInputStream(ser.getBytes(StandardCharsets.UTF_8));
                        PreparedStatement pstmt = conn.prepareStatement(String.format("INSERT INTO %s VALUES (?,?) ON DUPLICATE KEY UPDATE dbval = VALUES(dbval)", this.tablename));
                        pstmt.setString(1, key);
                        pstmt.setBinaryStream(2, input);
                        pstmt.executeUpdate();
                        pstmt.close();
                        break block14;
                    }
                    PreparedStatement pstmt = conn.prepareStatement(String.format("DELETE FROM %s WHERE dbkey = ?", this.tablename));
                    pstmt.setString(1, key);
                    pstmt.executeUpdate();
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        Connection conn = null;
        try {
            try {
                conn = this.createConnection();
                PreparedStatement pstmt = conn.prepareStatement(String.format("SELECT dbkey FROM %s", this.tablename));
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    keys.add(rs.getString("dbkey"));
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return keys;
    }

    @Override
    public boolean has(String key) {
        boolean result = false;
        Connection conn = null;
        try {
            conn = this.createConnection();
            PreparedStatement pstmt = conn.prepareStatement(String.format("SELECT dbkey FROM %s WHERE dbkey = ?", this.tablename));
            pstmt.setString(1, key);
            ResultSet rs = pstmt.executeQuery();
            result = rs.next();
            rs.close();
            pstmt.close();
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void finalize() throws Throwable {
        if (this.pool != null) {
            this.pool.dispose();
        }
        super.finalize();
    }
}

