/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars.controls;

import com.useful.ucars.controls.ControlScheme;
import com.useful.ucars.ucars;
import com.useful.ucarsCommon.StatValue;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ControlSchemeManager {
    public static final String CONTROL_TYPE_META = "ucarsControlScheme";
    public static final String CONTROL_LOCK_META = "ucarsControlsLocked";

    public static ControlScheme getScheme(Player player) {
        if (!player.hasMetadata(CONTROL_TYPE_META)) {
            return ControlScheme.getDefault();
        }
        try {
            return (ControlScheme)((Object)((MetadataValue)player.getMetadata(CONTROL_TYPE_META).get(0)).value());
        }
        catch (Exception e) {
            player.removeMetadata(CONTROL_TYPE_META, (Plugin)ucars.plugin);
            return ControlScheme.getDefault();
        }
    }

    public static void setControlScheme(Player player, ControlScheme scheme) {
        player.removeMetadata(CONTROL_TYPE_META, (Plugin)ucars.plugin);
        player.setMetadata(CONTROL_TYPE_META, (MetadataValue)new StatValue((Object)scheme, (Plugin)ucars.plugin));
    }

    public static ControlScheme toggleControlScheme(Player player) {
        ControlScheme newScheme = ControlSchemeManager.getScheme(player).getNext();
        ControlSchemeManager.setControlScheme(player, newScheme);
        newScheme.showInfo(player);
        return newScheme;
    }

    public static boolean isControlsLocked(Player player) {
        return player.hasMetadata(CONTROL_LOCK_META);
    }

    public static void setControlsLocked(Player player, boolean locked) {
        player.removeMetadata(CONTROL_LOCK_META, (Plugin)ucars.plugin);
        if (locked) {
            player.setMetadata(CONTROL_LOCK_META, (MetadataValue)new StatValue(null, (Plugin)ucars.plugin));
        }
    }
}

