/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.upgrade;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class UpgradeManager
extends ConfigLoader {
    private final Set<UpgradeType> setNeededUpgrades = EnumSet.allOf(UpgradeType.class);

    public UpgradeManager() {
        super("upgrades.yml");
        this.loadKeys();
    }

    public boolean shouldUpgrade(UpgradeType type) {
        return this.setNeededUpgrades.contains((Object)type);
    }

    public void setUpgradeCompleted(UpgradeType type) {
        if (!this.setNeededUpgrades.remove((Object)type)) {
            return;
        }
        plugin.debug("Saving upgrade status for type " + type.toString() + "...");
        this.config.set("Upgrades_Finished." + type.toString(), (Object)true);
        try {
            this.config.save(this.getFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void loadKeys() {
        for (UpgradeType type : UpgradeType.values()) {
            if (!this.config.getBoolean("Upgrades_Finished." + type.toString())) continue;
            this.setNeededUpgrades.remove((Object)type);
        }
        plugin.debug("Needed upgrades: " + Arrays.toString((Object[])this.setNeededUpgrades.toArray(new UpgradeType[this.setNeededUpgrades.size()])));
    }
}

